/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Allele-specific root-mean-square of the mapping quality of reads across all samples (AS_MQ)")
public final class AS_RMSMappingQuality
extends InfoFieldAnnotation
implements AS_StandardAnnotation,
ReducibleAnnotation,
AlleleSpecificAnnotation {
    private final String printFormat = "%.2f";
    private static final OneShotLogger allele_logger = new OneShotLogger(AS_RMSMappingQuality.class);
    private static final OneShotLogger genotype_logger = new OneShotLogger(AS_RMSMappingQuality.class);

    @Override
    public String getPrimaryRawKey() {
        return "AS_RAW_MQ";
    }

    @Override
    public boolean hasSecondaryRawKeys() {
        return false;
    }

    @Override
    public List<String> getSecondaryRawKeys() {
        return null;
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        ReducibleAnnotationData<Double> myData = new ReducibleAnnotationData<Double>(null);
        this.getRMSDataFromLikelihoods(likelihoods, myData);
        String annotationString = this.makeFinalizedAnnotationString(vc, myData.getAttributeMap());
        annotations.put(this.getKeyNames().get(0), annotationString);
        return annotations;
    }

    @Override
    public Map<String, Object> annotateRawData(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> annotations = new LinkedHashMap<String, Object>();
        ReducibleAnnotationData<Double> myData = new ReducibleAnnotationData<Double>(null);
        this.getRMSDataFromLikelihoods(likelihoods, myData);
        String annotationString = this.makeRawAnnotationString(vc.getAlleles(), myData.getAttributeMap());
        annotations.put(this.getPrimaryRawKey(), annotationString);
        return annotations;
    }

    public void calculateRawData(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, ReducibleAnnotationData myData) {
        if (likelihoods == null) {
            return;
        }
        this.getRMSDataFromLikelihoods(likelihoods, myData);
    }

    @Override
    public Map<String, Object> combineRawData(List<Allele> vcAlleles, List<ReducibleAnnotationData<?>> annotationList) {
        AlleleSpecificAnnotationData<Double> combinedData = new AlleleSpecificAnnotationData<Double>(vcAlleles, null);
        Iterator<ReducibleAnnotationData<?>> iterator = annotationList.iterator();
        while (iterator.hasNext()) {
            ReducibleAnnotationData<Double> currentValue;
            ReducibleAnnotationData<Double> value = currentValue = iterator.next();
            this.parseRawDataString(value);
            this.combineAttributeMap(value, combinedData);
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        String annotationString = this.makeRawAnnotationString(vcAlleles, combinedData.getAttributeMap());
        annotations.put(this.getPrimaryRawKey(), annotationString);
        return annotations;
    }

    public void combineAttributeMap(ReducibleAnnotationData<Double> toAdd, ReducibleAnnotationData<Double> combined) {
        for (Allele currentAllele : combined.getAlleles()) {
            if (toAdd.getAttribute(currentAllele) == null) continue;
            if (toAdd.getAttribute(currentAllele) != null && combined.getAttribute(currentAllele) != null) {
                combined.putAttribute(currentAllele, combined.getAttribute(currentAllele) + toAdd.getAttribute(currentAllele));
                continue;
            }
            combined.putAttribute(currentAllele, toAdd.getAttribute(currentAllele));
        }
    }

    protected void parseRawDataString(ReducibleAnnotationData<Double> myData) {
        String rawDataString = myData.getRawData();
        String[] rawDataPerAllele = rawDataString.split("\\|");
        for (int i = 0; i < rawDataPerAllele.length; ++i) {
            String alleleData = rawDataPerAllele[i];
            myData.putAttribute(myData.getAlleles().get(i), Double.parseDouble(alleleData));
        }
    }

    @Override
    public Map<String, Object> finalizeRawData(VariantContext vc, VariantContext originalVC) {
        if (!vc.hasAttribute(this.getPrimaryRawKey())) {
            return new HashMap<String, Object>();
        }
        String rawMQdata = vc.getAttributeAsString(this.getPrimaryRawKey(), null);
        if (rawMQdata == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        AlleleSpecificAnnotationData<Double> myData = new AlleleSpecificAnnotationData<Double>(originalVC.getAlleles(), rawMQdata);
        this.parseRawDataString(myData);
        String annotationString = this.makeFinalizedAnnotationString(vc, myData.getAttributeMap());
        annotations.put(this.getKeyNames().get(0), annotationString);
        annotations.put(this.getPrimaryRawKey(), this.makeRawAnnotationString(vc.getAlleles(), myData.getAttributeMap()));
        return annotations;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AS_MQ");
    }

    private void getRMSDataFromLikelihoods(AlleleLikelihoods<GATKRead, Allele> likelihoods, ReducibleAnnotationData<Double> myData) {
        for (AlleleLikelihoods.BestAllele bestAllele : likelihoods.bestAllelesBreakingTies()) {
            int mq;
            if (!bestAllele.isInformative() || (mq = ((GATKRead)bestAllele.evidence).getMappingQuality()) == 255) continue;
            double currSquareSum = myData.hasAttribute((Allele)bestAllele.allele) ? myData.getAttribute((Allele)bestAllele.allele) : 0.0;
            myData.putAttribute((Allele)bestAllele.allele, currSquareSum + (double)(mq * mq));
        }
    }

    private String makeRawAnnotationString(List<Allele> vcAlleles, Map<Allele, Double> perAlleleValues) {
        String annotationString = "";
        for (Allele current : vcAlleles) {
            if (!annotationString.isEmpty()) {
                annotationString = annotationString + "|";
            }
            if (perAlleleValues.get(current) != null) {
                annotationString = annotationString + String.format("%.2f", perAlleleValues.get(current));
                continue;
            }
            annotationString = annotationString + String.format("%.2f", 0.0);
        }
        return annotationString;
    }

    private String makeFinalizedAnnotationString(VariantContext vc, Map<Allele, Double> perAlleleValues) {
        Map<Allele, Integer> variantADs = this.getADcounts(vc);
        String annotationString = "";
        for (Allele current : vc.getAlternateAlleles()) {
            if (!annotationString.isEmpty()) {
                annotationString = annotationString + ",";
            }
            if (perAlleleValues.containsKey(current)) {
                annotationString = annotationString + String.format("%.2f", Math.sqrt(perAlleleValues.get(current) / (double)variantADs.get(current).intValue()));
                continue;
            }
            allele_logger.warn("ERROR: VC allele is not found in annotation alleles -- maybe there was trimming?");
        }
        return annotationString;
    }

    private Map<Allele, Integer> getADcounts(VariantContext vc) {
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            genotype_logger.warn("VC does not have genotypes -- annotations were calculated in wrong order");
            return null;
        }
        HashMap<Allele, Integer> variantADs = new HashMap<Allele, Integer>();
        for (Allele a : vc.getAlleles()) {
            variantADs.put(a, 0);
        }
        for (Genotype gt : vc.getGenotypes()) {
            if (!gt.hasAD()) continue;
            int[] ADs = gt.getAD();
            for (int i = 1; i < vc.getNAlleles(); ++i) {
                variantADs.put(vc.getAlternateAllele(i - 1), (Integer)variantADs.get(vc.getAlternateAllele(i - 1)) + ADs[i]);
            }
        }
        return variantADs;
    }
}

