/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import com.google.common.primitives.Doubles;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.CompressedDataList;
import org.broadinstitute.hellbender.utils.Histogram;
import org.broadinstitute.hellbender.utils.MannWhitneyU;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class AS_RankSumTest
extends RankSumTest
implements ReducibleAnnotation,
AlleleSpecificAnnotation {
    private static final Logger logger = LogManager.getLogger(AS_RankSumTest.class);
    public static final String RAW_DELIM = ",";

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc, "vc is null");
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Double> refQuals = new ArrayList<Double>();
        ArrayList<Double> altQuals = new ArrayList<Double>();
        if (likelihoods != null) {
            this.fillQualsFromLikelihood(vc, likelihoods, refQuals, altQuals);
        }
        if (refQuals.isEmpty() && altQuals.isEmpty()) {
            return Collections.emptyMap();
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU();
        MannWhitneyU.Result result = mannWhitneyU.test(Doubles.toArray(altQuals), Doubles.toArray(refQuals), MannWhitneyU.TestType.FIRST_DOMINATES);
        double zScore = result.getZ();
        if (Double.isNaN(zScore)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.getKeyNames().get(0), String.format("%.3f", zScore));
    }

    @Override
    public Map<String, Object> annotateRawData(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        if (likelihoods == null) {
            return Collections.emptyMap();
        }
        AlleleSpecificAnnotationData<CompressedDataList<Integer>> myRawData = this.initializeNewRawAnnotationData(vc.getAlleles());
        this.calculateRawData(vc, likelihoods, myRawData);
        Map<Allele, Double> myRankSumStats = this.calculateRankSum(myRawData.getAttributeMap(), myRawData.getRefAllele());
        String annotationString = this.makeRawAnnotationString(vc.getAlleles(), myRankSumStats);
        if (annotationString == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.getPrimaryRawKey(), annotationString);
    }

    protected AlleleSpecificAnnotationData<CompressedDataList<Integer>> initializeNewRawAnnotationData(List<Allele> vcAlleles) {
        HashMap perAlleleValues = new HashMap();
        for (Allele a : vcAlleles) {
            perAlleleValues.put(a, new CompressedDataList());
        }
        AlleleSpecificAnnotationData<CompressedDataList<Integer>> ret = new AlleleSpecificAnnotationData<CompressedDataList<Integer>>(vcAlleles, ((Object)perAlleleValues).toString());
        ret.setAttributeMap(perAlleleValues);
        return ret;
    }

    private AlleleSpecificAnnotationData<Histogram> initializeNewAnnotationData(List<Allele> vcAlleles) {
        HashMap<Allele, Histogram> perAlleleValues = new HashMap<Allele, Histogram>();
        for (Allele a : vcAlleles) {
            perAlleleValues.put(a, new Histogram());
        }
        AlleleSpecificAnnotationData<Histogram> ret = new AlleleSpecificAnnotationData<Histogram>(vcAlleles, ((Object)perAlleleValues).toString());
        ret.setAttributeMap(perAlleleValues);
        return ret;
    }

    protected String makeRawAnnotationString(List<Allele> vcAlleles, Map<Allele, Double> perAlleleValues) {
        String annotationString = "";
        for (int i = 0; i < vcAlleles.size(); ++i) {
            Double alleleValue;
            if (vcAlleles.get(i).isReference()) continue;
            if (i != 0) {
                annotationString = annotationString + "|";
            }
            if ((alleleValue = perAlleleValues.get(vcAlleles.get(i))) == null) continue;
            annotationString = annotationString + this.outputSingletonValueAsHistogram(alleleValue);
        }
        return annotationString;
    }

    private void calculateRawData(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, ReducibleAnnotationData myData) {
        if (vc.getGenotypes().getSampleNames().size() != 1) {
            throw new IllegalStateException("Calculating raw data for allele-specific rank sums requires variant context input with exactly one sample, as in a gVCF.");
        }
        if (likelihoods == null) {
            return;
        }
        Map perAlleleValues = myData.getAttributeMap();
        for (AlleleLikelihoods.BestAllele bestAllele : likelihoods.bestAllelesBreakingTies()) {
            OptionalDouble value;
            if (!bestAllele.isInformative() || !this.isUsableRead((GATKRead)bestAllele.evidence, vc) || !(value = this.getElementForRead((GATKRead)bestAllele.evidence, vc, bestAllele)).isPresent() || value.getAsDouble() == Double.NEGATIVE_INFINITY || !perAlleleValues.containsKey(bestAllele.allele)) continue;
            ((CompressedDataList)perAlleleValues.get(bestAllele.allele)).add((int)value.getAsDouble());
        }
    }

    @Override
    public Map<String, Object> finalizeRawData(VariantContext vc, VariantContext originalVC) {
        if (!vc.hasAttribute(this.getPrimaryRawKey())) {
            return new HashMap<String, Object>();
        }
        String rawRankSumData = vc.getAttributeAsString(this.getPrimaryRawKey(), null);
        if (rawRankSumData == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        AlleleSpecificAnnotationData<Histogram> myData = new AlleleSpecificAnnotationData<Histogram>(originalVC.getAlleles(), rawRankSumData);
        this.parseRawDataString(myData);
        Map<Allele, Double> perAltRankSumResults = this.calculateReducedData(myData.getAttributeMap(), myData.getRefAllele());
        if (perAltRankSumResults.isEmpty()) {
            return annotations;
        }
        String annotationString = this.makeReducedAnnotationString(vc, perAltRankSumResults);
        annotations.put(this.getKeyNames().get(0), annotationString);
        annotations.put(this.getPrimaryRawKey(), this.makeCombinedAnnotationString(vc.getAlleles(), myData.getAttributeMap()));
        return annotations;
    }

    public Map<Allele, Double> calculateReducedData(Map<Allele, Histogram> perAlleleValues, Allele ref) {
        HashMap<Allele, Double> perAltRankSumResults = new HashMap<Allele, Double>();
        for (Allele alt : perAlleleValues.keySet()) {
            if (alt.equals(ref, false) || perAlleleValues.get(alt) == null) continue;
            perAltRankSumResults.put(alt, perAlleleValues.get(alt).median());
        }
        return perAltRankSumResults;
    }

    @Override
    public Map<String, Object> combineRawData(List<Allele> vcAlleles, List<ReducibleAnnotationData<?>> annotationList) {
        AlleleSpecificAnnotationData<Histogram> combinedData = this.initializeNewAnnotationData(vcAlleles);
        for (ReducibleAnnotationData<Histogram> reducibleAnnotationData : annotationList) {
            this.parseRawDataString(reducibleAnnotationData);
            this.combineAttributeMap(reducibleAnnotationData, combinedData);
        }
        String annotationString = this.makeCombinedAnnotationString(vcAlleles, combinedData.getAttributeMap());
        return Collections.singletonMap(this.getPrimaryRawKey(), annotationString);
    }

    protected void parseRawDataString(ReducibleAnnotationData<Histogram> myData) {
        String rawDataString = myData.getRawData();
        HashMap<Allele, Histogram> perAlleleValues = new HashMap<Allele, Histogram>();
        for (Allele current : myData.getAlleles()) {
            perAlleleValues.put(current, new Histogram());
        }
        String rawDataNoBrackets = rawDataString.charAt(0) == '[' ? rawDataString.substring(1, rawDataString.length() - 1) : rawDataString;
        String[] rawDataPerAllele = rawDataNoBrackets.split("\\|");
        for (int i = 0; i < rawDataPerAllele.length; ++i) {
            String alleleData = rawDataPerAllele[i];
            Histogram alleleList = (Histogram)perAlleleValues.get(myData.getAlleles().get(i));
            String[] rawListEntriesAsStringVector = alleleData.split(RAW_DELIM);
            for (int j = 0; j < rawListEntriesAsStringVector.length; j += 2) {
                Double value;
                if (rawListEntriesAsStringVector[j].isEmpty() || (value = Double.valueOf(Double.parseDouble(rawListEntriesAsStringVector[j].trim()))).isNaN() || rawListEntriesAsStringVector[j + 1].isEmpty()) continue;
                int count = Integer.parseInt(rawListEntriesAsStringVector[j + 1].trim());
                alleleList.add(value, count);
            }
        }
        myData.setAttributeMap(perAlleleValues);
        myData.validateAllelesList();
    }

    protected void combineAttributeMap(ReducibleAnnotationData<Histogram> toAdd, ReducibleAnnotationData<Histogram> combined) {
        for (Allele a : combined.getAlleles()) {
            if (!toAdd.hasAttribute(a)) continue;
            Histogram alleleData = combined.getAttribute(a);
            if (toAdd.getAttribute(a) == null) continue;
            alleleData.add(toAdd.getAttribute(a));
            combined.putAttribute(a, alleleData);
        }
    }

    private String makeReducedAnnotationString(VariantContext vc, Map<Allele, Double> perAltRankSumResults) {
        StringBuilder annotationString = new StringBuilder();
        for (Allele a : vc.getAlternateAlleles()) {
            if (annotationString.length() != 0) {
                annotationString.append(RAW_DELIM);
            }
            if (!perAltRankSumResults.containsKey(a)) {
                logger.warn("VC allele not found in annotation alleles -- maybe there was trimming?  Allele " + a.getDisplayString() + " will be marked as missing.");
                annotationString.append(".");
                continue;
            }
            Double numericAlleleValue = perAltRankSumResults.get(a);
            String perAlleleValue = numericAlleleValue != null ? String.format("%.3f", numericAlleleValue) : ".";
            annotationString.append(perAlleleValue);
        }
        return annotationString.toString();
    }

    protected String makeCombinedAnnotationString(List<Allele> vcAlleles, Map<Allele, Histogram> perAlleleValues) {
        String annotationString = "";
        for (int i = 0; i < vcAlleles.size(); ++i) {
            Histogram alleleValue;
            if (vcAlleles.get(i).isReference()) continue;
            if (i != 0) {
                annotationString = annotationString + "|";
            }
            if ((alleleValue = perAlleleValues.get(vcAlleles.get(i))).isEmpty()) continue;
            annotationString = annotationString + alleleValue.toString();
        }
        return annotationString;
    }

    public Map<Allele, Double> calculateRankSum(Map<Allele, CompressedDataList<Integer>> perAlleleValues, Allele ref) {
        HashMap<Allele, Double> perAltRankSumResults = new HashMap<Allele, Double>();
        if (perAlleleValues.get(ref).isEmpty()) {
            return perAltRankSumResults;
        }
        for (Allele alt : perAlleleValues.keySet()) {
            if (alt.equals(ref, false)) continue;
            MannWhitneyU mannWhitneyU = new MannWhitneyU();
            ArrayList<Double> alts = new ArrayList<Double>();
            for (Number number : perAlleleValues.get(alt)) {
                alts.add(Double.valueOf(number.intValue()));
            }
            ArrayList<Double> refs = new ArrayList<Double>();
            for (Number qual3 : perAlleleValues.get(ref)) {
                refs.add(Double.valueOf(qual3.intValue()));
            }
            MannWhitneyU.Result result = mannWhitneyU.test(ArrayUtils.toPrimitive((Double[])alts.toArray(new Double[alts.size()])), ArrayUtils.toPrimitive((Double[])refs.toArray(new Double[refs.size()])), MannWhitneyU.TestType.FIRST_DOMINATES);
            perAltRankSumResults.put(alt, result.getZ());
        }
        return perAltRankSumResults;
    }

    public String outputSingletonValueAsHistogram(Double rankSumValue) {
        Histogram h = new Histogram();
        h.add(rankSumValue);
        return h.toString();
    }
}

