/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.ReadPosRankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Allele-specific rank sum test for relative positioning of REF versus ALT allele within reads (AS_ReadPosRankSum)")
public class AS_ReadPosRankSumTest
extends AS_RankSumTest
implements AS_StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AS_ReadPosRankSum");
    }

    @Override
    public String getPrimaryRawKey() {
        return "AS_RAW_ReadPosRankSum";
    }

    @Override
    public boolean hasSecondaryRawKeys() {
        return false;
    }

    @Override
    public List<String> getSecondaryRawKeys() {
        return null;
    }

    @Override
    protected OptionalDouble getElementForRead(GATKRead read, VariantContext vc) {
        return ReadPosRankSumTest.getReadPosition(read, vc);
    }

    @Override
    public boolean isUsableRead(GATKRead read, VariantContext vc) {
        Utils.nonNull(read);
        return super.isUsableRead(read, vc) && read.getSoftStart() <= vc.getEnd() + 1 && read.getSoftEnd() >= vc.getStart();
    }
}

