/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.StrandBiasUtils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class AS_StrandBiasTest
extends StrandBiasTest
implements ReducibleAnnotation,
AlleleSpecificAnnotation {
    private static final Logger logger = LogManager.getLogger(AS_StrandBiasTest.class);
    public static final String SPLIT_DELIM = "\\|";
    public static final String PRINT_DELIM = "|";
    public static final String REDUCED_DELIM = ",";
    public static final int MIN_COUNT = 2;
    public static final double MIN_PVALUE = 1.0E-320;
    public static final int FORWARD = 0;
    public static final int REVERSE = 1;

    @Override
    public String getPrimaryRawKey() {
        return "AS_SB_TABLE";
    }

    @Override
    public boolean hasSecondaryRawKeys() {
        return false;
    }

    @Override
    public List<String> getSecondaryRawKeys() {
        return null;
    }

    protected abstract Map<Allele, Double> calculateReducedData(AlleleSpecificAnnotationData<List<Integer>> var1);

    @Override
    public Map<String, Object> annotateRawData(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        if (likelihoods == null) {
            return Collections.emptyMap();
        }
        return StrandBiasUtils.computeSBAnnotation(vc, likelihoods, this.getPrimaryRawKey());
    }

    protected String makeReducedAnnotationString(VariantContext vc, Map<Allele, Double> perAltsStrandCounts) {
        String annotationString = "";
        for (Allele a : vc.getAlternateAlleles()) {
            if (!annotationString.isEmpty()) {
                annotationString = annotationString + REDUCED_DELIM;
            }
            if (!perAltsStrandCounts.containsKey(a)) {
                logger.warn("ERROR: VC allele not found in annotation alleles -- maybe there was trimming?");
                continue;
            }
            annotationString = annotationString + String.format("%.3f", perAltsStrandCounts.get(a));
        }
        return annotationString;
    }

    @Override
    public Map<String, Object> combineRawData(List<Allele> vcAlleles, List<ReducibleAnnotationData<?>> annotationList) {
        AlleleSpecificAnnotationData<List<Integer>> combinedData = new AlleleSpecificAnnotationData<List<Integer>>(vcAlleles, null);
        for (ReducibleAnnotationData<List<Integer>> reducibleAnnotationData : annotationList) {
            this.parseRawDataString(reducibleAnnotationData);
            StrandBiasUtils.combineAttributeMap(reducibleAnnotationData, combinedData);
        }
        String annotationString = StrandBiasUtils.makeRawAnnotationString(vcAlleles, combinedData.getAttributeMap());
        return Collections.singletonMap(this.getPrimaryRawKey(), annotationString);
    }

    @Override
    public Map<String, Object> finalizeRawData(VariantContext vc, VariantContext originalVC) {
        if (!vc.hasAttribute(this.getPrimaryRawKey())) {
            return new HashMap<String, Object>();
        }
        String rawContingencyTableData = vc.getAttributeAsString(this.getPrimaryRawKey(), null);
        if (rawContingencyTableData == null) {
            return new HashMap<String, Object>();
        }
        AlleleSpecificAnnotationData<List<Integer>> myData = new AlleleSpecificAnnotationData<List<Integer>>(originalVC.getAlleles(), rawContingencyTableData);
        this.parseRawDataString(myData);
        Map<Allele, Double> perAltRankSumResults = this.calculateReducedData(myData);
        String annotationString = this.makeReducedAnnotationString(vc, perAltRankSumResults);
        String rawAnnotationsString = StrandBiasUtils.makeRawAnnotationString(vc.getAlleles(), myData.getAttributeMap());
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(this.getKeyNames().get(0), annotationString);
        returnMap.put(this.getPrimaryRawKey(), rawAnnotationsString);
        return returnMap;
    }

    protected void parseRawDataString(ReducibleAnnotationData<List<Integer>> myData) {
        List<String> values = AnnotationUtils.getAlleleLengthListOfString(myData.getRawData());
        if (values.size() != myData.getAlleles().size()) {
            throw new IllegalStateException("Number of alleles and number of allele-specific entries do not match.  Allele-specific annotations should have an entry for each allele including the reference.");
        }
        HashMap perAlleleValues = new HashMap();
        for (int i = 0; i < values.size(); ++i) {
            String[] rawListEntriesAsStringVector;
            ArrayList<Integer> perAlleleList = new ArrayList<Integer>();
            for (String s : rawListEntriesAsStringVector = values.get(i).split(REDUCED_DELIM)) {
                if (s.isEmpty()) continue;
                perAlleleList.add(Integer.parseInt(s.trim()));
            }
            perAlleleValues.put(myData.getAlleles().get(i), perAlleleList);
        }
        myData.setAttributeMap(perAlleleValues);
    }

    @Override
    protected Map<String, Object> calculateAnnotationFromGTfield(GenotypesContext genotypes) {
        return Collections.emptyMap();
    }

    public static String rawValueAsString(int[][] table) {
        return table[0][0] + REDUCED_DELIM + table[0][1] + PRINT_DELIM + table[1][0] + REDUCED_DELIM + table[1][1];
    }
}

