/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandOddsRatio;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Allele-specific strand bias estimated by the symmetric odds ratio test (AS_SOR)")
public final class AS_StrandOddsRatio
extends AS_StrandBiasTest
implements AS_StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("AS_SOR");
    }

    @Override
    protected Map<String, Object> calculateAnnotationFromLikelihoods(AlleleLikelihoods<GATKRead, Allele> likelihoods, VariantContext vc) {
        int[][] table = AS_StrandOddsRatio.getContingencyTable(likelihoods, vc, 2);
        double ratio = StrandOddsRatio.calculateSOR(table);
        return Collections.singletonMap(this.getKeyNames().get(0), StrandOddsRatio.formattedValue(ratio));
    }

    @Override
    protected Map<Allele, Double> calculateReducedData(AlleleSpecificAnnotationData<List<Integer>> combinedData) {
        HashMap<Allele, Double> annotationMap = new HashMap<Allele, Double>();
        Map perAlleleData = combinedData.getAttributeMap();
        List refStrandCounts = (List)perAlleleData.get(combinedData.getRefAllele());
        for (Allele a : perAlleleData.keySet()) {
            List altStrandCounts = (List)perAlleleData.get(a);
            int[][] refAltTable = new int[][]{{(Integer)refStrandCounts.get(0), (Integer)refStrandCounts.get(1)}, {(Integer)altStrandCounts.get(0), (Integer)altStrandCounts.get(1)}};
            annotationMap.put(a, StrandOddsRatio.calculateSOR(refAltTable));
        }
        return annotationMap;
    }
}

