/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;

public final class AlleleSpecificAnnotationData<T>
extends ReducibleAnnotationData<T> {
    private final List<Allele> alleleList;
    private final Allele refAllele;

    public AlleleSpecificAnnotationData(List<Allele> inputAlleles, String inputData) {
        super(inputData);
        this.attributeMap = new HashMap();
        inputAlleles.forEach(a -> this.attributeMap.put(a, null));
        this.alleleList = inputAlleles;
        this.refAllele = this.alleleList.stream().filter(Allele::isReference).findAny().orElse(null);
        this.checkRefAlleles();
    }

    @Override
    public List<Allele> getAlleles() {
        return Collections.unmodifiableList(this.alleleList);
    }

    public Allele getRefAllele() {
        return this.refAllele;
    }

    @Override
    public void setAttributeMap(Map<Allele, T> inputMap) {
        super.setAttributeMap(inputMap);
    }

    private void checkRefAlleles() {
        long refCount = this.alleleList.stream().filter(Allele::isReference).count();
        if (refCount > 1L) {
            throw new IllegalArgumentException("ERROR: multiple reference alleles found in annotation data\n");
        }
        if (refCount == 0L) {
            throw new IllegalArgumentException("ERROR: no reference alleles found in annotation data\n");
        }
    }
}

