/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

public interface ReducibleAnnotation
extends Annotation {
    default public List<String> getRawKeyNames() {
        ArrayList<String> allRawKeys = new ArrayList<String>();
        allRawKeys.add(this.getPrimaryRawKey());
        if (this.hasSecondaryRawKeys()) {
            allRawKeys.addAll(this.getSecondaryRawKeys());
        }
        return allRawKeys;
    }

    public String getPrimaryRawKey();

    public boolean hasSecondaryRawKeys();

    public List<String> getSecondaryRawKeys();

    public Map<String, Object> annotateRawData(ReferenceContext var1, VariantContext var2, AlleleLikelihoods<GATKRead, Allele> var3);

    public Map<String, Object> combineRawData(List<Allele> var1, List<ReducibleAnnotationData<?>> var2);

    public Map<String, Object> finalizeRawData(VariantContext var1, VariantContext var2);

    default public List<VCFInfoHeaderLine> getRawDescriptions() {
        ArrayList<VCFInfoHeaderLine> lines = new ArrayList<VCFInfoHeaderLine>(1);
        for (String rawKey : this.getRawKeyNames()) {
            lines.add(GATKVCFHeaderLines.getInfoLine(rawKey));
        }
        return lines;
    }
}

