/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.exceptions.GATKException;

public class ReducibleAnnotationData<T> {
    protected final String rawData;
    protected Map<Allele, T> attributeMap;

    public ReducibleAnnotationData(String inputData) {
        this.rawData = inputData;
        this.attributeMap = new HashMap<Allele, T>();
        this.attributeMap.put(Allele.NO_CALL, null);
    }

    public String getRawData() {
        return this.rawData;
    }

    public List<Allele> getAlleles() {
        ArrayList<Allele> ret = new ArrayList<Allele>();
        ret.addAll(this.attributeMap.keySet());
        return ret;
    }

    public boolean hasAttribute(Allele key) {
        return this.attributeMap.containsKey(key);
    }

    public T getAttribute(Allele key) {
        return this.attributeMap.get(key);
    }

    public void putAttribute(Allele key, T value) {
        this.attributeMap.put(key, value);
    }

    public void setAttributeMap(Map<Allele, T> inputMap) {
        this.attributeMap = inputMap;
    }

    public Map<Allele, T> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public void validateAllelesList() {
        boolean foundRef = false;
        for (Allele a : this.getAlleles()) {
            if (!a.isReference()) continue;
            if (foundRef) {
                throw new GATKException("ERROR: multiple reference alleles found in annotation data\n");
            }
            foundRef = true;
        }
        if (!foundRef) {
            throw new GATKException("ERROR: no reference alleles found in annotation data\n");
        }
    }
}

