/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class StrandBiasUtils {
    public static final int FORWARD = 0;
    public static final int REVERSE = 1;
    public static final int MIN_COUNT = 2;
    private static final List<Integer> ZERO_LIST = new ArrayList<Integer>(Arrays.asList(0, 0));

    public static Map<String, Object> computeSBAnnotation(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, String key) {
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        AlleleSpecificAnnotationData<List<Integer>> myData = new AlleleSpecificAnnotationData<List<Integer>>(vc.getAlleles(), null);
        StrandBiasUtils.getStrandCountsFromLikelihoodMap(vc, likelihoods, myData, 2);
        Map<Allele, List<Integer>> perAlleleValues = myData.getAttributeMap();
        String annotationString = StrandBiasUtils.makeRawAnnotationString(vc.getAlleles(), perAlleleValues);
        annotations.put(key, annotationString);
        return annotations;
    }

    public static String makeRawAnnotationString(List<Allele> vcAlleles, Map<Allele, List<Integer>> perAlleleValues) {
        String annotationString = "";
        for (Allele a : vcAlleles) {
            List<Integer> alleleValues;
            if (!annotationString.isEmpty()) {
                annotationString = annotationString + "|";
            }
            if ((alleleValues = perAlleleValues.get(a)) == null) {
                alleleValues = ZERO_LIST;
            }
            annotationString = annotationString + StrandBiasUtils.encode(alleleValues);
        }
        return annotationString;
    }

    public static String encode(List<Integer> alleleValues) {
        String annotationString = "";
        for (int j = 0; j < alleleValues.size(); ++j) {
            annotationString = annotationString + alleleValues.get(j);
            if (j >= alleleValues.size() - 1) continue;
            annotationString = annotationString + ",";
        }
        return annotationString;
    }

    public static void getStrandCountsFromLikelihoodMap(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, ReducibleAnnotationData<List<Integer>> perAlleleValues, int minCount) {
        if (likelihoods == null || vc == null) {
            return;
        }
        Allele ref = vc.getReference();
        List allAlts = vc.getAlternateAlleles();
        for (String sample : likelihoods.samples()) {
            AlleleSpecificAnnotationData<List<Integer>> sampleTable = new AlleleSpecificAnnotationData<List<Integer>>(vc.getAlleles(), null);
            likelihoods.bestAllelesBreakingTies(sample).stream().filter(ba -> ba.isInformative()).forEach(ba -> StrandBiasUtils.updateTable(ba.allele, (GATKRead)ba.evidence, ref, allAlts, sampleTable));
            if (!StrandBiasUtils.passesMinimumThreshold(sampleTable, minCount)) continue;
            StrandBiasUtils.combineAttributeMap(sampleTable, perAlleleValues);
        }
    }

    protected static void combineAttributeMap(ReducibleAnnotationData<List<Integer>> toAdd, ReducibleAnnotationData<List<Integer>> combined) {
        for (Allele a : combined.getAlleles()) {
            if (!toAdd.hasAttribute(a) || toAdd.getAttribute(a) == null) continue;
            if (combined.getAttribute(a) != null) {
                combined.getAttribute(a).set(0, combined.getAttribute(a).get(0) + toAdd.getAttribute(a).get(0));
                combined.getAttribute(a).set(1, combined.getAttribute(a).get(1) + toAdd.getAttribute(a).get(1));
                continue;
            }
            ArrayList<Integer> alleleData = new ArrayList<Integer>();
            alleleData.add(0, toAdd.getAttribute(a).get(0));
            alleleData.add(1, toAdd.getAttribute(a).get(1));
            combined.putAttribute(a, alleleData);
        }
    }

    private static void updateTable(Allele bestAllele, GATKRead read, Allele ref, List<Allele> allAlts, ReducibleAnnotationData<List<Integer>> perAlleleValues) {
        List<Object> alleleStrandCounts;
        boolean matchesRef = bestAllele.equals(ref, true);
        boolean matchesAnyAlt = allAlts.contains(bestAllele);
        if (!matchesRef && !matchesAnyAlt) {
            return;
        }
        if (perAlleleValues.hasAttribute(bestAllele) && perAlleleValues.getAttribute(bestAllele) != null) {
            alleleStrandCounts = perAlleleValues.getAttribute(bestAllele);
        } else {
            alleleStrandCounts = new ArrayList<Integer>();
            alleleStrandCounts.add(0, 0);
            alleleStrandCounts.add(1, 0);
        }
        int strand = read.isReverseStrand() ? 1 : 0;
        alleleStrandCounts.set(strand, (Integer)alleleStrandCounts.get(strand) + 1);
        perAlleleValues.putAttribute(bestAllele, alleleStrandCounts);
    }

    protected static boolean passesMinimumThreshold(ReducibleAnnotationData<List<Integer>> sampleTable, int minCount) {
        int readCount = sampleTable.getAttributeMap().values().stream().filter(alleleValues -> alleleValues != null).mapToInt(alleleValues -> (Integer)alleleValues.get(0) + (Integer)alleleValues.get(1)).sum();
        return readCount > minCount;
    }

    public static List<List<Integer>> getSBsForAlleles(VariantContext vc) {
        String sbStr = vc.getCommonInfo().getAttributeAsString("AS_SB_TABLE", null);
        if (sbStr == null || sbStr.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> asb = AnnotationUtils.decodeAnyASListWithRawDelim(sbStr);
        return asb.stream().map(fwdrev -> AnnotationUtils.decodeAnyASList(fwdrev).stream().map(String::trim).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList())).collect(Collectors.toList());
    }
}

