/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.bqsr;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Evaluate and compare base quality score recalibration (BQSR) tables", oneLineSummary="Evaluate and compare base quality score recalibration (BQSR) tables", programGroup=DiagnosticsAndQCProgramGroup.class)
public final class AnalyzeCovariates
extends CommandLineProgram {
    private final Logger logger = LogManager.getLogger(AnalyzeCovariates.class);
    static final String CSV_ARG_SHORT_NAME = "csv";
    static final String PDF_ARG_SHORT_NAME = "plots";
    static final String BEFORE_ARG_SHORT_NAME = "before";
    static final String AFTER_ARG_SHORT_NAME = "after";
    static final String IGNORE_LMT_LONG_NAME = "ignore-last-modification-times";
    @Argument(shortName="before", fullName="before-report-file", doc="file containing the BQSR first-pass report file", optional=true)
    protected File beforeFile = null;
    @Argument(shortName="after", fullName="after-report-file", doc="file containing the BQSR second-pass report file", optional=true)
    protected File afterFile = null;
    @Argument(fullName="ignore-last-modification-times", doc="do not emit warning messages related to suspicious last modification time order of inputs", optional=true)
    protected boolean ignoreLastModificationTime = false;
    @Argument(shortName="plots", fullName="plots-report-file", doc="location of the output report", optional=true)
    protected File pdfFile = null;
    @Argument(shortName="csv", fullName="intermediate-csv-file", doc="location of the csv intermediate file", optional=true)
    protected File csvFile = null;
    @Argument(fullName="bqsr-recal-file", shortName="bqsr", optional=true, doc="Input covariates table file for on-the-fly base quality score recalibration")
    public File BQSR_RECAL_FILE = null;

    private void checkArgumentsValues() {
        this.checkInputReportFile("BQSR", this.BQSR_RECAL_FILE);
        this.checkInputReportFile(BEFORE_ARG_SHORT_NAME, this.beforeFile);
        this.checkInputReportFile(AFTER_ARG_SHORT_NAME, this.afterFile);
        if (this.BQSR_RECAL_FILE == null && this.beforeFile == null && this.afterFile == null) {
            throw new UserException("you must provide at least one recalibration report file (arguments -bqsr, -before or -after");
        }
        this.checkOutputFile(PDF_ARG_SHORT_NAME, this.pdfFile);
        this.checkOutputFile(CSV_ARG_SHORT_NAME, this.csvFile);
        this.checkInputReportFileLMT(this.beforeFile, this.afterFile);
        this.checkOutputRequested();
    }

    private void checkInputReportFileLMT(File beforeFile, File afterFile) {
        if (this.ignoreLastModificationTime || beforeFile == null || afterFile == null) {
            return;
        }
        if (beforeFile.lastModified() > afterFile.lastModified()) {
            Utils.warnUser("Last modification timestamp for 'Before' and 'After'recalibration reports are in the wrong order. Perhaps, have they been swapped?");
        }
    }

    private void checkOutputRequested() {
        if (this.pdfFile == null && this.csvFile == null) {
            throw new UserException("you need to request at least one output: the intermediate csv file (-csv FILE) or the final plot file (-plots FILE).");
        }
    }

    private void checkInputReportFile(String name, File value) {
        if (value == null) {
            return;
        }
        if (!value.exists()) {
            throw new CommandLineException.BadArgumentValue(name, "input report '" + value + "' does not exist or is unreachable");
        }
        if (!value.isFile()) {
            throw new CommandLineException.BadArgumentValue(name, "input report '" + value + "' is not a regular file");
        }
        if (!value.canRead()) {
            throw new CommandLineException.BadArgumentValue(name, "input report '" + value + "' cannot be read");
        }
    }

    private void checkOutputFile(String name, File value) {
        if (value == null) {
            return;
        }
        if (value.exists() && !value.isFile()) {
            throw new CommandLineException.BadArgumentValue(name, "the output file location '" + value + "' exists as not a file");
        }
        File parent = value.getParentFile();
        if (parent == null) {
            return;
        }
        if (!parent.exists()) {
            throw new CommandLineException.BadArgumentValue(name, "the output file parent directory '" + parent + "' does not exists or is unreachable");
        }
        if (!parent.isDirectory()) {
            throw new CommandLineException.BadArgumentValue(name, "the output file parent directory '" + parent + "' is not a directory");
        }
        if (!parent.canWrite()) {
            throw new CommandLineException.BadArgumentValue(name, "the output file parent directory '" + parent + "' cannot be written");
        }
    }

    private void generatePlots(File csvFile, Map<String, File> reportFiles, File plotsFile) {
        if (plotsFile == null) {
            return;
        }
        this.logger.info("Generating plots file '" + plotsFile + "'");
        File exampleReportFile = reportFiles.values().iterator().next();
        RecalUtils.generatePlots(csvFile, exampleReportFile, plotsFile);
    }

    @Override
    public Object doWork() {
        this.checkArgumentsValues();
        Map<String, File> reportFiles = this.buildReportFileMap();
        Map<String, RecalibrationReport> reports = this.buildReportMap(reportFiles);
        this.checkReportConsistency(reports);
        File csvFile = this.resolveCsvFile();
        this.generateCsvFile(csvFile, reports);
        File plotFile = this.resolvePlotFile();
        this.generatePlots(csvFile, reportFiles, plotFile);
        return Optional.empty();
    }

    private File resolvePlotFile() {
        return this.pdfFile;
    }

    private void generateCsvFile(File csvFile, Map<String, RecalibrationReport> reports) {
        try {
            this.logger.info("Generating csv file '" + csvFile + "'");
            RecalUtils.generateCsv(csvFile, reports);
        }
        catch (FileNotFoundException e) {
            throw new UserException(String.format("There is a problem creating the intermediary Csv file '%s': %s", csvFile, e.getMessage()), e);
        }
    }

    private void checkReportConsistency(Map<String, RecalibrationReport> reports) {
        Map.Entry[] reportEntries = reports.entrySet().toArray(new Map.Entry[reports.size()]);
        Map.Entry exampleEntry = reportEntries[0];
        for (int i = 1; i < reportEntries.length; ++i) {
            Map<String, ? extends CharSequence> diffs = ((RecalibrationReport)exampleEntry.getValue()).getRAC().compareReportArguments(((RecalibrationReport)reportEntries[i].getValue()).getRAC(), (String)exampleEntry.getKey(), (String)reportEntries[i].getKey());
            if (diffs.isEmpty()) continue;
            throw new UserException.IncompatibleRecalibrationTableParameters("There are differences in relevant arguments of two or more input recalibration reports. Please make sure they have been created using the same recalibration parameters. " + String.join((CharSequence)"// ", this.reportDifferencesStringArray(diffs)));
        }
    }

    private Map<String, File> buildReportFileMap() {
        LinkedHashMap<String, File> reports = new LinkedHashMap<String, File>(3);
        if (this.BQSR_RECAL_FILE != null) {
            reports.put("BQSR", this.BQSR_RECAL_FILE);
        }
        if (this.beforeFile != null) {
            reports.put("Before", this.beforeFile);
        }
        if (this.afterFile != null) {
            reports.put("After", this.afterFile);
        }
        return reports;
    }

    private Map<String, RecalibrationReport> buildReportMap(Map<String, File> reportFileMap) {
        LinkedHashMap<String, RecalibrationReport> reports = new LinkedHashMap<String, RecalibrationReport>(reportFileMap.size());
        for (Map.Entry<String, File> e : reportFileMap.entrySet()) {
            reports.put(e.getKey(), new RecalibrationReport(e.getValue()));
        }
        return reports;
    }

    private String[] reportDifferencesStringArray(Map<String, ? extends CharSequence> diffs) {
        String[] result = new String[diffs.size()];
        int i = 0;
        for (Map.Entry<String, ? extends CharSequence> e : diffs.entrySet()) {
            result[i++] = this.capitalize(e.getKey()) + ": " + e.getValue();
        }
        return result;
    }

    private String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private File resolveCsvFile() {
        if (this.csvFile != null) {
            return this.csvFile;
        }
        return IOUtils.createTempFile("AnalyzeCovariates", ".csv");
    }
}

