/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.bqsr;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowInput;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.ApplyBQSRArgumentCollection;
import org.broadinstitute.hellbender.transformers.BQSRReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Apply a linear base quality recalibration model trained with the BaseRecalibrator tool.", oneLineSummary="Apply base quality score recalibration", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class ApplyBQSR
extends ReadWalker {
    static final String USAGE_ONE_LINE_SUMMARY = "Apply base quality score recalibration";
    static final String USAGE_SUMMARY = "Apply a linear base quality recalibration model trained with the BaseRecalibrator tool.";
    private static final Logger logger = LogManager.getLogger(ApplyBQSR.class);
    @Argument(fullName="output", shortName="O", doc="Write output to this file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath OUTPUT;
    @Argument(fullName="bqsr-recal-file", shortName="bqsr", doc="Input recalibration table for BQSR")
    @WorkflowInput
    public File BQSR_RECAL_FILE;
    @ArgumentCollection
    public ApplyBQSRArgumentCollection bqsrArgs = new ApplyBQSRArgumentCollection();
    private SAMFileGATKReadWriter outputWriter;

    @Override
    public ReadTransformer makePostReadFilterTransformer() {
        return new BQSRReadTransformer(this.getHeaderForReads(), this.BQSR_RECAL_FILE, this.bqsrArgs);
    }

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.OUTPUT, true);
        Utils.warnOnNonIlluminaReadGroups(this.getHeaderForReads(), logger);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.outputWriter.addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

