/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.bqsr;

import htsjdk.tribble.Feature;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowInput;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.BaseRecalibrationEngine;
import org.broadinstitute.hellbender.utils.recalibration.QuantizationInfo;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="First pass of the Base Quality Score Recalibration (BQSR) -- Generates recalibration table based on various user-specified covariates (such as read group, reported quality score, machine cycle, and nucleotide context).", oneLineSummary="Generates recalibration table for Base Quality Score Recalibration (BQSR)", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class BaseRecalibrator
extends ReadWalker {
    public static final String USAGE_ONE_LINE_SUMMARY = "Generates recalibration table for Base Quality Score Recalibration (BQSR)";
    public static final String USAGE_SUMMARY = "First pass of the Base Quality Score Recalibration (BQSR) -- Generates recalibration table based on various user-specified covariates (such as read group, reported quality score, machine cycle, and nucleotide context).";
    public static final String KNOWN_SITES_ARG_FULL_NAME = "known-sites";
    protected static final Logger logger = LogManager.getLogger(BaseRecalibrator.class);
    @ArgumentCollection(doc="all the command line arguments for BQSR and its covariates")
    private final RecalibrationArgumentCollection recalArgs = new RecalibrationArgumentCollection();
    @Argument(fullName="known-sites", doc="One or more databases of known polymorphic sites used to exclude regions around known polymorphisms from analysis.", optional=false)
    @WorkflowInput
    private List<FeatureInput<Feature>> knownSites;
    @Argument(shortName="O", fullName="output", doc="The output recalibration table file to create", optional=false)
    @WorkflowOutput
    private GATKPath recalTableFile = null;
    private BaseRecalibrationEngine recalibrationEngine;
    private ReferenceDataSource referenceDataSource;
    private QuantizationInfo quantizationInfo = null;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        if (this.recalArgs.FORCE_PLATFORM != null) {
            this.recalArgs.DEFAULT_PLATFORM = this.recalArgs.FORCE_PLATFORM;
        }
        Utils.warnOnNonIlluminaReadGroups(this.getHeaderForReads(), logger);
        this.recalibrationEngine = new BaseRecalibrationEngine(this.recalArgs, this.getHeaderForReads());
        this.recalibrationEngine.logCovariatesUsed();
        this.referenceDataSource = ReferenceDataSource.of(this.referenceArguments.getReferencePath());
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return BaseRecalibrator.getStandardBQSRReadFilterList();
    }

    public static List<ReadFilter> getStandardBQSRReadFilterList() {
        List<ReadFilter> bqsrFilters = BaseRecalibrator.getBQSRSpecificReadFilterList();
        bqsrFilters.add(new WellformedReadFilter());
        return bqsrFilters;
    }

    public static List<ReadFilter> getBQSRSpecificReadFilterList() {
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>(6);
        filters.add(ReadFilterLibrary.MAPPING_QUALITY_NOT_ZERO);
        filters.add(ReadFilterLibrary.MAPPING_QUALITY_AVAILABLE);
        filters.add(ReadFilterLibrary.MAPPED);
        filters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        filters.add(ReadFilterLibrary.NOT_DUPLICATE);
        filters.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        return filters;
    }

    @Override
    public void apply(GATKRead read, ReferenceContext ref, FeatureContext featureContext) {
        this.recalibrationEngine.processRead(read, this.referenceDataSource, featureContext.getValues(this.knownSites));
    }

    @Override
    public Object onTraversalSuccess() {
        this.recalibrationEngine.finalizeData();
        logger.info("Calculating quantized quality scores...");
        this.quantizeQualityScores();
        logger.info("Writing recalibration report...");
        this.generateReport();
        logger.info("...done!");
        logger.info("BaseRecalibrator was able to recalibrate " + this.recalibrationEngine.getNumReadsProcessed() + " reads");
        return "SUCCESS";
    }

    private void quantizeQualityScores() {
        this.quantizationInfo = new QuantizationInfo(this.recalibrationEngine.getFinalRecalibrationTables(), this.recalArgs.QUANTIZING_LEVELS);
    }

    private void generateReport() {
        try (PrintStream recalTableStream = new PrintStream(this.recalTableFile.getOutputStream());){
            if (recalTableStream.checkError()) {
                throw new UserException.CouldNotCreateOutputFile(this.recalTableFile, "I/O stream error writing to output");
            }
            RecalUtils.outputRecalibrationReport(recalTableStream, this.recalArgs, this.quantizationInfo, this.recalibrationEngine.getFinalRecalibrationTables(), this.recalibrationEngine.getCovariates());
        }
    }
}

