/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.bqsr;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import picard.cmdline.programgroups.OtherProgramGroup;

@CommandLineProgramProperties(summary="Gathers scattered BQSR recalibration reports into a single file", oneLineSummary="Gathers scattered BQSR recalibration reports into a single file", programGroup=OtherProgramGroup.class)
@DocumentedFeature
public final class GatherBQSRReports
extends CommandLineProgram {
    @Argument(fullName="input", shortName="I", doc="List of scattered BQSR report files")
    public final List<File> inputReports = new ArrayList<File>();
    @Argument(fullName="output", shortName="O", doc="File to output the gathered file to")
    public File outputReport;

    @Override
    protected Object doWork() {
        this.inputReports.forEach(IOUtil::assertFileIsReadable);
        IOUtil.assertFileIsWritable((File)this.outputReport);
        RecalibrationReport.gatherReportsIntoOneFile(this.inputReports, this.outputReport);
        return 0;
    }
}

