/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.consensus;

import java.util.Random;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.hellbender.engine.DuplicateSetWalker;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.consensus.ReadsWithSameUMI;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Discard a set fraction of duplicate sets from a UMI-grouped bam", oneLineSummary="Discard a set fraction of duplicate sets from a UMI-grouped bam", programGroup=ReadDataManipulationProgramGroup.class)
@BetaFeature
@WorkflowProperties
public class DownsampleByDuplicateSet
extends DuplicateSetWalker {
    @Argument(fullName="output", shortName="O", doc="Output BAM file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath outputBam;
    public static final String FRACTION_TO_KEEP_NAME = "fraction-to-keep";
    @Argument(fullName="fraction-to-keep", doc="This fraction of molecules in the input bam will be retained", minValue=0.0, maxValue=1.0)
    public double fractionToKeep;
    private static final int RANDOM_SEED = 142;
    private final Random rng = new Random(142L);
    private int numDuplicateReadSets;
    private int numReads;
    private SAMFileGATKReadWriter outputWriter;

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.outputBam, false);
    }

    @Override
    public void apply(ReadsWithSameUMI readsWithSameUMI, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (this.rng.nextDouble() < this.fractionToKeep) {
            readsWithSameUMI.getReads().forEach(r -> this.outputWriter.addRead((GATKRead)r));
            this.numReads += readsWithSameUMI.getReads().size();
            ++this.numDuplicateReadSets;
        }
    }

    @Override
    public Object onTraversalSuccess() {
        this.outputWriter.close();
        this.logger.info(String.format("Wrote %d reads", this.numReads));
        this.logger.info(String.format("Wrote %d duplicate read sets", this.numDuplicateReadSets));
        return "SUCCESS";
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

