/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.consensus;

import htsjdk.samtools.SAMTag;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class MoleculeID {
    private int moleculeNumber;
    private String strand;

    public MoleculeID(GATKRead read) {
        this.moleculeNumber = MoleculeID.getMoleculeNumberOfRead(read);
        this.strand = MoleculeID.getStrandOfRead(read);
    }

    public MoleculeID(int moleculeNumber, String strand) {
        this.moleculeNumber = moleculeNumber;
        this.strand = strand;
    }

    public int getMoleculeNumber() {
        return this.moleculeNumber;
    }

    public String getStrand() {
        return this.strand;
    }

    public String getSAMField() {
        return this.moleculeNumber + "/" + this.strand;
    }

    public static int getMoleculeNumberOfRead(GATKRead read) {
        String MITag = read.getAttributeAsString(SAMTag.MI.name());
        return Integer.parseInt(MITag.split("/")[0]);
    }

    public static String getStrandOfRead(GATKRead read) {
        String MITag = read.getAttributeAsString(SAMTag.MI.name());
        return MITag.split("/")[1];
    }

    public static Pair<Integer, Integer> countStrands(List<GATKRead> reads) {
        int strandACount = (int)reads.stream().filter(r -> MoleculeID.getStrandOfRead(r).equals("A")).count();
        int strandBCount = (int)reads.stream().filter(r -> MoleculeID.getStrandOfRead(r).equals("B")).count();
        return new ImmutablePair((Object)strandACount, (Object)strandBCount);
    }
}

