/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.consensus;

import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.consensus.MoleculeID;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ReadsWithSameUMI
implements Locatable {
    public static final String FGBIO_MI_TAG_DELIMITER = "/";
    public MoleculeID moleculeID;
    private SimpleInterval interval;
    private List<GATKRead> reads = new ArrayList<GATKRead>();

    public ReadsWithSameUMI(GATKRead read) {
        this.init(read);
    }

    private void init(GATKRead read) {
        Utils.validate(this.reads.isEmpty(), String.format("Initializing a non-empty set", new Object[0]));
        this.moleculeID = new MoleculeID(read);
        this.interval = new SimpleInterval(read);
        this.reads.add(read);
    }

    public List<GATKRead> getReads() {
        return Collections.unmodifiableList(this.reads);
    }

    public void addRead(GATKRead read) {
        Utils.validate(this.reads.isEmpty() || this.moleculeID.getMoleculeNumber() == MoleculeID.getMoleculeNumberOfRead(read), String.format("Molecule number of the set and that of the new read don't match: set number = %d, read number = %d", this.moleculeID.getMoleculeNumber(), MoleculeID.getMoleculeNumberOfRead(read)));
        Utils.validate(this.interval.contigsMatch(read), String.format("Adding a read from another contig: set contig = %s, read contig = %s", this.interval.getContig(), read.getContig()));
        if (this.reads.isEmpty()) {
            this.init(read);
            return;
        }
        this.reads.add(read);
        this.interval = this.interval.spanWith(read);
    }

    public boolean isEmpty() {
        return this.reads.isEmpty();
    }

    public int getMoleculeNumber() {
        Utils.nonNull(this.moleculeID, "Querying a non-initialized set for a molecule number");
        return this.moleculeID.getMoleculeNumber();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }
}

