/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.contamination;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.tools.walkers.contamination.ContaminationModel;
import org.broadinstitute.hellbender.tools.walkers.contamination.ContaminationRecord;
import org.broadinstitute.hellbender.tools.walkers.contamination.MinorAlleleFractionRecord;
import org.broadinstitute.hellbender.tools.walkers.contamination.PileupSummary;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Calculate the fraction of reads coming from cross-sample contamination", oneLineSummary="Calculate the fraction of reads coming from cross-sample contamination", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CalculateContamination
extends CommandLineProgram {
    public static final Logger logger = LogManager.getLogger(CalculateContamination.class);
    private static final int MIN_COVERAGE = 10;
    private static final double DEFAULT_LOW_COVERAGE_RATIO_THRESHOLD = 0.5;
    private static final double DEFAULT_HIGH_COVERAGE_RATIO_THRESHOLD = 3.0;
    @Argument(fullName="input", shortName="I", doc="The input table")
    private File inputPileupSummariesTable;
    public static final String MATCHED_NORMAL_LONG_NAME = "matched-normal";
    public static final String MATCHED_NORMAL_SHORT_NAME = "matched";
    @Argument(fullName="matched-normal", shortName="matched", doc="The matched normal input table", optional=true)
    private File matchedPileupSummariesTable = null;
    @Argument(fullName="output", shortName="O", doc="The output table")
    private final File outputTable = null;
    public static final String TUMOR_SEGMENTATION_LONG_NAME = "tumor-segmentation";
    public static final String TUMOR_SEGMENTATION_SHORT_NAME = "segments";
    @Argument(fullName="tumor-segmentation", shortName="segments", doc="The output table containing segmentation of the tumor by minor allele fraction", optional=true)
    private final File outputTumorSegmentation = null;
    public static final String LOW_COVERAGE_RATIO_THRESHOLD_NAME = "low-coverage-ratio-threshold";
    @Argument(fullName="low-coverage-ratio-threshold", doc="The minimum coverage relative to the median.", optional=true)
    private final double lowCoverageRatioThreshold = 0.5;
    public static final String HIGH_COVERAGE_RATIO_THRESHOLD_NAME = "high-coverage-ratio-threshold";
    @Argument(fullName="high-coverage-ratio-threshold", doc="The maximum coverage relative to the mean.", optional=true)
    private final double highCoverageRatioThreshold = 3.0;

    @Override
    public Object doWork() {
        ImmutablePair<String, List<PileupSummary>> sampleAndsites = PileupSummary.readFromFile(this.inputPileupSummariesTable);
        String sample = (String)sampleAndsites.getLeft();
        List<PileupSummary> sites = this.filterSitesByCoverage((List)sampleAndsites.getRight());
        List<PileupSummary> genotypingSites = this.matchedPileupSummariesTable == null ? sites : this.filterSitesByCoverage((List)PileupSummary.readFromFile(this.matchedPileupSummariesTable).getRight());
        ContaminationModel genotypingModel = new ContaminationModel(genotypingSites);
        if (this.outputTumorSegmentation != null) {
            ContaminationModel tumorModel = this.matchedPileupSummariesTable == null ? genotypingModel : new ContaminationModel(sites);
            MinorAlleleFractionRecord.writeToFile(sample, tumorModel.segmentationRecords(), this.outputTumorSegmentation);
        }
        Pair<Double, Double> contaminationAndError = genotypingModel.calculateContaminationFromHoms(sites);
        ContaminationRecord.writeToFile(Arrays.asList(new ContaminationRecord(sample, (Double)contaminationAndError.getLeft(), (Double)contaminationAndError.getRight())), this.outputTable);
        return "SUCCESS";
    }

    private List<PileupSummary> filterSitesByCoverage(List<PileupSummary> allSites) {
        List coveredSites = allSites.stream().filter(s -> s.getTotalCount() > 10).collect(Collectors.toList());
        double[] coverage = coveredSites.stream().mapToDouble(PileupSummary::getTotalCount).toArray();
        double medianCoverage = new Median().evaluate(coverage);
        double meanCoverage = new Mean().evaluate(coverage);
        double lowCoverageThreshold = medianCoverage * 0.5;
        double highCoverageThreshold = meanCoverage * 3.0;
        return coveredSites.stream().filter(ps -> (double)ps.getTotalCount() > lowCoverageThreshold && (double)ps.getTotalCount() < highCoverageThreshold).collect(Collectors.toList());
    }
}

