/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.contamination;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class ContaminationRecord {
    private String sample;
    private double contamination;
    private double error;

    public ContaminationRecord(String sample, double contamination, double error) {
        this.sample = sample;
        this.contamination = contamination;
        this.error = error;
    }

    public String getSample() {
        return this.sample;
    }

    public double getContamination() {
        return this.contamination;
    }

    public double getError() {
        return this.error;
    }

    public static void writeToFile(List<ContaminationRecord> records, File outputTable) {
        try (ContaminationTableWriter writer = new ContaminationTableWriter(IOUtils.fileToPath(outputTable));){
            writer.writeAllRecords(records);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", outputTable));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ContaminationRecord> readFromFile(File tableFile) {
        try (ContaminationTableReader reader = new ContaminationTableReader(IOUtils.fileToPath(tableFile));){
            List<ContaminationRecord> list = reader.toList();
            return list;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", tableFile));
        }
    }

    private static enum ContaminationTableColumn {
        SAMPLE("sample"),
        CONTAMINATION("contamination"),
        ERROR("error");

        private final String columnName;
        public static final TableColumnCollection COLUMNS;

        private ContaminationTableColumn(String columnName) {
            this.columnName = Utils.nonNull(columnName);
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(new Object[]{SAMPLE, CONTAMINATION, ERROR});
        }
    }

    private static class ContaminationTableReader
    extends TableReader<ContaminationRecord> {
        public ContaminationTableReader(Path path) throws IOException {
            super(path);
        }

        @Override
        protected ContaminationRecord createRecord(DataLine dataLine) {
            String sample = dataLine.get(ContaminationTableColumn.SAMPLE);
            double contamination = dataLine.getDouble(ContaminationTableColumn.CONTAMINATION);
            double error = dataLine.getDouble(ContaminationTableColumn.ERROR);
            return new ContaminationRecord(sample, contamination, error);
        }
    }

    private static class ContaminationTableWriter
    extends TableWriter<ContaminationRecord> {
        private ContaminationTableWriter(Path output) throws IOException {
            super(output, ContaminationTableColumn.COLUMNS);
        }

        @Override
        protected void composeLine(ContaminationRecord record, DataLine dataLine) {
            dataLine.set(ContaminationTableColumn.SAMPLE.toString(), record.getSample()).set(ContaminationTableColumn.CONTAMINATION.toString(), record.getContamination()).set(ContaminationTableColumn.ERROR.toString(), record.getError());
        }
    }
}

