/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.contamination;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.Range;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.hellbender.tools.copynumber.utils.segmentation.KernelSegmenter;
import org.broadinstitute.hellbender.tools.walkers.contamination.PileupSummary;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public class ContaminationSegmenter {
    public static final Range<Double> ALT_FRACTIONS_FOR_SEGMENTATION = Range.between((Comparable)Double.valueOf(0.1), (Comparable)Double.valueOf(0.9));
    public static final double KERNEL_SEGMENTER_LINEAR_COST = 1.0;
    public static final double KERNEL_SEGMENTER_LOG_LINEAR_COST = 1.0;
    public static final int KERNEL_SEGMENTER_DIMENSION = 100;
    public static final int POINTS_PER_SEGMENTATION_WINDOW = 50;
    public static final int MAX_CHANGEPOINTS_PER_CHROMOSOME = 10;
    private static final double SEGMENTATION_KERNEL_VARIANCE = 0.025;
    static final BiFunction<PileupSummary, PileupSummary, Double> SEGMENTATION_KERNEL = (ps1, ps2) -> {
        double maf1 = FastMath.min((double)ps1.getAltFraction(), (double)(1.0 - ps1.getAltFraction()));
        double maf2 = FastMath.min((double)ps2.getAltFraction(), (double)(1.0 - ps2.getAltFraction()));
        return FastMath.exp((double)(-MathUtils.square(maf1 - maf2) / 0.05));
    };

    private ContaminationSegmenter() {
    }

    public static List<List<PileupSummary>> findSegments(List<PileupSummary> sites) {
        Map<String, List<PileupSummary>> sitesByContig = sites.stream().collect(Collectors.groupingBy(PileupSummary::getContig));
        OverlapDetector od = OverlapDetector.create(sites);
        return sitesByContig.values().stream().flatMap(contig -> ContaminationSegmenter.findContigSegments(contig).stream()).map(segment -> od.getOverlaps((Locatable)segment).stream().sorted(Comparator.comparingInt(PileupSummary::getStart)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private static List<SimpleInterval> findContigSegments(List<PileupSummary> sites) {
        List hetSites = sites.stream().filter(ps -> ALT_FRACTIONS_FOR_SEGMENTATION.contains((Object)ps.getAltFraction())).collect(Collectors.toList());
        if (hetSites.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> changepoints = new ArrayList<Integer>();
        changepoints.add(-1);
        changepoints.addAll(new KernelSegmenter(hetSites).findChangepoints(10, SEGMENTATION_KERNEL, 100, Arrays.asList(50), 1.0, 1.0, KernelSegmenter.ChangepointSortOrder.INDEX));
        changepoints.add(hetSites.size() - 1);
        return IntStream.range(0, changepoints.size() - 1).mapToObj(n -> {
            PileupSummary firstSiteInSegment = (PileupSummary)hetSites.get((Integer)changepoints.get(n) + 1);
            PileupSummary lastSiteInSegment = (PileupSummary)hetSites.get((Integer)changepoints.get(n + 1));
            return new SimpleInterval(firstSiteInSegment.getContig(), firstSiteInSegment.getStart(), lastSiteInSegment.getEnd());
        }).collect(Collectors.toList());
    }
}

