/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.contamination;

import htsjdk.samtools.SAMSequenceDictionary;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.tools.walkers.contamination.PileupSummary;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Combine output files from GetPileupSummary in the order defined by a sequence dictionary", oneLineSummary="Combine output files from GetPileupSummary in the order defined by a sequence dictionary", programGroup=DiagnosticsAndQCProgramGroup.class)
public class GatherPileupSummaries
extends CommandLineProgram {
    @Argument(fullName="sequence-dictionary", doc="sequence dictionary file")
    final File sequenceDictionaryFile = null;
    @Argument(fullName="I", doc="an output of PileupSummaryTable")
    final List<File> input = null;
    @Argument(fullName="O", doc="output")
    final File output = null;
    SAMSequenceDictionary sequenceDictionary = null;

    @Override
    protected void onStartup() {
        this.sequenceDictionary = ReferenceUtils.loadFastaDictionary(this.sequenceDictionaryFile);
    }

    @Override
    protected Object doWork() {
        List<File> nonEmptyFiles = this.removeEmptyFiles(this.input);
        Collections.sort(nonEmptyFiles, new PileupSummaryFileComparator(this.sequenceDictionary));
        PileupSummary.writeToFile(nonEmptyFiles, this.output);
        return String.format("Successfully merged %d samples", nonEmptyFiles.size());
    }

    private List<File> removeEmptyFiles(List<File> list) {
        List<File> nonEmptyList = list.stream().filter(f -> ((List)PileupSummary.readFromFile(f).getRight()).size() > 0).collect(Collectors.toList());
        if (nonEmptyList.size() < list.size()) {
            this.logger.info(String.format("Removed %d empty samples", list.size() - nonEmptyList.size()));
        }
        return nonEmptyList;
    }

    private class PileupSummaryFileComparator
    implements Comparator<File> {
        final SAMSequenceDictionary sequenceDictionary;

        private PileupSummaryFileComparator(SAMSequenceDictionary sequenceDictionary) {
            this.sequenceDictionary = sequenceDictionary;
        }

        @Override
        public int compare(File file1, File file2) {
            PileupSummary ps1 = (PileupSummary)((List)PileupSummary.readFromFile(file1).getRight()).get(0);
            PileupSummary ps2 = (PileupSummary)((List)PileupSummary.readFromFile(file2).getRight()).get(0);
            return new PileupSummary.PileupSummaryComparator(this.sequenceDictionary).compare(ps1, ps2);
        }
    }
}

