/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.contamination;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.contamination.PileupSummary;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@CommandLineProgramProperties(summary="Tabulates pileup metrics for inferring contamination", oneLineSummary="Tabulates pileup metrics for inferring contamination", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
public class GetPileupSummaries
extends LocusWalker {
    public static final String MAX_SITE_AF_LONG_NAME = "maximum-population-allele-frequency";
    public static final String MIN_SITE_AF_LONG_NAME = "minimum-population-allele-frequency";
    public static final String MAX_SITE_AF_SHORT_NAME = "max-af";
    public static final String MIN_SITE_AF_SHORT_NAME = "min-af";
    public static final String MIN_MAPPING_QUALITY_LONG_NAME = "min-mapping-quality";
    public static final String MIN_MAPPING_QUALITY_SHORT_NAME = "mmq";
    private static final double DEFAULT_MIN_POPULATION_AF = 0.01;
    private static final double DEFAULT_MAX_POPULATION_AF = 0.2;
    private static final int DEFAULT_MINIMUM_MAPPING_QUALITY = 50;
    @Argument(fullName="output", shortName="O", doc="The output table", optional=false)
    private File outputTable;
    @Argument(fullName="variant", shortName="V", doc="A VCF file containing variants and allele frequencies")
    public FeatureInput<VariantContext> variants;
    @Argument(fullName="minimum-population-allele-frequency", shortName="min-af", doc="Minimum population allele frequency of sites to consider.  A low value increases accuracy at the expense of speed.", optional=true)
    private double minPopulationAlleleFrequency = 0.01;
    @Argument(fullName="maximum-population-allele-frequency", shortName="max-af", doc="Maximum population allele frequency of sites to consider.", optional=true)
    private double maxPopulationAlleleFrequency = 0.2;
    @Argument(fullName="min-mapping-quality", shortName="mmq", doc="Minimum read mapping quality", optional=true)
    private int minMappingQuality = 50;
    private final List<PileupSummary> pileupSummaries = new ArrayList<PileupSummary>();
    private boolean sawVariantsWithoutAlleleFrequency = false;
    private boolean sawVariantsWithAlleleFrequency = false;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public boolean requiresReference() {
        return false;
    }

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public boolean requiresFeatures() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>();
        filters.add(ReadFilterLibrary.MAPPING_QUALITY_AVAILABLE);
        filters.add(ReadFilterLibrary.MAPPING_QUALITY_NOT_ZERO);
        filters.add(ReadFilterLibrary.MAPPED);
        filters.add(ReadFilterLibrary.PRIMARY_LINE);
        filters.add(ReadFilterLibrary.NOT_DUPLICATE);
        filters.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        filters.add(ReadFilterLibrary.NON_ZERO_REFERENCE_LENGTH_ALIGNMENT);
        filters.add(ReadFilterLibrary.MATE_ON_SAME_CONTIG_OR_NO_MAPPED_MATE);
        filters.add(ReadFilterLibrary.GOOD_CIGAR);
        filters.add(new WellformedReadFilter());
        return filters;
    }

    @Override
    public void onTraversalStart() {
        boolean alleleFrequencyInHeader = ((VCFHeader)this.getHeaderForFeatures(this.variants)).getInfoHeaderLines().stream().anyMatch(line -> line.getID().equals("AF"));
        if (!alleleFrequencyInHeader) {
            throw new UserException.BadInput("Population vcf does not have an allele frequency (AF) info field in its header.");
        }
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        List<VariantContext> vcs = featureContext.getValues(this.variants);
        if (vcs.isEmpty()) {
            return;
        }
        VariantContext vc = vcs.get(0);
        if (vc.isBiallelic() && vc.isSNP() && this.alleleFrequencyInRange(vc)) {
            ReadPileup pileup = alignmentContext.getBasePileup().makeFilteredPileup(pe -> pe.getRead().getMappingQuality() >= this.minMappingQuality);
            this.pileupSummaries.add(new PileupSummary(vc, pileup));
        }
    }

    @Override
    public Object onTraversalSuccess() {
        if (this.sawVariantsWithoutAlleleFrequency && !this.sawVariantsWithAlleleFrequency) {
            throw new UserException.BadInput("No variants in population vcf had an allele frequency (AF) field.");
        }
        String sampleName = (String)ReadUtils.getSamplesFromHeader(this.getHeaderForReads()).stream().findFirst().get();
        PileupSummary.writeToFile(sampleName, this.pileupSummaries, this.outputTable);
        return "SUCCESS";
    }

    private boolean alleleFrequencyInRange(VariantContext vc) {
        if (!vc.hasAttribute("AF")) {
            if (!this.sawVariantsWithoutAlleleFrequency) {
                this.logger.warn(String.format("Variant context at %s:%d lacks allele frequency (AF) field.", vc.getContig(), vc.getStart()));
                this.sawVariantsWithoutAlleleFrequency = true;
            }
            return false;
        }
        this.sawVariantsWithAlleleFrequency = true;
        double alleleFrequency = vc.getAttributeAsDouble("AF", -1.0);
        return this.minPopulationAlleleFrequency < alleleFrequency && alleleFrequency < this.maxPopulationAlleleFrequency;
    }
}

