/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.contamination;

import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class MinorAlleleFractionRecord
implements Locatable {
    private final SimpleInterval segment;
    private double minorAlleleFraction;

    public MinorAlleleFractionRecord(SimpleInterval segment, double minorAlleleFraction) {
        this.segment = segment;
        this.minorAlleleFraction = minorAlleleFraction;
    }

    public String getContig() {
        return this.segment.getContig();
    }

    public int getStart() {
        return this.segment.getStart();
    }

    public int getEnd() {
        return this.segment.getEnd();
    }

    public SimpleInterval getSegment() {
        return this.segment;
    }

    public double getMinorAlleleFraction() {
        return this.minorAlleleFraction;
    }

    public static void writeToFile(String sample, List<MinorAlleleFractionRecord> records, File outputTable) {
        try (MinorAlleleFractionTableWriter writer = new MinorAlleleFractionTableWriter(IOUtils.fileToPath(outputTable));){
            writer.writeMetadata("SAMPLE", sample);
            writer.writeAllRecords(records);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", outputTable));
        }
    }

    public static ImmutablePair<String, List<MinorAlleleFractionRecord>> readFromFile(File tableFile) {
        return MinorAlleleFractionRecord.readFromPath(IOUtils.fileToPath(tableFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImmutablePair<String, List<MinorAlleleFractionRecord>> readFromPath(Path tablePath) {
        try (MinorAlleleFractionTableReader reader = new MinorAlleleFractionTableReader(tablePath);){
            List list = reader.toList();
            ImmutablePair immutablePair = ImmutablePair.of((Object)reader.getMetadata().get("SAMPLE"), list);
            return immutablePair;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", tablePath));
        }
    }

    private static enum MinorAlleleFractionTableColumn {
        CONTIG("contig"),
        START("start"),
        END("end"),
        MAF("minor_allele_fraction");

        private final String columnName;
        public static final TableColumnCollection COLUMNS;

        private MinorAlleleFractionTableColumn(String columnName) {
            this.columnName = Utils.nonNull(columnName);
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(new Object[]{CONTIG, START, END, MAF});
        }
    }

    public static class MinorAlleleFractionTableReader
    extends TableReader<MinorAlleleFractionRecord> {
        public MinorAlleleFractionTableReader(Path path) throws IOException {
            super(path);
        }

        @Override
        protected MinorAlleleFractionRecord createRecord(DataLine dataLine) {
            String contig = dataLine.get(MinorAlleleFractionTableColumn.CONTIG);
            int start = dataLine.getInt(MinorAlleleFractionTableColumn.START);
            int end = dataLine.getInt(MinorAlleleFractionTableColumn.END);
            double maf = dataLine.getDouble(MinorAlleleFractionTableColumn.MAF);
            return new MinorAlleleFractionRecord(new SimpleInterval(contig, start, end), maf);
        }
    }

    private static class MinorAlleleFractionTableWriter
    extends TableWriter<MinorAlleleFractionRecord> {
        private MinorAlleleFractionTableWriter(Path output) throws IOException {
            super(output, MinorAlleleFractionTableColumn.COLUMNS);
        }

        @Override
        protected void composeLine(MinorAlleleFractionRecord record, DataLine dataLine) {
            SimpleInterval segment = record.getSegment();
            dataLine.set(MinorAlleleFractionTableColumn.CONTIG.toString(), segment.getContig()).set(MinorAlleleFractionTableColumn.START.toString(), segment.getStart()).set(MinorAlleleFractionTableColumn.END.toString(), segment.getEnd()).set(MinorAlleleFractionTableColumn.MAF.toString(), record.getMinorAlleleFraction());
        }
    }
}

