/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.coverage;

import com.google.common.collect.Lists;
import com.opencsv.CSVWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.coverage.CoverageUtils;
import org.broadinstitute.hellbender.tools.walkers.coverage.DepthOfCoveragePartitionedDataStore;
import org.broadinstitute.hellbender.tools.walkers.coverage.DepthOfCoverageStats;
import org.broadinstitute.hellbender.tools.walkers.coverage.DoCOutputType;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.refseq.RefSeqFeature;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public class CoverageOutputWriter
implements Closeable {
    static final List<String> CUMULATIVE_SUMMARY_OUTPUT_LINES = Collections.unmodifiableList(Arrays.asList("sample_id", "total", "mean", "granular_third_quartile", "granular_median", "granular_first_quartile"));
    private static final char TSV_SEPARATOR = '\t';
    private static final char CSV_SEPARATOR = ',';
    private final EnumSet<DoCOutputType.Partition> partitions;
    private final boolean includeGeneOutput;
    private final boolean omitIntervals;
    private List<String> summaryHeaderSampleSuffixes;
    private boolean printBaseCounts;
    private Map<DoCOutputType, SimpleCSVWriterWrapperWithHeader> outputs;
    private DEPTH_OF_COVERAGE_OUTPUT_FORMAT outputFormat;
    private boolean omitDepthOutput;
    private List<Integer> coverageThresholds;
    private final DecimalFormat DOUBLE_FORMAT_2PLACES = new DecimalFormat("0.00");
    private final DecimalFormat DOUBLE_FORMAT_1PLACE = new DecimalFormat("0.0");

    public CoverageOutputWriter(DEPTH_OF_COVERAGE_OUTPUT_FORMAT outputFormat, EnumSet<DoCOutputType.Partition> partitionsToCover, String outputBaseName, boolean includeGeneOutputPerSample, boolean printBaseCounts, boolean omitDepthOutput, boolean omitIntervals, boolean omitSampleSummary, boolean omitLocusTable, List<Integer> coverageThresholds) throws IOException {
        this.DOUBLE_FORMAT_2PLACES.setRoundingMode(RoundingMode.HALF_UP);
        this.DOUBLE_FORMAT_1PLACE.setRoundingMode(RoundingMode.HALF_UP);
        this.outputFormat = outputFormat;
        this.partitions = partitionsToCover;
        this.includeGeneOutput = includeGeneOutputPerSample;
        this.omitIntervals = omitIntervals;
        this.printBaseCounts = printBaseCounts;
        this.omitDepthOutput = omitDepthOutput;
        this.coverageThresholds = coverageThresholds;
        this.summaryHeaderSampleSuffixes = this.getSampleSuffixes(coverageThresholds);
        char separator = outputFormat == DEPTH_OF_COVERAGE_OUTPUT_FORMAT.CSV ? (char)',' : '\t';
        this.outputs = new HashMap<DoCOutputType, SimpleCSVWriterWrapperWithHeader>();
        if (!omitDepthOutput) {
            DoCOutputType depthSummaryByLocus = new DoCOutputType(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary);
            this.outputs.put(depthSummaryByLocus, CoverageOutputWriter.getOutputStream(outputBaseName, depthSummaryByLocus, separator));
        }
        if (!omitIntervals) {
            for (DoCOutputType.Partition partition : partitionsToCover) {
                DoCOutputType intervalSummaryBypartition = new DoCOutputType(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.summary);
                this.outputs.put(intervalSummaryBypartition, CoverageOutputWriter.getOutputStream(outputBaseName, intervalSummaryBypartition, separator));
                DoCOutputType intervalStatisticsByPartition = new DoCOutputType(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.statistics);
                this.outputs.put(intervalStatisticsByPartition, CoverageOutputWriter.getOutputStream(outputBaseName, intervalStatisticsByPartition, separator));
            }
        }
        if (this.canWriteGeneOutput()) {
            DoCOutputType geneSummaryOut = new DoCOutputType(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.summary);
            this.outputs.put(geneSummaryOut, CoverageOutputWriter.getOutputStream(outputBaseName, geneSummaryOut, separator));
            DoCOutputType geneStatisticsByPartition = new DoCOutputType(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.statistics);
            this.outputs.put(geneStatisticsByPartition, CoverageOutputWriter.getOutputStream(outputBaseName, geneStatisticsByPartition, separator));
        }
        if (!omitSampleSummary) {
            for (DoCOutputType.Partition partition : partitionsToCover) {
                DoCOutputType cumulativeSummaryOut = new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.summary);
                this.outputs.put(cumulativeSummaryOut, CoverageOutputWriter.getOutputStream(outputBaseName, cumulativeSummaryOut, separator));
                DoCOutputType cumulativeStatisticsOut = new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.statistics);
                this.outputs.put(cumulativeStatisticsOut, CoverageOutputWriter.getOutputStream(outputBaseName, cumulativeStatisticsOut, separator));
            }
        }
        if (!omitLocusTable) {
            for (DoCOutputType.Partition partition : partitionsToCover) {
                DoCOutputType cumulativeCoverageCountsOut = new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_counts);
                this.outputs.put(cumulativeCoverageCountsOut, CoverageOutputWriter.getOutputStream(outputBaseName, cumulativeCoverageCountsOut, separator));
                DoCOutputType cumulativeCoverageProportionsOut = new DoCOutputType(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_proportions);
                this.outputs.put(cumulativeCoverageProportionsOut, CoverageOutputWriter.getOutputStream(outputBaseName, cumulativeCoverageProportionsOut, separator));
            }
        }
    }

    private boolean canWriteGeneOutput() {
        return this.includeGeneOutput && this.partitions.contains((Object)DoCOutputType.Partition.sample);
    }

    private static SimpleCSVWriterWrapperWithHeader getOutputStream(String outputBaseName, DoCOutputType depthSummaryByLocus, char separator) throws IOException {
        return new SimpleCSVWriterWrapperWithHeader(Files.newBufferedWriter(IOUtils.getPath(depthSummaryByLocus.getFilePath(outputBaseName)), new OpenOption[0]), separator);
    }

    public void writeCoverageOutputHeaders(Map<DoCOutputType.Partition, List<String>> sortedSamplesByPartition) {
        if (!this.omitDepthOutput) {
            this.writePerLocusDepthOutputSummaryHeader(sortedSamplesByPartition);
        }
        if (this.canWriteGeneOutput()) {
            SimpleCSVWriterWrapperWithHeader geneSummaryOut = this.getCorrectOutputWriter(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.summary);
            geneSummaryOut.addHeaderLine(this.getIntervalSummaryHeader("Gene", (Collection<String>)sortedSamplesByPartition.get((Object)DoCOutputType.Partition.sample)));
        }
        if (!this.omitIntervals) {
            for (DoCOutputType.Partition partition : this.partitions) {
                SimpleCSVWriterWrapperWithHeader intervalSummaryOut = this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.summary);
                intervalSummaryOut.addHeaderLine(this.getIntervalSummaryHeader("Target", (Collection<String>)sortedSamplesByPartition.get((Object)partition)));
            }
        }
    }

    private void writePerLocusDepthOutputSummaryHeader(Map<DoCOutputType.Partition, List<String>> identifiersByType) {
        SimpleCSVWriterWrapperWithHeader out = this.getCorrectOutputWriter(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary);
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"Locus", "Total_Depth"});
        for (DoCOutputType.Partition type : this.partitions) {
            columns.add("Average_Depth_" + type.toString());
        }
        for (DoCOutputType.Partition type : this.partitions) {
            for (String s : identifiersByType.get((Object)type)) {
                columns.add("Depth_for_" + s);
                if (!this.printBaseCounts) continue;
                columns.add(s + "_base_counts");
            }
        }
        out.addHeaderLine(columns);
    }

    private SimpleCSVWriterWrapperWithHeader getCorrectOutputWriter(DoCOutputType.Partition partition, DoCOutputType.Aggregation aggregation, DoCOutputType.FileType fileType) {
        DoCOutputType outputType = new DoCOutputType(partition, aggregation, fileType);
        if (!this.outputs.containsKey(outputType)) {
            throw new GATKException(String.format("Unable to find appropriate stream for partition = %s, aggregation = %s, file type = %s", new Object[]{partition, aggregation, fileType}));
        }
        return this.outputs.get(outputType);
    }

    public void writePerLocusDepthSummary(SimpleInterval locus, Map<DoCOutputType.Partition, Map<String, int[]>> countsBySampleByType, Map<DoCOutputType.Partition, List<String>> identifiersByType, boolean includeDeletions) {
        SimpleCSVWriterWrapperWithHeader lineWriter = this.getCorrectOutputWriter(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary);
        SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = lineWriter.getNewLineBuilder();
        int tDepth = 0;
        boolean depthCounted = false;
        for (DoCOutputType.Partition type : this.partitions) {
            Map<String, int[]> countsByID = countsBySampleByType.get((Object)type);
            for (String sample : identifiersByType.get((Object)type)) {
                long dp = countsByID != null && countsByID.keySet().contains(sample) ? MathUtils.sum(countsByID.get(sample)) : 0L;
                lineBuilder.setColumn("Depth_for_" + sample, Long.toString(dp));
                if (this.printBaseCounts) {
                    lineBuilder.setColumn(sample + "_base_counts", this.getBaseCountsString(countsByID != null ? countsByID.get(sample) : null, includeDeletions));
                }
                if (depthCounted) continue;
                tDepth = (int)((long)tDepth + dp);
            }
            depthCounted = true;
        }
        lineBuilder.setColumn(0, locus.getContig() + ":" + locus.getStart()).setColumn(1, Integer.toString(tDepth));
        for (DoCOutputType.Partition type : this.partitions) {
            lineBuilder.setColumn("Average_Depth_" + type.toString(), this.DOUBLE_FORMAT_2PLACES.format((double)tDepth / (double)identifiersByType.get((Object)type).size()));
        }
        lineBuilder.buildAndWriteLine();
    }

    public void writePerIntervalDepthInformation(DoCOutputType.Partition partition, SimpleInterval interval, DepthOfCoverageStats intervalStats, List<String> sortedSamples) {
        SimpleCSVWriterWrapperWithHeader output = this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.summary);
        this.printIntervalSummaryLine(output, interval.toString(), intervalStats, sortedSamples);
    }

    public void writePerGeneDepthInformation(RefSeqFeature gene, DepthOfCoverageStats intervalStats, List<String> sortedSamples) {
        SimpleCSVWriterWrapperWithHeader output = this.getCorrectOutputWriter(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.summary);
        this.printIntervalSummaryLine(output, gene.getGeneName(), intervalStats, sortedSamples);
    }

    public void writePerLocusCumulativeCoverageMetrics(DepthOfCoveragePartitionedDataStore coverageProfilesForEntireTraversal, DoCOutputType.Partition partition, List<String> sortedSampleLists) {
        this.outputPerLocusCumulativeSummaryAndStatistics(this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_counts), this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_proportions), coverageProfilesForEntireTraversal.getCoverageByAggregationType(partition), partition, sortedSampleLists);
    }

    public void writeCumulativeOutputSummaryFiles(DepthOfCoveragePartitionedDataStore coverageProfilesForEntireTraversal, DoCOutputType.Partition partition, List<String> sortedSamples) {
        this.outputPerSampleCumulativeStatisticsForPartition(this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.statistics), coverageProfilesForEntireTraversal.getCoverageByAggregationType(partition), sortedSamples);
        this.outputCumulativeSummaryForPartition(this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.summary), coverageProfilesForEntireTraversal.getCoverageByAggregationType(partition), sortedSamples);
    }

    public void writeOutputIntervalStatistics(DoCOutputType.Partition partition, int[][] nTargetsByAvgCvgBySample, int[] binEndpoints) {
        SimpleCSVWriterWrapperWithHeader output = this.getCorrectOutputWriter(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.statistics);
        this.printIntervalTable(output, nTargetsByAvgCvgBySample, binEndpoints);
    }

    public void writeOutputGeneStatistics(int[][] nTargetsByAvgCvgBySample, int[] binEndpoints) {
        SimpleCSVWriterWrapperWithHeader output = this.getCorrectOutputWriter(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.statistics);
        this.printIntervalTable(output, nTargetsByAvgCvgBySample, binEndpoints);
    }

    private void outputPerLocusCumulativeSummaryAndStatistics(SimpleCSVWriterWrapperWithHeader countsOutput, SimpleCSVWriterWrapperWithHeader proportionsOutput, DepthOfCoverageStats stats, DoCOutputType.Partition partitionType, List<String> sortedSampleList) {
        int[] endpoints = stats.getEndpoints();
        int samples = stats.getHistograms().size();
        long[][] baseCoverageCumDist = stats.getLocusCounts();
        ArrayList headerLines = Lists.newArrayList((Object[])new String[]{partitionType == DoCOutputType.Partition.readgroup ? "read_group" : partitionType.toString(), "gte_0"});
        for (int d : endpoints) {
            headerLines.add("gte_" + d);
        }
        countsOutput.addHeaderLine(headerLines);
        proportionsOutput.addHeaderLine(headerLines);
        for (int row = 0; row < samples; ++row) {
            SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = countsOutput.getNewLineBuilder();
            lineBuilder.setColumn(0, "NSamples_" + Integer.toString(row + 1));
            for (int col = 0; col < baseCoverageCumDist[0].length; ++col) {
                lineBuilder.setColumn(col + 1, Long.toString(baseCoverageCumDist[row][col]));
            }
            lineBuilder.buildAndWriteLine();
        }
        for (String sample : sortedSampleList) {
            SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = proportionsOutput.getNewLineBuilder();
            lineBuilder.setColumn(0, sample);
            double[] coverageDistribution = stats.getCoverageProportions(sample);
            for (int bin = 0; bin < coverageDistribution.length; ++bin) {
                lineBuilder.setColumn(bin + 1, this.DOUBLE_FORMAT_2PLACES.format(coverageDistribution[bin]));
            }
            lineBuilder.buildAndWriteLine();
        }
    }

    private List<String> getIntervalSummaryHeader(String title, Collection<String> allSamples) {
        ArrayList summaryHeader = Lists.newArrayList((Object[])new String[]{title, "total_coverage", "average_coverage"});
        for (String sample : allSamples) {
            for (String suffix : this.summaryHeaderSampleSuffixes) {
                summaryHeader.add(sample + suffix);
            }
        }
        return summaryHeader;
    }

    private List<String> getSampleSuffixes(List<Integer> coverageThresholds) {
        ArrayList tmp = Lists.newArrayList((Object[])new String[]{"_total_cvg", "_mean_cvg", "_granular_Q1", "_granular_median", "_granular_Q3"});
        for (int thresh : coverageThresholds) {
            tmp.add("_%_above_" + thresh);
        }
        return Collections.unmodifiableList(tmp);
    }

    private void printIntervalSummaryLine(SimpleCSVWriterWrapperWithHeader outputWriter, String locusName, DepthOfCoverageStats stats, List<String> sortedSamples) {
        SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = outputWriter.getNewLineBuilder();
        int[] bins = stats.getEndpoints();
        lineBuilder.setColumn(0, locusName).setColumn("total_coverage", Long.toString(stats.getTotalCoverage())).setColumn("average_coverage", this.DOUBLE_FORMAT_2PLACES.format(stats.getTotalMeanCoverage()));
        for (String s : sortedSamples) {
            int sIdx = outputWriter.getIndexForColumn(s + "_total_cvg");
            int median = CoverageUtils.getQuantile(stats.getHistograms().get(s), 0.5);
            int q1 = CoverageUtils.getQuantile(stats.getHistograms().get(s), 0.25);
            int q3 = CoverageUtils.getQuantile(stats.getHistograms().get(s), 0.75);
            lineBuilder.setColumn(sIdx, Long.toString(stats.getTotals().get(s))).setColumn(sIdx + 1, this.DOUBLE_FORMAT_2PLACES.format(stats.getMeans().get(s))).setColumn(sIdx + 2, this.formatBin(bins, q1)).setColumn(sIdx + 3, this.formatBin(bins, median)).setColumn(sIdx + 4, this.formatBin(bins, q3));
            for (int thresh : this.coverageThresholds) {
                lineBuilder.setColumn(s + "_%_above_" + thresh, this.DOUBLE_FORMAT_1PLACE.format(CoverageUtils.getPctBasesAbove(stats.getHistograms().get(s), stats.value2bin(thresh))));
            }
        }
        lineBuilder.buildAndWriteLine();
    }

    private void outputPerSampleCumulativeStatisticsForPartition(SimpleCSVWriterWrapperWithHeader output, DepthOfCoverageStats stats, List<String> sortedSamples) {
        int[] leftEnds = stats.getEndpoints();
        ArrayList headerColumns = Lists.newArrayList((Object[])new String[]{"Source_of_reads"});
        headerColumns.add("from_0_to_" + leftEnds[0] + ")");
        for (int i = 1; i < leftEnds.length; ++i) {
            headerColumns.add("from_" + leftEnds[i - 1] + "_to_" + leftEnds[i] + ")");
        }
        headerColumns.add("from_" + leftEnds[leftEnds.length - 1] + "_to_inf");
        output.addHeaderLine(headerColumns);
        Map<String, long[]> histograms = stats.getHistograms();
        for (String sample : sortedSamples) {
            SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = output.getNewLineBuilder();
            lineBuilder.setColumn("Source_of_reads", "sample_" + sample);
            long[] histForSample = histograms.get(sample);
            for (int i = 0; i < histForSample.length; ++i) {
                lineBuilder.setColumn(i + 1, Long.toString(histForSample[i]));
            }
            lineBuilder.buildAndWriteLine();
        }
    }

    private void outputCumulativeSummaryForPartition(SimpleCSVWriterWrapperWithHeader output, DepthOfCoverageStats stats, List<String> sortedSamples) {
        ArrayList headerLines = Lists.newArrayList(CUMULATIVE_SUMMARY_OUTPUT_LINES);
        for (int thresh : this.coverageThresholds) {
            headerLines.add("%_bases_above_" + thresh);
        }
        output.addHeaderLine(headerLines);
        Map<String, long[]> histograms = stats.getHistograms();
        Map<String, Double> means = stats.getMeans();
        Map<String, Long> totals = stats.getTotals();
        int[] leftEnds = stats.getEndpoints();
        for (String sample : sortedSamples) {
            SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = output.getNewLineBuilder();
            long[] histogram = histograms.get(sample);
            int median = CoverageUtils.getQuantile(histogram, 0.5);
            int q1 = CoverageUtils.getQuantile(histogram, 0.25);
            int q3 = CoverageUtils.getQuantile(histogram, 0.75);
            median = median == histogram.length - 1 ? histogram.length - 2 : median;
            q1 = q1 == histogram.length - 1 ? histogram.length - 2 : q1;
            q3 = q3 == histogram.length - 1 ? histogram.length - 2 : q3;
            lineBuilder.setColumn(0, sample).setColumn(1, Long.toString(totals.get(sample))).setColumn(2, this.DOUBLE_FORMAT_2PLACES.format(means.get(sample))).setColumn(3, Integer.toString(leftEnds[q3])).setColumn(4, Integer.toString(leftEnds[median])).setColumn(5, Integer.toString(leftEnds[q1]));
            for (int thresh : this.coverageThresholds) {
                lineBuilder.setColumn("%_bases_above_" + thresh, this.DOUBLE_FORMAT_1PLACE.format(CoverageUtils.getPctBasesAbove(histogram, stats.value2bin(thresh))));
            }
            lineBuilder.buildAndWriteLine();
        }
        SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = output.getNewLineBuilder();
        lineBuilder.setColumn(0, "Total").setColumn(1, Long.toString(stats.getTotalCoverage())).setColumn(2, this.DOUBLE_FORMAT_2PLACES.format(stats.getTotalMeanCoverage())).fill("N/A").buildAndWriteLine();
    }

    private void printIntervalTable(SimpleCSVWriterWrapperWithHeader output, int[][] intervalTable, int[] cutoffs) {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"Number_of_sources", "depth>=0"});
        for (int col = 0; col < intervalTable[0].length - 1; ++col) {
            columns.add("depth>=" + cutoffs[col]);
        }
        output.addHeaderLine(columns);
        for (int row = 0; row < intervalTable.length; ++row) {
            SimpleCSVWriterWrapperWithHeader.SimpleCSVWriterLineBuilder lineBuilder = output.getNewLineBuilder();
            lineBuilder.setColumn(0, "At_least_" + Integer.toString(row + 1) + "_samples");
            for (int col = 0; col < intervalTable[0].length; ++col) {
                lineBuilder.setColumn(col + 1, Integer.toString(intervalTable[row][col]));
            }
            lineBuilder.buildAndWriteLine();
        }
    }

    private String formatBin(int[] bins, int quartile) {
        if (quartile >= bins.length) {
            return ">" + Integer.toString(bins[bins.length - 1]);
        }
        if (quartile < 0) {
            return "<" + Integer.toString(bins[0]);
        }
        return Integer.toString(bins[quartile]);
    }

    private String getBaseCountsString(int[] counts, boolean includeDeletions) {
        if (counts == null) {
            counts = new int[6];
        }
        StringBuilder s = new StringBuilder();
        int nbases = 0;
        for (byte b : BaseUtils.BASES_EXTENDED) {
            ++nbases;
            if (!includeDeletions && b == BaseUtils.Base.D.base) continue;
            s.append((char)b);
            s.append(":");
            s.append(counts[BaseUtils.extendedBaseToBaseIndex(b)]);
            if (nbases >= 6) continue;
            s.append(" ");
        }
        return s.toString();
    }

    @Override
    public void close() {
        try {
            for (SimpleCSVWriterWrapperWithHeader stream : this.outputs.values()) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new GATKException("Error closing output files:", e);
        }
    }

    static class SimpleCSVWriterWrapperWithHeader
    implements Closeable {
        private int expectedColumns;
        private Map<String, Integer> headerMap = null;
        private CSVWriter outputWriter;
        private SimpleCSVWriterLineBuilder currentLine = null;

        private SimpleCSVWriterWrapperWithHeader(Writer writer, char separator) {
            this.outputWriter = new CSVWriter(writer, separator);
        }

        private void addHeaderLine(List<String> columns) {
            if (this.headerMap != null) {
                throw new GATKException("Should not be adding multiple header lines to a file");
            }
            this.outputWriter.writeNext(columns.toArray(new String[0]), false);
            this.expectedColumns = columns.size();
            this.headerMap = new HashMap<String, Integer>();
            for (int i = 0; i < columns.size(); ++i) {
                String columnHeading = columns.get(i);
                Utils.nonNull(columnHeading);
                if (this.headerMap.putIfAbsent(columnHeading, i) == null) continue;
                throw new GATKException("Only allow unique column headings");
            }
        }

        private void writeLine(String[] line) {
            this.outputWriter.writeNext(line, false);
            this.currentLine = null;
        }

        private SimpleCSVWriterLineBuilder getNewLineBuilder() {
            if (this.headerMap == null) {
                throw new GATKException("Cannot construct line without first setting the header line");
            }
            if (this.currentLine != null) {
                this.currentLine.buildAndWriteLine();
            }
            this.currentLine = new SimpleCSVWriterLineBuilder(this, this.expectedColumns);
            return this.currentLine;
        }

        private int getIndexForColumn(String column) {
            Utils.nonNull(this.headerMap, "Cannot request column index if the header has not been specified");
            int index = this.headerMap.get(column);
            Utils.nonNull(Integer.valueOf(index), "Requested column " + column + " does not exist in the provided header");
            return index;
        }

        @Override
        public void close() throws IOException {
            if (this.currentLine != null) {
                this.currentLine.buildAndWriteLine();
            }
            this.outputWriter.close();
        }

        private static class SimpleCSVWriterLineBuilder {
            SimpleCSVWriterWrapperWithHeader thisBuilder;
            String[] lineToBuild;
            boolean hasBuilt = false;

            SimpleCSVWriterLineBuilder(SimpleCSVWriterWrapperWithHeader me, int lineLength) {
                this.thisBuilder = me;
                this.lineToBuild = new String[lineLength];
            }

            private SimpleCSVWriterLineBuilder setColumn(int index, String value) {
                this.checkAlteration();
                this.lineToBuild[index] = value;
                return this;
            }

            private SimpleCSVWriterLineBuilder setColumn(String heading, String value) {
                int index = this.thisBuilder.getIndexForColumn(heading);
                return this.setColumn(index, value);
            }

            private SimpleCSVWriterLineBuilder fill(String filling) {
                this.checkAlteration();
                for (int i = 0; i < this.lineToBuild.length; ++i) {
                    if (this.lineToBuild[i] != null) continue;
                    this.lineToBuild[i] = filling;
                }
                return this;
            }

            private void buildAndWriteLine() {
                Utils.validate(!Arrays.stream(this.lineToBuild).anyMatch(Objects::isNull), "Attempted to construct an incomplete line, make sure all columns are filled");
                this.thisBuilder.writeLine(this.lineToBuild);
                this.hasBuilt = true;
            }

            private void checkAlteration() {
                Utils.validate(!this.hasBuilt, "Cannot make alterations to an already written out CSV line");
            }
        }
    }

    public static enum DEPTH_OF_COVERAGE_OUTPUT_FORMAT {
        TABLE,
        CSV;

    }
}

