/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.coverage;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.coverage.DepthOfCoverageStats;
import org.broadinstitute.hellbender.tools.walkers.coverage.DoCOutputType;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

class CoverageUtils {
    private CoverageUtils() {
    }

    public static String getTypeID(SAMReadGroupRecord rg, DoCOutputType.Partition type) {
        switch (type) {
            case sample: {
                return rg.getSample();
            }
            case readgroup: {
                return rg.getSample() + "_rg_" + rg.getReadGroupId();
            }
            case library: {
                return rg.getLibrary();
            }
            case center: {
                return rg.getSequencingCenter();
            }
            case platform: {
                return rg.getPlatform();
            }
            case sample_by_center: {
                return rg.getSample() + "_cn_" + rg.getSequencingCenter();
            }
            case sample_by_platform: {
                return rg.getSample() + "_pl_" + rg.getPlatform();
            }
            case sample_by_platform_by_center: {
                return rg.getSample() + "_pl_" + rg.getPlatform() + "_cn_" + rg.getSequencingCenter();
            }
        }
        throw new GATKException(String.format("Invalid aggregation type %s", new Object[]{type}));
    }

    public static Map<DoCOutputType.Partition, Map<String, int[]>> getBaseCountsByPartition(AlignmentContext context, byte minBaseQ, byte maxBaseQ, CountPileupType countType, Collection<DoCOutputType.Partition> types, SAMFileHeader header) {
        HashMap<DoCOutputType.Partition, Map<String, int[]>> countsByIDByType = new HashMap<DoCOutputType.Partition, Map<String, int[]>>();
        Map<SAMReadGroupRecord, int[]> countsByRG = CoverageUtils.getBaseCountsByReadGroup(context, minBaseQ, maxBaseQ, countType, header);
        for (DoCOutputType.Partition t : types) {
            for (Map.Entry<SAMReadGroupRecord, int[]> readGroupCountEntry : countsByRG.entrySet()) {
                String typeID = CoverageUtils.getTypeID(readGroupCountEntry.getKey(), t);
                if (!countsByIDByType.keySet().contains((Object)t)) {
                    countsByIDByType.put(t, new HashMap());
                }
                if (!((Map)countsByIDByType.get((Object)t)).keySet().contains(typeID)) {
                    ((Map)countsByIDByType.get((Object)t)).put(typeID, readGroupCountEntry.getValue().clone());
                    continue;
                }
                CoverageUtils.addCounts((int[])((Map)countsByIDByType.get((Object)t)).get(typeID), readGroupCountEntry.getValue());
            }
        }
        return countsByIDByType;
    }

    private static void addCounts(int[] updateMe, int[] leaveMeAlone) {
        for (int index = 0; index < leaveMeAlone.length; ++index) {
            int n = index;
            updateMe[n] = updateMe[n] + leaveMeAlone[index];
        }
    }

    private static Map<SAMReadGroupRecord, int[]> getBaseCountsByReadGroup(AlignmentContext context, byte minBaseQ, byte maxBaseQ, CountPileupType countType, SAMFileHeader header) {
        HashMap<SAMReadGroupRecord, int[]> countsByRG = new HashMap<SAMReadGroupRecord, int[]>();
        HashMap<String, int[]> countsByRGName = new HashMap<String, int[]>();
        HashMap<String, SAMReadGroupRecord> RGByName = new HashMap<String, SAMReadGroupRecord>();
        ArrayList<PileupElement> countPileup = new ArrayList<PileupElement>(context.getBasePileup().size());
        switch (countType) {
            case COUNT_READS: {
                for (PileupElement read : context.getBasePileup()) {
                    if (!CoverageUtils.elementWithinQualRange(read, minBaseQ, maxBaseQ)) continue;
                    countPileup.add(read);
                }
                break;
            }
            case COUNT_FRAGMENTS: {
                throw new UnsupportedOperationException("Fragment based counting is currently unsupported");
            }
            case COUNT_FRAGMENTS_REQUIRE_SAME_BASE: {
                throw new UnsupportedOperationException("Fragment based counting is currently unsupported");
            }
            default: {
                throw new UserException("Must use valid CountPileupType");
            }
        }
        for (PileupElement e : countPileup) {
            SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(e.getRead(), header);
            Utils.nonNull(readGroup, () -> String.format("Read %s was missing read group information", e.getRead()));
            String uniqueReadGroupId = readGroup.getSample() + "_" + readGroup.getReadGroupId() + "_" + readGroup.getLibrary() + "_" + readGroup.getPlatformUnit();
            int[] counts = (int[])countsByRGName.get(uniqueReadGroupId);
            if (counts == null) {
                counts = new int[6];
                countsByRGName.put(uniqueReadGroupId, counts);
                RGByName.put(uniqueReadGroupId, readGroup);
            }
            CoverageUtils.updateCounts(counts, e);
        }
        for (String readGroupId : RGByName.keySet()) {
            countsByRG.put((SAMReadGroupRecord)RGByName.get(readGroupId), (int[])countsByRGName.get(readGroupId));
        }
        return countsByRG;
    }

    private static boolean elementWithinQualRange(PileupElement e, byte minBaseQ, byte maxBaseQ) {
        return e.getQual() >= minBaseQ && e.getQual() <= maxBaseQ || e.isDeletion();
    }

    private static void updateCounts(int[] counts, PileupElement e) {
        if (e.isDeletion()) {
            int n = BaseUtils.Base.D.ordinal();
            counts[n] = counts[n] + 1;
        } else if (BaseUtils.basesAreEqual(BaseUtils.Base.N.base, e.getBase())) {
            int n = BaseUtils.Base.N.ordinal();
            counts[n] = counts[n] + 1;
        } else {
            try {
                int n = BaseUtils.simpleBaseToBaseIndex(e.getBase());
                counts[n] = counts[n] + 1;
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                throw new UserException("Expected a simple base, but actually received" + (char)e.getBase());
            }
        }
    }

    public static int[] calculateCoverageHistogramBinEndpoints(int lower, int upper, int nBins) {
        if (nBins > upper - lower || lower < 1) {
            throw new UserException.BadInput("the start must be at least 1 and the number of bins may not exceed stop - start");
        }
        int[] binLeftEndpoints = new int[nBins + 1];
        binLeftEndpoints[0] = lower;
        int length = upper - lower;
        double scale = Math.log10(length) / (double)nBins;
        for (int b = 1; b < nBins; ++b) {
            int leftEnd;
            for (leftEnd = lower + (int)Math.floor(Math.pow(10.0, ((double)b - 1.0) * scale)); leftEnd <= binLeftEndpoints[b - 1]; ++leftEnd) {
            }
            binLeftEndpoints[b] = leftEnd;
        }
        binLeftEndpoints[binLeftEndpoints.length - 1] = upper;
        return binLeftEndpoints;
    }

    public static void updateTargetTable(int[][] table, DepthOfCoverageStats stats) {
        int[] cutoffs = stats.getEndpoints();
        int[] countsOfMediansAboveCutoffs = new int[cutoffs.length + 1];
        for (String s : stats.getAllSamples()) {
            int medianBin = CoverageUtils.getQuantile(stats.getHistograms().get(s), 0.5);
            int i = 0;
            while (i <= medianBin) {
                int n = i++;
                countsOfMediansAboveCutoffs[n] = countsOfMediansAboveCutoffs[n] + 1;
            }
        }
        for (int medianBin = 0; medianBin < countsOfMediansAboveCutoffs.length; ++medianBin) {
            while (countsOfMediansAboveCutoffs[medianBin] > 0) {
                int[] nArray = table[countsOfMediansAboveCutoffs[medianBin] - 1];
                int n = medianBin;
                nArray[n] = nArray[n] + 1;
                int n2 = medianBin;
                countsOfMediansAboveCutoffs[n2] = countsOfMediansAboveCutoffs[n2] - 1;
            }
        }
    }

    public static double getPctBasesAbove(long[] histogram, int bin) {
        long below = 0L;
        long above = 0L;
        for (int index = 0; index < histogram.length; ++index) {
            if (index < bin) {
                below += histogram[index];
                continue;
            }
            above += histogram[index];
        }
        return 100.0 * (double)above / (double)(above + below);
    }

    public static int getQuantile(long[] histogram, double prop) {
        Utils.validate(prop >= 0.0 && prop <= 1.0, "Quantile proportion must fall between 0.0 and 1.0 inclusive");
        long total = MathUtils.sum(histogram);
        long counts = 0L;
        int bin = -1;
        while ((double)counts < prop * (double)total) {
            counts += histogram[bin + 1];
            ++bin;
        }
        return bin == -1 ? 0 : bin;
    }

    public static enum CountPileupType {
        COUNT_READS,
        COUNT_FRAGMENTS,
        COUNT_FRAGMENTS_REQUIRE_SAME_BASE;

    }
}

