/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.coverage;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.LocusWalkerByInterval;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.coverage.CoverageOutputWriter;
import org.broadinstitute.hellbender.tools.walkers.coverage.CoverageUtils;
import org.broadinstitute.hellbender.tools.walkers.coverage.DepthOfCoveragePartitionedDataStore;
import org.broadinstitute.hellbender.tools.walkers.coverage.DepthOfCoverageStats;
import org.broadinstitute.hellbender.tools.walkers.coverage.DoCOutputType;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.codecs.refseq.RefSeqFeature;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@CommandLineProgramProperties(summary="Generate coverage summary information for reads data", oneLineSummary="Generate coverage summary information for reads data", programGroup=CoverageAnalysisProgramGroup.class)
@BetaFeature
@DocumentedFeature
public class DepthOfCoverage
extends LocusWalkerByInterval {
    private CoverageOutputWriter writer;
    private Map<Locatable, DepthOfCoveragePartitionedDataStore> activeCoveragePartitioner = new HashMap<Locatable, DepthOfCoveragePartitionedDataStore>();
    private Map<DoCOutputType.Partition, int[][]> perIntervalStatisticsAggregationByPartitioning = new HashMap<DoCOutputType.Partition, int[][]>();
    private Map<DoCOutputType.Partition, int[][]> perGeneStatisticsAggregationByPartitioning = new HashMap<DoCOutputType.Partition, int[][]>();
    private DepthOfCoveragePartitionedDataStore coverageTotalsForEntireTraversal;
    private Map<DoCOutputType.Partition, List<String>> globalIdentifierMap;
    @Argument(fullName="output", shortName="O", doc="Base file location to which to write coverage summary information, must be a path to a file")
    private String baseFileName = null;
    @Argument(fullName="min-base-quality", doc="Minimum quality of bases to count towards depth", optional=true, minValue=0.0, maxValue=127.0)
    private byte minBaseQuality = 0;
    @Argument(fullName="max-base-quality", doc="Maximum quality of bases to count towards depth", optional=true, minValue=0.0, maxValue=127.0)
    private byte maxBaseQuality = (byte)127;
    @Argument(fullName="count-type", doc="How should overlapping reads from the same fragment be handled? NOTE: currently only COUNT_READS is supported", optional=true)
    private CoverageUtils.CountPileupType countType = CoverageUtils.CountPileupType.COUNT_READS;
    @Argument(fullName="print-base-counts", doc="Add base counts to per-locus output", optional=true)
    private boolean printBaseCounts = false;
    @Argument(fullName="omit-locus-table", doc="Do not calculate per-sample per-depth counts of loci", optional=true)
    private boolean omitLocusTable = false;
    @Argument(fullName="omit-interval-statistics", doc="Do not calculate per-interval statistics", optional=true, mutex={"calculate-coverage-over-genes"})
    private boolean omitIntervals = false;
    @Argument(fullName="omit-depth-output-at-each-base", doc="Do not output depth of coverage at each base", optional=true)
    private boolean omitDepthOutput = false;
    @Argument(fullName="omit-per-sample-statistics", doc="Do not output the summary files per-sample", optional=true)
    private boolean omitSampleSummary = false;
    @Argument(fullName="calculate-coverage-over-genes", shortName="gene-list", doc="Calculate coverage statistics over this list of genes", optional=true, mutex={"omit-interval-statistics"})
    private List<String> refSeqGeneListFiles = new ArrayList<String>();
    @Argument(fullName="omit-genes-not-entirely-covered-by-traversal", doc="Do not output gene summary if it was not completely covered by traversal intervals", optional=true)
    private boolean omitPartiallyCoveredGenes = false;
    @Argument(fullName="output-format", doc="The format of the output file", optional=true)
    CoverageOutputWriter.DEPTH_OF_COVERAGE_OUTPUT_FORMAT outputFormat = CoverageOutputWriter.DEPTH_OF_COVERAGE_OUTPUT_FORMAT.CSV;
    @Advanced
    @Argument(fullName="include-ref-n-sites", doc="Include sites where the reference is N", optional=true)
    private boolean includeRefNBases = false;
    @Advanced
    @Argument(fullName="start", doc="Starting (left endpoint) for granular binning", optional=true, minValue=0.0)
    private int start = 1;
    @Advanced
    @Argument(fullName="stop", doc="Ending (right endpoint) for granular binning", optional=true, minValue=1.0)
    private int stop = 500;
    @Advanced
    @Argument(fullName="nBins", doc="Number of bins to use for granular binning", optional=true, minValue=0.0, minRecommendedValue=1.0)
    private int nBins = 499;
    @Argument(fullName="partition-type", shortName="pt", doc="Partition type for depth of coverage", optional=true)
    private EnumSet<DoCOutputType.Partition> partitionTypes = EnumSet.of(DoCOutputType.Partition.sample);
    @Advanced
    @Argument(fullName="include-deletions", doc="Include information on deletions alongside other bases in output table counts", optional=true)
    private boolean includeDeletions = false;
    @Advanced
    @Argument(fullName="ignore-deletion-sites", doc="Ignore sites consisting only of deletions", optional=true)
    boolean ignoreDeletionSites = false;
    @Advanced
    @Argument(fullName="summary-coverage-threshold", doc="Coverage threshold (in percent) for summarizing statistics", optional=true)
    private List<Integer> coverageThresholds = new ArrayList<Integer>(Collections.singleton(15));

    @Override
    public boolean includeNs() {
        return true;
    }

    @Override
    public boolean emitEmptyLoci() {
        return true;
    }

    @Override
    public boolean includeDeletions() {
        return this.includeDeletions && !this.ignoreDeletionSites;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> defaultFilters = new ArrayList<ReadFilter>(2);
        defaultFilters.add(new WellformedReadFilter());
        defaultFilters.add(new ReadFilterLibrary.NotDuplicateReadFilter());
        defaultFilters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        defaultFilters.add(new ReadFilterLibrary.MappedReadFilter());
        return defaultFilters;
    }

    @Override
    public void onTraversalStart() {
        try {
            this.writer = new CoverageOutputWriter(this.outputFormat, this.partitionTypes, this.baseFileName, !this.refSeqGeneListFiles.isEmpty(), this.printBaseCounts, this.omitDepthOutput, this.omitIntervals, this.omitSampleSummary, this.omitLocusTable, this.coverageThresholds);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Couldn't create output file, encountered exception: " + e.getMessage(), (Exception)e);
        }
        this.globalIdentifierMap = this.makeGlobalIdentifierMap(this.partitionTypes);
        this.writer.writeCoverageOutputHeaders(this.globalIdentifierMap);
        ReadUtils.getSamplesFromHeader(this.getHeaderForReads());
        this.coverageTotalsForEntireTraversal = this.createCoveragePartitioner();
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext, Set<Locatable> activeIntervals) {
        if (this.includeRefNBases || this.hasReference() && BaseUtils.isRegularBase(referenceContext.getBase())) {
            Map<DoCOutputType.Partition, Map<String, int[]>> countsByPartition = CoverageUtils.getBaseCountsByPartition(alignmentContext, this.minBaseQuality, this.maxBaseQuality, this.countType, this.partitionTypes, this.getHeaderForReads());
            if (!this.omitDepthOutput) {
                this.writer.writePerLocusDepthSummary(referenceContext.getInterval(), countsByPartition, this.globalIdentifierMap, this.includeDeletions);
            }
            this.coverageTotalsForEntireTraversal.addLocusData(countsByPartition);
            for (Locatable loc : this.activeCoveragePartitioner.keySet()) {
                if (!loc.contains((Locatable)alignmentContext)) continue;
                this.activeCoveragePartitioner.get(loc).addLocusData(countsByPartition);
            }
        }
    }

    @Override
    public void onIntervalStart(Locatable activeInterval) {
        DepthOfCoveragePartitionedDataStore partitioner = this.createCoveragePartitioner();
        this.activeCoveragePartitioner.put(activeInterval, partitioner);
    }

    @Override
    public void onIntervalEnd(Locatable activeInterval) {
        DepthOfCoveragePartitionedDataStore partitionerToRemove = this.activeCoveragePartitioner.remove(activeInterval);
        if (activeInterval instanceof SimpleInterval) {
            if (!this.omitIntervals) {
                for (DoCOutputType.Partition p : this.partitionTypes) {
                    DepthOfCoverageStats coverageByAggregationPartitionType = partitionerToRemove.getCoverageByAggregationType(p);
                    this.writer.writePerIntervalDepthInformation(p, (SimpleInterval)activeInterval, coverageByAggregationPartitionType, this.globalIdentifierMap.get((Object)p));
                    if (!this.perIntervalStatisticsAggregationByPartitioning.containsKey((Object)p)) {
                        this.perIntervalStatisticsAggregationByPartitioning.put(p, new int[coverageByAggregationPartitionType.getHistograms().size()][coverageByAggregationPartitionType.getEndpoints().length + 1]);
                    }
                    CoverageUtils.updateTargetTable(this.perIntervalStatisticsAggregationByPartitioning.get((Object)p), coverageByAggregationPartitionType);
                }
            }
        } else if (activeInterval instanceof RefSeqFeature) {
            DepthOfCoverageStats coverageBySample = partitionerToRemove.getCoverageByAggregationType(DoCOutputType.Partition.sample);
            if (!this.omitPartiallyCoveredGenes || (long)((RefSeqFeature)activeInterval).getTotalExonLength() <= coverageBySample.getNumberOfLociCovered()) {
                this.writer.writePerGeneDepthInformation((RefSeqFeature)activeInterval, coverageBySample, this.globalIdentifierMap.get((Object)DoCOutputType.Partition.sample));
                DepthOfCoverageStats coverageByAggregationPartitionType = partitionerToRemove.getCoverageByAggregationType(DoCOutputType.Partition.sample);
                if (!this.perGeneStatisticsAggregationByPartitioning.containsKey((Object)DoCOutputType.Partition.sample)) {
                    this.perGeneStatisticsAggregationByPartitioning.put(DoCOutputType.Partition.sample, new int[coverageByAggregationPartitionType.getHistograms().size()][coverageByAggregationPartitionType.getEndpoints().length + 1]);
                }
                CoverageUtils.updateTargetTable(this.perGeneStatisticsAggregationByPartitioning.get((Object)DoCOutputType.Partition.sample), coverageByAggregationPartitionType);
            }
        } else {
            throw new GATKException("Unrecognized Locatable object supplied for traversal, only RefSeqFeature and SimpleInterval are supported: " + activeInterval.toString());
        }
    }

    @Override
    public Object onTraversalSuccess() {
        for (DoCOutputType.Partition partition : this.perIntervalStatisticsAggregationByPartitioning.keySet()) {
            this.writer.writeOutputIntervalStatistics(partition, this.perIntervalStatisticsAggregationByPartitioning.get((Object)partition), CoverageUtils.calculateCoverageHistogramBinEndpoints(this.start, this.stop, this.nBins));
        }
        if (!this.refSeqGeneListFiles.isEmpty()) {
            for (DoCOutputType.Partition partition : this.perGeneStatisticsAggregationByPartitioning.keySet()) {
                this.writer.writeOutputGeneStatistics(this.perGeneStatisticsAggregationByPartitioning.get((Object)partition), CoverageUtils.calculateCoverageHistogramBinEndpoints(this.start, this.stop, this.nBins));
            }
        }
        if (!this.omitSampleSummary) {
            this.logger.info("Outputting summary info");
            for (DoCOutputType.Partition type : this.partitionTypes) {
                this.writer.writeCumulativeOutputSummaryFiles(this.coverageTotalsForEntireTraversal, type, this.globalIdentifierMap.get((Object)type));
            }
        }
        if (!this.omitLocusTable) {
            this.logger.info("Outputting locus summary");
            for (DoCOutputType.Partition type : this.partitionTypes) {
                this.writer.writePerLocusCumulativeCoverageMetrics(this.coverageTotalsForEntireTraversal, type, this.globalIdentifierMap.get((Object)type));
            }
        }
        this.writer.close();
        return "success";
    }

    private DepthOfCoveragePartitionedDataStore createCoveragePartitioner() {
        return new DepthOfCoveragePartitionedDataStore(this.partitionTypes, this.start, this.stop, this.nBins, this.includeDeletions, this.omitLocusTable, this.globalIdentifierMap);
    }

    private Map<DoCOutputType.Partition, List<String>> makeGlobalIdentifierMap(Collection<DoCOutputType.Partition> types) {
        LinkedHashMap<DoCOutputType.Partition, List<String>> partitions = new LinkedHashMap<DoCOutputType.Partition, List<String>>();
        for (DoCOutputType.Partition t : types) {
            ArrayList<String> samplesForType = new ArrayList<String>(this.getSamplesByPartitionFromReadHeader(t));
            samplesForType.sort(String::compareTo);
            partitions.put(t, Collections.unmodifiableList(samplesForType));
        }
        return Collections.unmodifiableMap(partitions);
    }

    private HashSet<String> getSamplesByPartitionFromReadHeader(DoCOutputType.Partition type) {
        HashSet<String> partition = new HashSet<String>();
        SAMFileHeader header = this.getHeaderForReads();
        if (type == DoCOutputType.Partition.sample) {
            partition.addAll(ReadUtils.getSamplesFromHeader(header));
        } else {
            for (SAMReadGroupRecord rg : header.getReadGroups()) {
                partition.add(CoverageUtils.getTypeID(rg, type));
            }
        }
        return partition;
    }

    @Override
    public List<Locatable> getIntervalObjectsToQueryOver() {
        List<SimpleInterval> userProvidedIntervals = this.intervalArgumentCollection.getIntervalsWithoutMerging(this.getBestAvailableSequenceDictionary());
        ArrayList<Locatable> refSeqInputs = new ArrayList<Locatable>(userProvidedIntervals);
        for (String input : this.refSeqGeneListFiles) {
            FeatureDataSource refSeqReader = new FeatureDataSource(input);
            for (RefSeqFeature geneRecord : refSeqReader) {
                refSeqInputs.add(geneRecord);
            }
            refSeqReader.close();
        }
        return refSeqInputs;
    }
}

