/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.coverage;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.broadinstitute.hellbender.tools.walkers.coverage.CoverageUtils;
import org.broadinstitute.hellbender.tools.walkers.coverage.DepthOfCoverageStats;
import org.broadinstitute.hellbender.tools.walkers.coverage.DoCOutputType;

public class DepthOfCoveragePartitionedDataStore {
    private Map<DoCOutputType.Partition, DepthOfCoverageStats> coverageProfiles = new TreeMap<DoCOutputType.Partition, DepthOfCoverageStats>();

    public DepthOfCoveragePartitionedDataStore(Collection<DoCOutputType.Partition> typesToUse, int start, int stop, int nBins, boolean includeDeletions, boolean omitLocusTable, Map<DoCOutputType.Partition, List<String>> globalIdentifierMap) {
        for (DoCOutputType.Partition type : typesToUse) {
            this.coverageProfiles.put(type, new DepthOfCoverageStats(CoverageUtils.calculateCoverageHistogramBinEndpoints(start, stop, nBins), includeDeletions, omitLocusTable));
        }
        this.initializeStats(omitLocusTable, globalIdentifierMap);
    }

    public void initializeStats(boolean omitLocusTable, Map<DoCOutputType.Partition, List<String>> globalIdentifierMap) {
        for (DoCOutputType.Partition t : this.coverageProfiles.keySet()) {
            for (String sample : globalIdentifierMap.get((Object)t)) {
                this.coverageProfiles.get((Object)t).initializeSample(sample);
            }
            if (omitLocusTable) continue;
            this.coverageProfiles.get((Object)t).initializeLocusCounts();
        }
    }

    public void addLocusData(Map<DoCOutputType.Partition, Map<String, int[]>> countsByIdentifierByType) {
        for (DoCOutputType.Partition t : this.coverageProfiles.keySet()) {
            this.coverageProfiles.get((Object)t).update(countsByIdentifierByType.get((Object)t));
        }
    }

    public DepthOfCoverageStats getCoverageByAggregationType(DoCOutputType.Partition t) {
        return this.coverageProfiles.get((Object)t);
    }
}

