/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.fasta;

import com.google.common.annotations.VisibleForTesting;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalTextOutputArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceWalker;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(oneLineSummary="Count the numbers of each base in a reference file", summary="Count the number of times each individual base occurs in a reference file and print to standard output (and optionally to a file).", programGroup=ReferenceProgramGroup.class)
public class CountBasesInReference
extends ReferenceWalker {
    @ArgumentCollection
    public final OptionalTextOutputArgumentCollection out = new OptionalTextOutputArgumentCollection();
    @VisibleForTesting
    final long[] baseCounts = new long[256];

    @Override
    public void apply(ReferenceContext referenceContext, ReadsContext read, FeatureContext featureContext) {
        byte by = referenceContext.getBase();
        this.baseCounts[by] = this.baseCounts[by] + 1L;
    }

    @Override
    public Object onTraversalSuccess() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.baseCounts.length; ++i) {
            long count = this.baseCounts[i];
            if (count <= 0L) continue;
            sb.append((char)i).append(" : ").append(count).append("\n");
        }
        this.out.print(sb);
        System.out.print(sb.toString());
        return 0;
    }
}

