/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.fasta;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.fasta.FastaReferenceMaker;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Create an alternative fasta reference by inserting variants from a vcf into an existing reference sequence.", oneLineSummary="Create an alternative reference by combining a fasta with a vcf.", programGroup=ReferenceProgramGroup.class)
public class FastaAlternateReferenceMaker
extends FastaReferenceMaker {
    private static final byte[] NO_BASES = new byte[0];
    private static final byte[] N_BYTES = new byte[]{78};
    private static final byte[] n_BYTES = new byte[]{110};
    private static final byte[] A_BYTES = new byte[]{65};
    private static final byte[] a_BYTES = new byte[]{97};
    private static final byte[] G_BYTES = new byte[]{71};
    private static final byte[] g_BYTES = new byte[]{103};
    private static final byte[] C_BYTES = new byte[]{67};
    private static final byte[] c_BYTES = new byte[]{99};
    private static final byte[] T_BYTES = new byte[]{84};
    private static final byte[] t_BYTES = new byte[]{116};
    private static final String EMPTY_BASE = " ";
    @Argument(fullName="variant", shortName="V", doc="A source of variants to merge with the reference sequence.")
    protected FeatureInput<VariantContext> variants;
    public static final String SNP_MASK_LONG_NAME = "snp-mask";
    @Argument(fullName="snp-mask", doc="SNP mask VCF file", optional=true)
    protected FeatureInput<VariantContext> snpmask;
    public static final String SNP_MASK_PRIORITY_LONG_NAME = "snp-mask-priority";
    @Argument(fullName="snp-mask-priority", doc="Give the snp mask priority over the input VCF.", optional=true)
    protected boolean snpmaskPriority = false;
    public static final String USE_IUPAC_SAMPLE_LONG_NAME = "use-iupac-sample";
    @Argument(fullName="use-iupac-sample", doc="If specified, heterozygous SNP sites will be output using IUPAC ambiguity codes given the genotypes for this sample", optional=true)
    private String iupacSample = null;
    private int deletionBasesRemaining = 0;

    @Override
    public void onTraversalStart() {
        VCFHeader variantHeader;
        ArrayList samples;
        super.onTraversalStart();
        if (this.snpmaskPriority && this.snpmask == null) {
            throw new CommandLineException("Cannot specify --snp-mask-priority without  --snp-mask");
        }
        if (!(this.iupacSample == null || (samples = (variantHeader = (VCFHeader)this.getHeaderForFeatures(this.variants)).getSampleNamesInOrder()) != null && samples.contains(this.iupacSample))) {
            throw new UserException.BadInput("the IUPAC sample specified is not present in the provided VCF file");
        }
    }

    @Override
    public void apply(ReferenceContext ref, ReadsContext reads, FeatureContext features) {
        byte[] bases = this.handlePosition(ref.getInterval(), ref.getBase(), features);
        SimpleInterval interval = ref.getInterval();
        if (bases.length == 0) {
            this.advancePosition(interval);
        } else {
            for (byte base : bases) {
                this.addToReference(interval, base);
            }
        }
    }

    private byte[] handlePosition(SimpleInterval interval, byte base, FeatureContext features) {
        if (this.deletionBasesRemaining > 0) {
            --this.deletionBasesRemaining;
            return NO_BASES;
        }
        if (this.snpmaskPriority && this.isMasked(features)) {
            return N_BYTES;
        }
        for (VariantContext vc : features.getValues(this.variants)) {
            if (vc.isFiltered() || vc.getStart() != interval.getStart()) continue;
            if (vc.isSimpleDeletion()) {
                this.deletionBasesRemaining = vc.getReference().length() - 1;
                return this.baseToByteArray(base);
            }
            if (!vc.isSimpleInsertion() && !vc.isSNP()) continue;
            Optional<Allele> optionalAllele = this.getFirstConcreteAltAllele(vc.getAlternateAlleles());
            Allele allele = optionalAllele.orElseGet(() -> Allele.create((String)EMPTY_BASE, (boolean)false));
            if (vc.isSimpleInsertion()) {
                return allele.getBases();
            }
            String iupacBase = this.iupacSample != null ? this.getIUPACBase(vc.getGenotype(this.iupacSample)) : allele.toString();
            return iupacBase.getBytes();
        }
        if (!this.snpmaskPriority && this.isMasked(features)) {
            return N_BYTES;
        }
        return this.baseToByteArray(base);
    }

    private byte[] baseToByteArray(byte base) {
        switch (base) {
            case 65: {
                return A_BYTES;
            }
            case 97: {
                return a_BYTES;
            }
            case 67: {
                return C_BYTES;
            }
            case 99: {
                return c_BYTES;
            }
            case 71: {
                return G_BYTES;
            }
            case 103: {
                return g_BYTES;
            }
            case 84: {
                return T_BYTES;
            }
            case 116: {
                return t_BYTES;
            }
            case 78: {
                return N_BYTES;
            }
            case 110: {
                return n_BYTES;
            }
        }
        return new byte[]{base};
    }

    private Optional<Allele> getFirstConcreteAltAllele(List<Allele> altAlleles) {
        return altAlleles.stream().filter(allele -> !allele.isSymbolic()).filter(allele -> !GATKVCFConstants.isSpanningDeletion(allele)).filter(Allele::isCalled).findFirst();
    }

    private boolean isMasked(FeatureContext features) {
        return features.getValues(this.snpmask).stream().anyMatch(VariantContext::isSNP);
    }

    private String getIUPACBase(Genotype genotype) {
        Utils.nonNull(genotype, () -> "The genotype is null for sample " + this.iupacSample);
        if (genotype.getAlleles().contains(Allele.SPAN_DEL)) {
            if (genotype.isHomVar()) {
                return EMPTY_BASE;
            }
            return genotype.getAllele(0).equals((Object)Allele.SPAN_DEL) ? genotype.getAllele(1).getBaseString() : genotype.getAllele(0).getBaseString();
        }
        if (!genotype.isHet()) {
            return genotype.getAllele(0).getBaseString();
        }
        byte allele1 = genotype.getAllele(0).getBases()[0];
        byte allele2 = genotype.getAllele(1).getBases()[0];
        return new String(new byte[]{BaseUtils.basesToIUPAC(allele1, allele2)});
    }
}

