/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.fasta;

import com.google.common.primitives.Bytes;
import htsjdk.samtools.reference.FastaReferenceWriter;
import htsjdk.samtools.reference.FastaReferenceWriterBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Create snippets of a fasta file by subsetting to an interval list", oneLineSummary="Create snippets of a fasta file", programGroup=ReferenceProgramGroup.class)
public class FastaReferenceMaker
extends ReferenceWalker {
    @Argument(fullName="output", shortName="O", doc="Path to write the output fasta to")
    protected String output;
    public static final String LINE_WIDTH_LONG_NAME = "line-width";
    @Argument(fullName="line-width", doc="Maximum length of sequence to write per line", optional=true)
    public int basesPerLine = 60;
    protected FastaReferenceWriter writer;
    private int contigCount = 0;
    private int currentSequenceStartPosition = 0;
    private SimpleInterval lastPosition = null;
    private ByteArrayList sequence = new ByteArrayList(10000);

    @Override
    public void onTraversalStart() {
        Path path = IOUtils.getPath(this.output);
        try {
            this.writer = new FastaReferenceWriterBuilder().setFastaFile(path).setBasesPerLine(this.basesPerLine).build();
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Couldn't create " + this.output + ", encountered exception: " + e.getMessage(), (Exception)e);
        }
    }

    @Override
    public void apply(ReferenceContext referenceContext, ReadsContext read, FeatureContext featureContext) {
        this.addToReference(referenceContext.getInterval(), referenceContext.getBase());
    }

    protected void addToReference(SimpleInterval interval, byte base) {
        this.advancePosition(interval);
        this.sequence.add(base);
    }

    protected void advancePosition(SimpleInterval interval) {
        if (this.lastPosition == null) {
            this.initializeNewSequence(interval);
        } else if (!this.lastPosition.withinDistanceOf(interval, 1)) {
            this.finalizeSequence();
            this.initializeNewSequence(interval);
        }
        this.lastPosition = interval;
    }

    private void finalizeSequence() {
        String description = this.lastPosition.getContig() + ":" + this.currentSequenceStartPosition + "-" + this.lastPosition.getEnd();
        try {
            this.writer.appendSequence(String.valueOf(this.contigCount), description, this.basesPerLine, Bytes.toArray((Collection)this.sequence));
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Failed while writing " + this.output + ".", (Exception)e);
        }
    }

    private void initializeNewSequence(SimpleInterval interval) {
        this.lastPosition = interval;
        ++this.contigCount;
        this.currentSequenceStartPosition = this.lastPosition.getStart();
        this.sequence.clear();
    }

    @Override
    public Object onTraversalSuccess() {
        this.finalizeSequence();
        return null;
    }

    @Override
    public void closeTool() {
        super.closeTool();
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException e) {
            throw new UserException("Failed to write fasta due to " + e.getMessage(), e);
        }
    }
}

