/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.filters;

import com.google.common.collect.Sets;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.JexlMissingValueTreatment;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jexl2.JexlEngine;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.AlleleFilterUtils;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Filter variant calls based on INFO and/or FORMAT annotations.", oneLineSummary="Filter variant calls based on INFO and/or FORMAT annotations", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
public final class VariantFiltration
extends VariantWalker {
    public static final String FILTER_EXPRESSION_LONG_NAME = "filter-expression";
    public static final String FILTER_NAME_LONG_NAME = "filter-name";
    public static final String GENOTYPE_FILTER_EXPRESSION_LONG_NAME = "genotype-filter-expression";
    public static final String GENOTYPE_FILTER_NAME_LONG_NAME = "genotype-filter-name";
    public static final String CLUSTER_SIZE_LONG_NAME = "cluster-size";
    public static final String CLUSTER_WINDOW_SIZE_LONG_NAME = "cluster-window-size";
    public static final String MASK_EXTENSION_LONG_NAME = "mask-extension";
    public static final String MASK_NAME_LONG_NAME = "mask-name";
    public static final String FILTER_NOT_IN_MASK_LONG_NAME = "filter-not-in-mask";
    public static final String MISSING_VAL_LONG_NAME = "missing-values-evaluate-as-failing";
    public static final String INVERT_LONG_NAME = "invert-filter-expression";
    public static final String INVERT_GT_LONG_NAME = "invert-genotype-filter-expression";
    public static final String NO_CALL_GTS_LONG_NAME = "set-filtered-genotype-to-no-call";
    public static final String ALLELE_SPECIFIC_LONG_NAME = "apply-allele-specific-filters";
    private static final String FILTER_DELIMITER = ";";
    @Argument(fullName="mask", shortName="mask", doc="Input mask", optional=true)
    public FeatureInput<Feature> mask;
    @Argument(doc="File to which variants should be written", fullName="output", shortName="O", optional=false)
    public GATKPath out = null;
    @Argument(fullName="filter-expression", shortName="filter", doc="One or more expressions used with INFO fields to filter", optional=true)
    public List<String> filterExpressions = new ArrayList<String>();
    @Argument(fullName="filter-name", doc="Names to use for the list of filters", optional=true)
    public List<String> filterNames = new ArrayList<String>();
    @Argument(fullName="genotype-filter-expression", shortName="G-filter", doc="One or more expressions used with FORMAT (sample/genotype-level) fields to filter (see documentation guide for more info)", optional=true)
    public List<String> genotypeFilterExpressions = new ArrayList<String>();
    @Argument(fullName="genotype-filter-name", shortName="G-filter-name", doc="Names to use for the list of sample/genotype filters (must be a 1-to-1 mapping); this name is put in the FILTER field for variants that get filtered", optional=true)
    public List<String> genotypeFilterNames = new ArrayList<String>();
    @Argument(fullName="cluster-size", shortName="cluster", doc="The number of SNPs which make up a cluster. Must be at least 2", optional=true)
    public Integer clusterSize = 3;
    @Argument(fullName="cluster-window-size", shortName="window", doc="The window size (in bases) in which to evaluate clustered SNPs", optional=true)
    public Integer clusterWindow = 0;
    @Argument(fullName="mask-extension", doc="How many bases beyond records from a provided 'mask' should variants be filtered", optional=true)
    public Integer maskExtension = 0;
    @Argument(fullName="mask-name", doc="The text to put in the FILTER field if a 'mask' is provided and overlaps with a variant call", optional=true)
    public String maskName = "Mask";
    @Argument(fullName="filter-not-in-mask", doc="Filter records NOT in given input mask.", optional=true)
    public boolean filterRecordsNotInMask = false;
    @Argument(fullName="missing-values-evaluate-as-failing", doc="When evaluating the JEXL expressions, missing values should be considered failing the expression", optional=true)
    public Boolean failMissingValues = false;
    @Argument(fullName="invalidate-previous-filters", doc="Remove previous filters applied to the VCF", optional=true)
    boolean invalidatePreviousFilters = false;
    @Argument(fullName="invert-filter-expression", shortName="invfilter", doc="Invert the selection criteria for --filter-expression", optional=true)
    public boolean invertFilterExpression = false;
    @Argument(fullName="invert-genotype-filter-expression", shortName="invG-filter", doc="Invert the selection criteria for --genotype-filter-expression", optional=true)
    public boolean invertGenotypeFilterExpression = false;
    @Argument(fullName="set-filtered-genotype-to-no-call", optional=true, doc="Set filtered genotypes to no-call")
    public boolean setFilteredGenotypesToNocall = false;
    @Argument(fullName="apply-allele-specific-filters", optional=true, doc="Set mask at the allele level. This option is not compatible with clustering.")
    public boolean applyForAllele = false;
    private List<VariantContextUtils.JexlVCMatchExp> filterExps;
    private List<VariantContextUtils.JexlVCMatchExp> genotypeFilterExps;
    private JexlMissingValueTreatment howToTreatMissingValues;
    public static final String CLUSTERED_SNP_FILTER_NAME = "SnpCluster";
    private VariantContextWriter writer;
    private final List<Allele> diploidNoCallAlleles = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);

    private static boolean invertLogic(boolean logic, boolean invert) {
        return invert ? !logic : logic;
    }

    private String possiblyInvertFilterExpression(String description) {
        return this.invertFilterExpression ? "Inverse of: " + description : description;
    }

    private void initializeVcfWriter() {
        this.writer = this.createVCFWriter(this.out);
        LinkedHashSet<VCFHeaderLine> hInfo = new LinkedHashSet<VCFHeaderLine>();
        hInfo.addAll(this.getHeaderForVariants().getMetaDataInInputOrder());
        if (this.applyForAllele) {
            hInfo.add((VCFHeaderLine)new VCFInfoHeaderLine("AS_FilterStatus", VCFHeaderLineCount.A, VCFHeaderLineType.String, "Filter status for each allele, as assessed by ApplyVQSR. Note that the VCF filter field will reflect the most lenient/sensitive status across all alleles."));
        }
        if (this.setFilteredGenotypesToNocall) {
            GATKVariantContextUtils.addChromosomeCountsToHeader(hInfo);
        }
        if (this.clusterWindow > 0) {
            hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(CLUSTERED_SNP_FILTER_NAME, "SNPs found in clusters"));
        }
        if (!this.genotypeFilterExps.isEmpty()) {
            hInfo.add((VCFHeaderLine)VCFStandardHeaderLines.getFormatLine((String)"FT"));
        }
        try {
            for (VariantContextUtils.JexlVCMatchExp exp : this.filterExps) {
                hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(exp.name, this.possiblyInvertFilterExpression(exp.exp.toString())));
            }
            for (VariantContextUtils.JexlVCMatchExp exp : this.genotypeFilterExps) {
                hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(exp.name, this.possiblyInvertFilterExpression(exp.exp.toString())));
            }
            if (this.mask != null) {
                if (this.filterRecordsNotInMask) {
                    hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(this.maskName, "Doesn't overlap a user-input mask"));
                } else {
                    hInfo.add((VCFHeaderLine)new VCFFilterHeaderLine(this.maskName, "Overlaps a user-input mask"));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new UserException.BadInput(e.getMessage());
        }
        hInfo.addAll(this.getDefaultToolVCFHeaderLines());
        this.writer.writeHeader(new VCFHeader(hInfo, this.getHeaderForVariants().getGenotypeSamples()));
    }

    @Override
    public void onTraversalStart() {
        if (this.clusterSize <= 1) {
            throw new CommandLineException.BadArgumentValue(CLUSTER_SIZE_LONG_NAME, "values lower than 2 are not allowed");
        }
        if (this.maskExtension < 0) {
            throw new CommandLineException.BadArgumentValue(MASK_EXTENSION_LONG_NAME, "negative values are not allowed");
        }
        if (this.filterRecordsNotInMask && this.mask == null) {
            throw new CommandLineException.BadArgumentValue(FILTER_NOT_IN_MASK_LONG_NAME, "argument not allowed if mask argument is not provided");
        }
        this.filterExps = VariantContextUtils.initializeMatchExps(this.filterNames, this.filterExpressions);
        this.genotypeFilterExps = VariantContextUtils.initializeMatchExps(this.genotypeFilterNames, this.genotypeFilterExpressions);
        this.howToTreatMissingValues = this.failMissingValues != false ? JexlMissingValueTreatment.TREAT_AS_MATCH : JexlMissingValueTreatment.TREAT_AS_MISMATCH;
        ((JexlEngine)VariantContextUtils.engine.get()).setSilent(true);
        this.initializeVcfWriter();
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        if (this.applyForAllele) {
            List filtered = this.splitMultiAllelics(variant).stream().map(vc -> this.filter((VariantContext)vc, new FeatureContext(featureContext, new SimpleInterval(vc.getContig(), vc.getStart(), vc.getEnd())))).collect(Collectors.toList());
            List<Set<String>> alleleFilters = filtered.stream().map(filteredvc -> filteredvc.getFilters()).collect(Collectors.toList());
            VariantContext filteredVC = AlleleFilterUtils.addAlleleAndSiteFilters(variant, alleleFilters, this.invalidatePreviousFilters);
            this.writer.add(filteredVC);
        } else {
            this.writer.add(this.filter(variant, featureContext));
        }
    }

    private List<VariantContext> splitMultiAllelics(VariantContext vc) {
        ArrayList<VariantContext> results = new ArrayList<VariantContext>();
        VariantContextBuilder vcb = new VariantContextBuilder("SimpleSplit", vc.getContig(), (long)vc.getStart(), (long)vc.getEnd(), Arrays.asList(vc.getReference(), Allele.NO_CALL));
        vc.getAlternateAlleles().forEach(allele -> results.add(GATKVariantContextUtils.trimAlleles(vcb.alleles(Arrays.asList(vc.getReference(), allele)).make(true), true, true)));
        return results;
    }

    private VariantContext addMaskIfCoversVariant(VariantContext vc, FeatureContext featureContext) {
        boolean variantsMasked;
        List<Feature> maskVariants = featureContext.getValues(this.mask, this.maskExtension, this.maskExtension);
        boolean bl = variantsMasked = maskVariants.isEmpty() == this.filterRecordsNotInMask;
        if (variantsMasked) {
            Sets.SetView oldFiltersPlusNewOne = Sets.union((Set)vc.getFilters(), Collections.singleton(this.maskName));
            return new VariantContextBuilder(vc).filters((Set)oldFiltersPlusNewOne).make();
        }
        return vc;
    }

    private boolean isMaskFilterPresent(VariantContext vc) {
        return vc.getFilters() != null && vc.getFilters().contains(this.maskName);
    }

    private VariantContext filter(VariantContext variant, FeatureContext featureContext) {
        VariantContext vcModFilters = this.invalidatePreviousFilters ? new VariantContextBuilder(variant).unfiltered().make() : variant;
        VariantContext vc = this.isMaskFilterPresent(vcModFilters) ? vcModFilters : this.addMaskIfCoversVariant(vcModFilters, featureContext);
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        if (!this.genotypeFilterExps.isEmpty() || this.setFilteredGenotypesToNocall) {
            GATKVariantContextUtils.setFilteredGenotypeToNocall(builder, vc, this.setFilteredGenotypesToNocall, this::getGenotypeFilters);
        }
        LinkedHashSet<String> filters = new LinkedHashSet<String>(vc.getFilters());
        if (this.areClusteredSNPs(featureContext, vc)) {
            filters.add(CLUSTERED_SNP_FILTER_NAME);
        }
        for (VariantContextUtils.JexlVCMatchExp exp : this.filterExps) {
            if (!this.matchesFilter(vc, null, exp, this.invertFilterExpression)) continue;
            filters.add(exp.name);
        }
        if (filters.isEmpty()) {
            if (!this.invalidatePreviousFilters) {
                builder.passFilters();
            } else {
                builder.unfiltered();
            }
        } else {
            builder.filters(filters);
        }
        return builder.make();
    }

    private List<String> getGenotypeFilters(VariantContext vc, Genotype g) {
        ArrayList<String> filters = new ArrayList<String>();
        if (g.isFiltered()) {
            filters.addAll(Arrays.asList(g.getFilters().split(FILTER_DELIMITER)));
        }
        for (VariantContextUtils.JexlVCMatchExp exp : this.genotypeFilterExps) {
            if (!this.matchesFilter(vc, g, exp, this.invertGenotypeFilterExpression)) continue;
            filters.add(exp.name);
        }
        return filters;
    }

    private boolean matchesFilter(VariantContext vc, Genotype g, VariantContextUtils.JexlVCMatchExp exp, boolean invertVCfilterExpression) {
        return VariantFiltration.invertLogic(VariantContextUtils.match((VariantContext)vc, (Genotype)g, (VariantContextUtils.JexlVCMatchExp)exp, (JexlMissingValueTreatment)this.howToTreatMissingValues), invertVCfilterExpression);
    }

    private boolean areClusteredSNPs(FeatureContext featureContext, VariantContext current) {
        if (this.clusterWindow < 1) {
            return false;
        }
        if (!current.isSNP()) {
            return false;
        }
        List snpsInVicinity = featureContext.getValues(this.getDrivingVariantsFeatureInput(), this.clusterWindow, this.clusterWindow).stream().filter(v -> v.isSNP()).collect(Collectors.toList());
        if (snpsInVicinity.size() < this.clusterSize) {
            return false;
        }
        snpsInVicinity.sort(IntervalUtils.LEXICOGRAPHICAL_ORDER_COMPARATOR);
        int currentStartPos = current.getStart();
        int firstIndex = 0;
        int firstPos = ((VariantContext)snpsInVicinity.get(firstIndex)).getStart();
        int n = this.clusterSize - 1;
        while (firstPos <= currentStartPos && firstIndex + n < snpsInVicinity.size()) {
            int firstPlusNPos = ((VariantContext)snpsInVicinity.get(firstIndex + n)).getStart();
            if (firstPlusNPos - firstPos < this.clusterWindow) {
                return true;
            }
            firstPos = ((VariantContext)snpsInVicinity.get(++firstIndex)).getStart();
        }
        return false;
    }

    @Override
    public void closeTool() {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

