/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleListPermutation;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;

public class AlleleLikelihoodMatrixMapper<A extends Allele> {
    private final AlleleListPermutation<A> permutation;

    public AlleleLikelihoodMatrixMapper(AlleleListPermutation<A> permutation) {
        this.permutation = Utils.nonNull(permutation);
    }

    public <EVIDENCE> LikelihoodMatrix<EVIDENCE, A> mapAlleles(final LikelihoodMatrix<EVIDENCE, A> original) {
        if (this.permutation.isNonPermuted()) {
            return original;
        }
        return new LikelihoodMatrix<EVIDENCE, A>(){

            @Override
            public List<EVIDENCE> evidence() {
                return original.evidence();
            }

            @Override
            public List<A> alleles() {
                return AlleleLikelihoodMatrixMapper.this.permutation.toList();
            }

            @Override
            public void set(int alleleIndex, int evidenceIndex, double value) {
                Utils.validateArg(alleleIndex >= 0, "alleleIndex");
                Utils.validateArg(evidenceIndex >= 0, "readIndex");
                original.set(AlleleLikelihoodMatrixMapper.this.permutation.fromIndex(alleleIndex), evidenceIndex, value);
            }

            @Override
            public double get(int alleleIndex, int evidenceIndex) {
                Utils.validateArg(alleleIndex >= 0, "alleleIndex");
                Utils.validateArg(evidenceIndex >= 0, "readIndex");
                return original.get(AlleleLikelihoodMatrixMapper.this.permutation.fromIndex(alleleIndex), evidenceIndex);
            }

            @Override
            public int indexOfAllele(A allele) {
                Utils.nonNull(allele);
                return AlleleLikelihoodMatrixMapper.this.permutation.indexOfAllele(allele);
            }

            @Override
            public int indexOfEvidence(EVIDENCE read) {
                Utils.nonNull(read);
                return original.indexOfEvidence(read);
            }

            @Override
            public int numberOfAlleles() {
                return AlleleLikelihoodMatrixMapper.this.permutation.toSize();
            }

            @Override
            public int evidenceCount() {
                return original.evidenceCount();
            }

            @Override
            public A getAllele(int alleleIndex) {
                Utils.validateArg(alleleIndex >= 0, "alleleIndex");
                return original.getAllele(AlleleLikelihoodMatrixMapper.this.permutation.fromIndex(alleleIndex));
            }

            @Override
            public EVIDENCE getEvidence(int evidenceIndex) {
                Utils.validateArg(evidenceIndex >= 0, "readIndex");
                return original.getEvidence(evidenceIndex);
            }

            @Override
            public void copyAlleleLikelihoods(int alleleIndex, double[] dest, int offset) {
                Utils.validateArg(alleleIndex >= 0, "alleleIndex");
                Utils.nonNull(dest);
                original.copyAlleleLikelihoods(AlleleLikelihoodMatrixMapper.this.permutation.fromIndex(alleleIndex), dest, offset);
            }
        };
    }
}

