/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleLikelihoodMatrixMapper;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculatorDRAGEN;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingData;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingLikelihoods;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingDebugger;
import org.broadinstitute.hellbender.transformers.DRAGENMappingQualityReadTransformer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.dragstr.DragstrReferenceAnalyzer;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;
import org.broadinstitute.hellbender.utils.genotyper.AlleleListPermutation;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class DRAGENGenotypesModel
implements GenotypingModel {
    private static final int DEFAULT_CACHE_PLOIDY_CAPACITY = 10;
    private static final int DEFAULT_CACHE_ALLELE_CAPACITY = 50;
    public static final double FLAT_SNP_HET_PRIOR = 34.77;
    public static final double BQD_HOMOPOLYMER_PHRED_ADJUSTMENT_FACTOR = 5.0;
    private final int cacheAlleleCountCapacity;
    private final int cachePloidyCapacity;
    private GenotypeLikelihoodCalculatorDRAGEN[][] likelihoodCalculators;
    private final GenotypeLikelihoodCalculators calculators;
    private final boolean computeBQD;
    private final boolean computeFRD;
    private final int allelePadding;
    private final int maxEffectiveDepthAdjustment;
    private final DragstrParams dragstrParams;

    public DRAGENGenotypesModel(boolean useBQDModel, boolean useFRDModel, int allelePadding, int maxEffectiveDepthAdjustment, DragstrParams dragstrParams) {
        this(10, 50, useBQDModel, useFRDModel, allelePadding, maxEffectiveDepthAdjustment, dragstrParams);
    }

    public DRAGENGenotypesModel(int calculatorCachePloidyCapacity, int calculatorCacheAlleleCapacity, boolean useBQDModel, boolean useFRDModel, int allelePadding, int maxEffectiveDepthAdjustment, DragstrParams dragstrParams) {
        this.cachePloidyCapacity = calculatorCachePloidyCapacity;
        this.cacheAlleleCountCapacity = calculatorCacheAlleleCapacity;
        this.likelihoodCalculators = new GenotypeLikelihoodCalculatorDRAGEN[calculatorCachePloidyCapacity][calculatorCacheAlleleCapacity];
        this.calculators = new GenotypeLikelihoodCalculators();
        this.computeBQD = useBQDModel;
        this.computeFRD = useFRDModel;
        this.allelePadding = allelePadding;
        this.maxEffectiveDepthAdjustment = maxEffectiveDepthAdjustment;
        this.dragstrParams = dragstrParams;
        if (!this.computeBQD && !this.computeFRD) {
            throw new GATKException("DRAGENGenotypesModel is intended for computing BQD/FRD adjustments but both BQD and FRD are disabled, use IndependentSamplesGenotypesModel instead");
        }
    }

    @Override
    public <A extends Allele> GenotypingLikelihoods<A> calculateLikelihoods(AlleleList<A> genotypingAlleles, GenotypingData<A> data, byte[] paddedReference, int offsetForRefIntoEvent, DragstrReferenceAnalyzer dragstrs) {
        double api;
        Utils.nonNull(genotypingAlleles, "the allele cannot be null");
        Utils.nonNull(data, "the genotyping data cannot be null");
        if (dragstrs != null) {
            int period = dragstrs.period(offsetForRefIntoEvent + 1);
            int repeats = dragstrs.repeatLength(offsetForRefIntoEvent + 1);
            api = this.dragstrParams.api(period, repeats);
            if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                HaplotypeCallerGenotypingDebugger.println("API found: " + api + " with period used: " + period + "  and repeats: " + repeats);
            }
        } else {
            if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                HaplotypeCallerGenotypingDebugger.println("No API from DRAGStrs found, falling back on snp het prior for indels");
            }
            api = 34.77;
        }
        AlleleListPermutation<A> permutation = data.permutation(genotypingAlleles);
        AlleleLikelihoodMatrixMapper<A> alleleLikelihoodMatrixMapper = new AlleleLikelihoodMatrixMapper<A>(permutation);
        int sampleCount = data.numberOfSamples();
        PloidyModel ploidyModel = data.ploidyModel();
        ArrayList<GenotypeLikelihoods> genotypeLikelihoods = new ArrayList<GenotypeLikelihoods>(sampleCount);
        int alleleCount = genotypingAlleles.numberOfAlleles();
        int variantOffset = data.readLikelihoods().getVariantCallingSubsetApplied().getStart() + this.allelePadding;
        GenotypeLikelihoodCalculatorDRAGEN likelihoodsCalculator = this.getLikelihoodsCalculator(ploidyModel.samplePloidy(0), alleleCount);
        for (int sampleIndex = 0; sampleIndex < sampleCount; ++sampleIndex) {
            int indexForSnp;
            List<GATKRead> readsForSample = data.readLikelihoods().sampleEvidence(sampleIndex);
            List<GATKRead> hmmFilteredReadsForSample = data.readLikelihoods().filteredSampleEvidence(sampleIndex);
            ArrayList<DragenReadContainer> strandForward = new ArrayList<DragenReadContainer>();
            ArrayList<DragenReadContainer> strandReverse = new ArrayList<DragenReadContainer>();
            for (int readIndex = 0; readIndex < readsForSample.size(); ++readIndex) {
                GATKRead readForSample = readsForSample.get(readIndex);
                indexForSnp = (Integer)ReadUtils.getReadIndexForReferenceCoordinate(readForSample, variantOffset).getLeft();
                (readForSample.isReverseStrand() ? strandReverse : strandForward).add(new DragenReadContainer(readForSample, indexForSnp, ReadUtils.getStrandedUnclippedStart(readForSample), readIndex));
            }
            for (GATKRead filteredReadForSample : hmmFilteredReadsForSample) {
                indexForSnp = (Integer)ReadUtils.getReadIndexForReferenceCoordinate(filteredReadForSample, variantOffset).getLeft();
                (filteredReadForSample.isReverseStrand() ? strandReverse : strandForward).add(new DragenReadContainer(filteredReadForSample, indexForSnp, ReadUtils.getStrandedUnclippedStart(filteredReadForSample), -1));
            }
            strandForward.sort(new ReadFeatherEndForwardComparator());
            strandReverse.sort(new ReadFeatherEndReverseComparator());
            int samplePloidy = ploidyModel.samplePloidy(sampleIndex);
            if (samplePloidy != likelihoodsCalculator.ploidy()) {
                likelihoodsCalculator = this.getLikelihoodsCalculator(samplePloidy, alleleCount);
            }
            LikelihoodMatrix<GATKRead, A> sampleLikelihoods = alleleLikelihoodMatrixMapper.mapAlleles(data.readLikelihoods().sampleMatrix(sampleIndex));
            double[] ploidyModelGenotypeLikelihoods = likelihoodsCalculator.rawGenotypeLikelihoods(sampleLikelihoods);
            if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                HaplotypeCallerGenotypingDebugger.println("\n Standard Genotyping Likelihoods Results:");
                HaplotypeCallerGenotypingDebugger.println(Arrays.toString(ploidyModelGenotypeLikelihoods));
            }
            if (this.computeBQD) {
                this.applyLikelihoodsAdjusmentToBaseline(ploidyModelGenotypeLikelihoods, "BQD", likelihoodsCalculator.calculateBQDLikelihoods(sampleLikelihoods, strandForward, strandReverse, paddedReference, offsetForRefIntoEvent, this.calculators));
            }
            if (this.computeFRD) {
                this.applyLikelihoodsAdjusmentToBaseline(ploidyModelGenotypeLikelihoods, "FRD", likelihoodsCalculator.calculateFRDLikelihoods(sampleLikelihoods, ploidyModelGenotypeLikelihoods, Stream.of(strandForward, strandReverse).flatMap(Collection::stream).collect(Collectors.toList()), 34.77, api, this.maxEffectiveDepthAdjustment, this.calculators));
            }
            genotypeLikelihoods.add(GenotypeLikelihoods.fromLog10Likelihoods((double[])ploidyModelGenotypeLikelihoods));
            if (!HaplotypeCallerGenotypingDebugger.isEnabled()) continue;
            HaplotypeCallerGenotypingDebugger.println("merged matrix:");
            HaplotypeCallerGenotypingDebugger.println(Arrays.toString(ploidyModelGenotypeLikelihoods));
        }
        return new GenotypingLikelihoods<A>(genotypingAlleles, ploidyModel, genotypeLikelihoods);
    }

    private void applyLikelihoodsAdjusmentToBaseline(double[] initialLikelihoods, String name, double[] adjustmentLikelihoods) {
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            HaplotypeCallerGenotypingDebugger.println(name + " adjusted likelihoods:");
            HaplotypeCallerGenotypingDebugger.println(Arrays.toString(adjustmentLikelihoods));
        }
        Utils.validate(initialLikelihoods.length == adjustmentLikelihoods.length, () -> "Baseline likelihoods table mismatches in length to " + name + " likelihoods tabble");
        for (int gt = 0; gt < initialLikelihoods.length; ++gt) {
            initialLikelihoods[gt] = Math.max(initialLikelihoods[gt], adjustmentLikelihoods[gt]);
        }
    }

    private GenotypeLikelihoodCalculatorDRAGEN getLikelihoodsCalculator(int samplePloidy, int alleleCount) {
        GenotypeLikelihoodCalculatorDRAGEN newOne;
        if (samplePloidy >= this.cachePloidyCapacity || alleleCount >= this.cacheAlleleCountCapacity) {
            return this.calculators.getInstanceDRAGEN(samplePloidy, alleleCount);
        }
        GenotypeLikelihoodCalculatorDRAGEN cachedResult = this.likelihoodCalculators[samplePloidy][alleleCount];
        if (cachedResult != null) {
            return cachedResult;
        }
        this.likelihoodCalculators[samplePloidy][alleleCount] = newOne = this.calculators.getInstanceDRAGEN(samplePloidy, alleleCount);
        return newOne;
    }

    public class ReadFeatherEndReverseComparator
    implements Comparator<DragenReadContainer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(DragenReadContainer read1, DragenReadContainer read2) {
            int diffVal = read2.getReverseFeatherEnd() - read1.getReverseFeatherEnd();
            if (diffVal == 0) {
                diffVal = (read1.hasValidBaseQuality() ? read1.getBaseQuality() : 0) - (read2.hasValidBaseQuality() ? read2.getBaseQuality() : 0);
            }
            return diffVal;
        }
    }

    public class ReadFeatherEndForwardComparator
    implements Comparator<DragenReadContainer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(DragenReadContainer read1, DragenReadContainer read2) {
            int diffVal = read2.getForwardsFeatherEnd() - read1.getForwardsFeatherEnd();
            if (diffVal == 0) {
                diffVal = (read1.hasValidBaseQuality() ? read1.getBaseQuality() : 0) - (read2.hasValidBaseQuality() ? read2.getBaseQuality() : 0);
            }
            return diffVal;
        }
    }

    static class DragenReadContainer {
        final GATKRead underlyingRead;
        final int offsetIntoReadForBaseQuality;
        final int unclippedEnd;
        final int indexInLikelihoodsObject;
        double phredPFValue = 0.0;

        private DragenReadContainer(GATKRead underlyingRead, int offsetIntoReadForBaseQuality, int unclippedEnd, int indexInLikelihoodsObject) {
            this.underlyingRead = underlyingRead;
            this.offsetIntoReadForBaseQuality = offsetIntoReadForBaseQuality;
            this.unclippedEnd = unclippedEnd;
            this.indexInLikelihoodsObject = indexInLikelihoodsObject;
        }

        public int getUnclippedPosition() {
            return this.unclippedEnd;
        }

        public int getIndexInLikelihoodsObject() {
            return this.indexInLikelihoodsObject;
        }

        public boolean wasFilteredByHMM() {
            return this.getIndexInLikelihoodsObject() == -1;
        }

        public boolean hasValidBaseQuality() {
            return this.offsetIntoReadForBaseQuality != -1;
        }

        public int getBaseQuality() {
            return this.underlyingRead.getBaseQuality(this.offsetIntoReadForBaseQuality);
        }

        public int getForwardsFeatherEnd() {
            return this.underlyingRead.getSoftStart() - this.underlyingRead.getUnclippedStart() + this.offsetIntoReadForBaseQuality;
        }

        public int getReverseFeatherEnd() {
            return this.underlyingRead.getUnclippedEnd() - this.underlyingRead.getSoftEnd() + (this.underlyingRead.getLength() - this.offsetIntoReadForBaseQuality);
        }

        public double getPhredScaledMappingQuality() {
            return DRAGENMappingQualityReadTransformer.mapMappingQualityToPhredLikelihoodScore(this.underlyingRead.getMappingQuality());
        }

        public double getPhredPFValue() {
            return this.phredPFValue;
        }

        public void setPhredPFValue(double phredPFValue) {
            this.phredPFValue = phredPFValue;
        }

        public String toString() {
            return String.format("Read: %s index: %d at unclipped end: %d with base quality %d", this.underlyingRead.toString(), this.indexInLikelihoodsObject, this.unclippedEnd, this.hasValidBaseQuality() ? this.getBaseQuality() : -1);
        }

        public boolean isReverseStrand() {
            return this.underlyingRead.isReverseStrand();
        }
    }
}

