/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.functional.IntBiConsumer;
import org.broadinstitute.hellbender.utils.functional.IntToDoubleBiFunction;

public final class GenotypeAlleleCounts
implements Comparable<GenotypeAlleleCounts> {
    private static final double UNCOMPUTED_LOG_10_COMBINATION_COUNT = -1.0;
    private double log10CombinationCount = -1.0;
    private final int ploidy;
    private int[] sortedAlleleCounts;
    private int distinctAlleleCount;
    private int index;

    private GenotypeAlleleCounts(int ploidy, int index, int ... sortedAlleleCounts) {
        this(ploidy, index, sortedAlleleCounts, sortedAlleleCounts.length >> 1);
    }

    private GenotypeAlleleCounts(int ploidy, int index, int[] sortedAlleleCounts, int distinctAlleleCount) {
        this.ploidy = ploidy;
        this.index = index;
        this.sortedAlleleCounts = sortedAlleleCounts;
        this.distinctAlleleCount = distinctAlleleCount;
    }

    public int ploidy() {
        return this.ploidy;
    }

    protected void increase(int times) {
        Utils.validateArg(times >= 0, "times");
        for (int i = 0; i < times; ++i) {
            this.increase();
        }
    }

    protected void increase() {
        if (this.distinctAlleleCount == 0) {
            return;
        }
        if (this.distinctAlleleCount == 1) {
            if (this.ploidy == 1) {
                this.sortedAlleleCounts[0] = this.sortedAlleleCounts[0] + 1;
            } else {
                if (this.sortedAlleleCounts.length < 4) {
                    this.sortedAlleleCounts = Arrays.copyOf(this.sortedAlleleCounts, 4);
                }
                this.sortedAlleleCounts[2] = this.sortedAlleleCounts[0] + 1;
                this.sortedAlleleCounts[3] = 1;
                this.sortedAlleleCounts[0] = 0;
                this.sortedAlleleCounts[1] = this.ploidy - 1;
                this.distinctAlleleCount = 2;
            }
        } else {
            int allele0 = this.sortedAlleleCounts[0];
            int freq0 = this.sortedAlleleCounts[1];
            int allele0Plus1 = allele0 + 1;
            int allele1 = this.sortedAlleleCounts[2];
            boolean allele0And1AreConsecutive = allele0Plus1 == allele1;
            int sortedAlleleCountsLength = this.distinctAlleleCount << 1;
            if (freq0 == 1) {
                if (allele0And1AreConsecutive) {
                    System.arraycopy(this.sortedAlleleCounts, 2, this.sortedAlleleCounts, 0, sortedAlleleCountsLength - 2);
                    this.sortedAlleleCounts[1] = this.sortedAlleleCounts[1] + 1;
                    --this.distinctAlleleCount;
                } else {
                    this.sortedAlleleCounts[0] = allele0Plus1;
                }
            } else if (allele0And1AreConsecutive) {
                this.sortedAlleleCounts[0] = 0;
                this.sortedAlleleCounts[1] = freq0 - 1;
                this.sortedAlleleCounts[3] = this.sortedAlleleCounts[3] + 1;
            } else {
                if (this.sortedAlleleCounts.length < sortedAlleleCountsLength + 2) {
                    this.sortedAlleleCounts = Arrays.copyOf(this.sortedAlleleCounts, sortedAlleleCountsLength + 2);
                }
                System.arraycopy(this.sortedAlleleCounts, 2, this.sortedAlleleCounts, 4, sortedAlleleCountsLength - 2);
                this.sortedAlleleCounts[0] = 0;
                this.sortedAlleleCounts[1] = freq0 - 1;
                this.sortedAlleleCounts[2] = allele0Plus1;
                this.sortedAlleleCounts[3] = 1;
                ++this.distinctAlleleCount;
            }
        }
        ++this.index;
        this.log10CombinationCount = -1.0;
    }

    protected GenotypeAlleleCounts next() {
        int[] newSortedAlleleCounts;
        if (this.distinctAlleleCount == 0) {
            return this;
        }
        if (this.distinctAlleleCount == 1 && this.ploidy == 1) {
            return new GenotypeAlleleCounts(1, this.index + 1, this.sortedAlleleCounts[0] + 1, 1);
        }
        if (this.distinctAlleleCount == 1) {
            return new GenotypeAlleleCounts(this.ploidy, this.index + 1, 0, this.ploidy - 1, this.sortedAlleleCounts[0] + 1, 1);
        }
        int freq0 = this.sortedAlleleCounts[1];
        int allele0Plus1 = this.sortedAlleleCounts[0] + 1;
        boolean allele0And1AreConsecutive = allele0Plus1 == this.sortedAlleleCounts[2];
        int sortedAlleleCountsLength = this.distinctAlleleCount << 1;
        if (freq0 == 1) {
            if (allele0And1AreConsecutive) {
                newSortedAlleleCounts = Arrays.copyOfRange(this.sortedAlleleCounts, 2, sortedAlleleCountsLength);
                newSortedAlleleCounts[1] = newSortedAlleleCounts[1] + 1;
            } else {
                newSortedAlleleCounts = Arrays.copyOf(this.sortedAlleleCounts, sortedAlleleCountsLength);
                newSortedAlleleCounts[0] = allele0Plus1;
            }
        } else if (allele0And1AreConsecutive) {
            newSortedAlleleCounts = (int[])this.sortedAlleleCounts.clone();
            newSortedAlleleCounts[0] = 0;
            newSortedAlleleCounts[1] = freq0 - 1;
            newSortedAlleleCounts[3] = newSortedAlleleCounts[3] + 1;
        } else {
            newSortedAlleleCounts = new int[sortedAlleleCountsLength + 2];
            newSortedAlleleCounts[0] = 0;
            newSortedAlleleCounts[1] = freq0 - 1;
            newSortedAlleleCounts[2] = allele0Plus1;
            newSortedAlleleCounts[3] = newSortedAlleleCounts[3] + 1;
            System.arraycopy(this.sortedAlleleCounts, 2, newSortedAlleleCounts, 4, sortedAlleleCountsLength - 2);
        }
        return new GenotypeAlleleCounts(this.ploidy, this.index + 1, newSortedAlleleCounts);
    }

    public int distinctAlleleCount() {
        return this.distinctAlleleCount;
    }

    public double log10CombinationCount() {
        if (this.log10CombinationCount == -1.0) {
            this.log10CombinationCount = MathUtils.log10Factorial(this.ploidy) - new IndexRange(0, this.distinctAlleleCount).sum(n -> MathUtils.log10Factorial(this.sortedAlleleCounts[2 * n + 1]));
        }
        return this.log10CombinationCount;
    }

    public int alleleIndexAt(int rank) {
        Utils.validateArg(rank >= 0 && rank < this.distinctAlleleCount, () -> "the requested rank " + rank + " is out of range [0," + this.distinctAlleleCount + ")");
        return this.sortedAlleleCounts[rank << 1];
    }

    public int alleleRankFor(int index) {
        Utils.validateArg(index >= 0, "the index must be 0 or greater");
        return this.alleleIndexToRank(index, 0, this.distinctAlleleCount);
    }

    public String toUnphasedGenotypeString() {
        if (this.ploidy == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.distinctAlleleCount * 3);
        int upperBound = this.distinctAlleleCount * 2;
        int i = 0;
        while (i < upperBound) {
            int alleleIndex = this.sortedAlleleCounts[i++];
            int alleleCount = this.sortedAlleleCounts[i++];
            for (int j = 0; j < alleleCount; ++j) {
                sb.append(alleleIndex).append("/");
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String toString() {
        return this.toUnphasedGenotypeString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenotypeAlleleCounts)) {
            return false;
        }
        GenotypeAlleleCounts other = (GenotypeAlleleCounts)o;
        if (this.ploidy != other.ploidy) {
            return false;
        }
        return Arrays.equals(this.sortedAlleleCounts, other.sortedAlleleCounts);
    }

    public int hashCode() {
        return (31 + this.ploidy) * 31 + this.index;
    }

    public int index() {
        return this.index;
    }

    @Override
    public int compareTo(GenotypeAlleleCounts other) {
        Utils.nonNull(other, "input genotype cannot be null");
        if (other == this) {
            return 0;
        }
        if (other.ploidy == this.ploidy) {
            return Integer.compare(this.index, other.index);
        }
        return Integer.compare(this.ploidy, other.ploidy);
    }

    private int alleleIndexToRank(int index, int from, int to) {
        if (to <= from) {
            return -from - 1;
        }
        if (from == to - 1) {
            int onlyIndex = this.sortedAlleleCounts[from << 1];
            return onlyIndex == index ? from : (onlyIndex > index ? -from - 1 : -to - 1);
        }
        int mid = to + from >> 1;
        int midIndex = this.sortedAlleleCounts[mid << 1];
        if (midIndex == index) {
            return mid;
        }
        if (midIndex < index) {
            return this.alleleIndexToRank(index, mid + 1, to);
        }
        return this.alleleIndexToRank(index, 0, mid);
    }

    public int alleleCountAt(int rank) {
        Utils.validateArg(rank >= 0 && rank < this.distinctAlleleCount, "the rank is out of range");
        return this.sortedAlleleCounts[(rank << 1) + 1];
    }

    public boolean containsAllele(int index) {
        return this.alleleRankFor(index) >= 0;
    }

    public int alleleCountFor(int index) {
        int rank = this.alleleRankFor(index);
        return rank < 0 ? 0 : this.alleleCountAt(rank);
    }

    public int[] alleleCountsByIndex(int maximumAlleleIndex) {
        Utils.validateArg(maximumAlleleIndex >= 0, "the requested allele count cannot be less than 0");
        int[] result = new int[maximumAlleleIndex + 1];
        this.copyAlleleCountsByIndex(result, 0, 0, maximumAlleleIndex);
        return result;
    }

    private void copyAlleleCountsByIndex(int[] dest, int offset, int minimumAlleleIndex, int maximumAlleleIndex) {
        int minimumAlleleRank = this.alleleRankFor(minimumAlleleIndex);
        int maximumAlleleRank = this.alleleRankFor(maximumAlleleIndex);
        int startRank = minimumAlleleRank < 0 ? -minimumAlleleRank - 1 : minimumAlleleRank;
        int endRank = maximumAlleleRank < 0 ? -maximumAlleleRank - 2 : maximumAlleleRank;
        int nextIndex = minimumAlleleIndex;
        int nextRank = startRank;
        int nextSortedAlleleCountsOffset = nextRank << 1;
        int nextDestOffset = offset;
        while (nextRank++ <= endRank) {
            int alleleIndex = this.sortedAlleleCounts[nextSortedAlleleCountsOffset++];
            while (alleleIndex > nextIndex) {
                dest[nextDestOffset++] = 0;
                ++nextIndex;
            }
            dest[nextDestOffset++] = this.sortedAlleleCounts[nextSortedAlleleCountsOffset++];
            ++nextIndex;
        }
        while (nextIndex++ <= maximumAlleleIndex) {
            dest[nextDestOffset++] = 0;
        }
    }

    public void copyAlleleCounts(int[] dest, int offset) {
        Utils.nonNull(dest, "the destination cannot be null");
        Utils.validateArg(offset >= 0, "the offset cannot be negative");
        int sortedAlleleCountsLength = this.distinctAlleleCount << 1;
        Utils.validateArg(offset + sortedAlleleCountsLength <= dest.length, "the input array does not have enough capacity");
        System.arraycopy(this.sortedAlleleCounts, 0, dest, offset, sortedAlleleCountsLength);
    }

    protected static GenotypeAlleleCounts first(int ploidy) {
        Utils.validateArg(ploidy >= 0, "the ploidy must be 0 or greater");
        return ploidy == 0 ? new GenotypeAlleleCounts(0, 0, new int[0]) : new GenotypeAlleleCounts(ploidy, 0, 0, ploidy);
    }

    public int maximumAlleleIndex() {
        return this.distinctAlleleCount == 0 ? -1 : this.sortedAlleleCounts[this.distinctAlleleCount - 1 << 1];
    }

    public int minimumAlleleIndex() {
        return this.distinctAlleleCount == 0 ? -1 : this.sortedAlleleCounts[0];
    }

    GenotypeAlleleCounts copy() {
        return new GenotypeAlleleCounts(this.ploidy, this.index, (int[])this.sortedAlleleCounts.clone(), this.distinctAlleleCount);
    }

    public <T extends Allele> List<T> asAlleleList(List<T> allelesToUse) {
        Utils.nonNull(allelesToUse, "the input allele list cannot be null");
        Utils.validateArg(allelesToUse.size() >= this.maximumAlleleIndex(), "the provided alleles to use does not contain an element for the maximum allele");
        return this.distinctAlleleCount == 1 ? Collections.nCopies(this.ploidy, allelesToUse.get(this.sortedAlleleCounts[0])) : IntStream.range(0, this.distinctAlleleCount).boxed().flatMap(distinctAllele -> {
            Allele allele = (Allele)allelesToUse.get(this.sortedAlleleCounts[2 * distinctAllele]);
            int repeats = this.sortedAlleleCounts[2 * distinctAllele + 1];
            return Collections.nCopies(repeats, allele).stream();
        }).collect(Collectors.toList());
    }

    public void forEachAlleleIndexAndCount(IntBiConsumer action) {
        new IndexRange(0, this.distinctAlleleCount).forEach(n -> action.accept(this.sortedAlleleCounts[2 * n], this.sortedAlleleCounts[2 * n + 1]));
    }

    public void forEachAbsentAlleleIndex(IntConsumer action, int alleleCount) {
        int presentAlleleIndex = 0;
        int presentAllele = this.sortedAlleleCounts[0];
        for (int n = 0; n < alleleCount; ++n) {
            if (n == presentAllele) {
                if (++presentAlleleIndex >= this.distinctAlleleCount) continue;
                presentAllele = this.sortedAlleleCounts[2 * presentAlleleIndex];
                continue;
            }
            action.accept(n);
        }
    }

    public double sumOverAlleleIndicesAndCounts(IntToDoubleBiFunction func) {
        return new IndexRange(0, this.distinctAlleleCount).sum(n -> func.apply(this.sortedAlleleCounts[2 * n], this.sortedAlleleCounts[2 * n + 1]));
    }
}

