/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;

public final class GenotypeCalculationArgumentCollection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String SUPPORTING_CALLSET_LONG_NAME = "population-callset";
    public static final String SUPPORTING_CALLSET_SHORT_NAME = "population";
    public static final String NUM_REF_SAMPLES_LONG_NAME = "num-reference-samples-if-no-call";
    public static final String MAX_ALTERNATE_ALLELES_LONG_NAME = "max-alternate-alleles";
    public static final String MAX_GENOTYPE_COUNT_LONG_NAME = "max-genotype-count";
    public static final String SAMPLE_PLOIDY_SHORT_NAME = "ploidy";
    public static final String SAMPLE_PLOIDY_LONG_NAME = "sample-ploidy";
    public static final double DEFAULT_STANDARD_CONFIDENCE_FOR_CALLING = 30.0;
    public static final int DEFAULT_MAX_ALTERNATE_ALLELES = 6;
    public static final int DEFAULT_MAX_GENOTYPE_COUNT = 1024;
    @Argument(fullName="use-posteriors-to-calculate-qual", shortName="gp-qual", optional=true, doc="if available, use the genotype posterior probabilities to calculate the site QUAL")
    public boolean usePosteriorProbabilitiesToCalculateQual = false;
    @Advanced
    @Argument(fullName="dont-use-dragstr-priors", doc="Forfeit the use of the DRAGstr model to calculate genotype priors. This argument does not have any effect in the absence of DRAGstr model parameters (--dragstr-model-params)", optional=true)
    public boolean dontUseDragstrPriors = false;
    @Deprecated
    @Argument(fullName="use-new-qual-calculator", shortName="new-qual", doc="Use the new AF model instead of the so-called exact model", optional=true)
    public boolean useNewAFCalculator = true;
    @Argument(fullName="annotate-with-num-discovered-alleles", doc="If provided, we will annotate records with the number of alternate alleles that were discovered (but not necessarily genotyped) at a given site", optional=true)
    public boolean ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED = false;
    @Argument(fullName="heterozygosity", doc="Heterozygosity value used to compute prior likelihoods for any locus.  See the GATKDocs for full details on the meaning of this population genetics concept", optional=true)
    public Double snpHeterozygosity = 0.001;
    @Argument(fullName="indel-heterozygosity", doc="Heterozygosity for indel calling.  See the GATKDocs for heterozygosity for full details on the meaning of this population genetics concept", optional=true)
    public double indelHeterozygosity = 1.25E-4;
    @Argument(fullName="heterozygosity-stdev", doc="Standard deviation of heterozygosity for SNP and indel calling.", optional=true)
    public double heterozygosityStandardDeviation = 0.01;
    @Argument(fullName="standard-min-confidence-threshold-for-calling", shortName="stand-call-conf", doc="The minimum phred-scaled confidence threshold at which variants should be called", optional=true)
    public double STANDARD_CONFIDENCE_FOR_CALLING = 30.0;
    @Advanced
    @Argument(fullName="max-alternate-alleles", doc="Maximum number of alternate alleles to genotype", optional=true)
    public int MAX_ALTERNATE_ALLELES = 6;
    @Advanced
    @Argument(fullName="max-genotype-count", doc="Maximum number of genotypes to consider at any site", optional=true)
    public int MAX_GENOTYPE_COUNT = 1024;
    @Argument(shortName="ploidy", fullName="sample-ploidy", doc="Ploidy (number of chromosomes) per sample. For pooled data, set to (Number of samples in each pool * Sample Ploidy).", optional=true)
    public int samplePloidy = 2;
    @Argument(fullName="population-callset", shortName="population", doc="Callset to use in calculating genotype priors", optional=true)
    public FeatureInput<VariantContext> supportVariants = null;
    @Argument(fullName="num-reference-samples-if-no-call", doc="Number of hom-ref genotypes to infer at sites not present in a panel", optional=true)
    public int numRefIfMissing = 0;
    @Argument(fullName="genotype-assignment-method", shortName="gam", doc="How we assign genotypes", optional=true)
    public GenotypeAssignmentMethod genotypeAssignmentMethod = GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN;

    public GenotypeCalculationArgumentCollection clone() {
        try {
            return (GenotypeCalculationArgumentCollection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new GATKException("this line of code should not be reached");
        }
    }
}

