/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class GenotypingData<A extends Allele>
implements SampleList,
AlleleList<A> {
    private final PloidyModel ploidyModel;
    private final AlleleLikelihoods<GATKRead, A> likelihoods;

    public GenotypingData(PloidyModel ploidyModel, AlleleLikelihoods<GATKRead, A> likelihoods) {
        Utils.nonNull(ploidyModel, "the ploidy model cannot be null");
        Utils.nonNull(likelihoods, "the likelihood object cannot be null");
        this.ploidyModel = ploidyModel;
        this.likelihoods = likelihoods;
        Utils.validateArg(ploidyModel.asListOfSamples().equals(likelihoods.asListOfSamples()), "sample list are different between ploidy-model and read-likelihood collection, perhaps just the order");
    }

    public PloidyModel ploidyModel() {
        return this.ploidyModel;
    }

    @Override
    public int numberOfSamples() {
        return this.ploidyModel.numberOfSamples();
    }

    @Override
    public int indexOfSample(String sample) {
        Utils.nonNull(sample);
        return this.ploidyModel.indexOfSample(sample);
    }

    @Override
    public String getSample(int sampleIndex) {
        Utils.validateArg(sampleIndex >= 0, "sampleIndex");
        return this.ploidyModel.getSample(sampleIndex);
    }

    public AlleleLikelihoods<GATKRead, A> readLikelihoods() {
        return this.likelihoods;
    }

    @Override
    public int numberOfAlleles() {
        return this.likelihoods.numberOfAlleles();
    }

    @Override
    public int indexOfAllele(A allele) {
        Utils.nonNull(allele);
        return this.likelihoods.indexOfAllele(allele);
    }

    @Override
    public A getAllele(int index) {
        Utils.validateArg(index >= 0, "index");
        return this.likelihoods.getAllele(index);
    }
}

