/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleSubsettingUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculator;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.tools.walkers.genotyper.OutputMode;
import org.broadinstitute.hellbender.tools.walkers.genotyper.StandardCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.afcalc.AFCalculationResult;
import org.broadinstitute.hellbender.tools.walkers.genotyper.afcalc.AlleleFrequencyCalculator;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerUtils;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.GenotypePriorCalculator;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public abstract class GenotypingEngine<Config extends StandardCallerArgumentCollection> {
    private static final int TOO_LONG_PL = 100000;
    protected final AlleleFrequencyCalculator alleleFrequencyCalculator;
    protected final Config configuration;
    protected VariantAnnotatorEngine annotationEngine;
    protected Logger logger;
    protected OneShotLogger oneShotLogger;
    protected final int numberOfGenomes;
    protected final SampleList samples;
    private final PriorityQueue<Locatable> upstreamDeletionsLoc = new PriorityQueue<Locatable>(Comparator.comparingInt(Locatable::getEnd));
    private final boolean doAlleleSpecificCalcs;
    private static final GenotypeLikelihoodCalculators GL_CALCS = new GenotypeLikelihoodCalculators();

    protected GenotypingEngine(Config configuration, SampleList samples, boolean doAlleleSpecificCalcs) {
        this.configuration = (StandardCallerArgumentCollection)Utils.nonNull(configuration, "the configuration cannot be null");
        this.samples = Utils.nonNull(samples, "the sample list cannot be null");
        this.doAlleleSpecificCalcs = doAlleleSpecificCalcs;
        this.logger = LogManager.getLogger(this.getClass());
        this.numberOfGenomes = this.samples.numberOfSamples() * ((StandardCallerArgumentCollection)configuration).genotypeArgs.samplePloidy;
        this.alleleFrequencyCalculator = AlleleFrequencyCalculator.makeCalculator(((StandardCallerArgumentCollection)configuration).genotypeArgs);
    }

    public void setLogger(Logger logger) {
        this.logger = Utils.nonNull(logger, "the logger cannot be null");
    }

    public Set<VCFInfoHeaderLine> getAppropriateVCFInfoHeaders() {
        LinkedHashSet<VCFInfoHeaderLine> headerInfo = new LinkedHashSet<VCFInfoHeaderLine>();
        if (((StandardCallerArgumentCollection)this.configuration).genotypeArgs.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED) {
            headerInfo.add(GATKVCFHeaderLines.getInfoLine("NDA"));
        }
        return headerInfo;
    }

    public void setAnnotationEngine(VariantAnnotatorEngine annotationEngine) {
        this.annotationEngine = annotationEngine;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    public VariantContext calculateGenotypes(VariantContext vc, GenotypePriorCalculator gpc, List<VariantContext> givenAlleles) {
        GenotypesContext genotypes;
        AFCalculationResult AFresult;
        OutputAlleleSubset outputAlternativeAlleles;
        double log10Confidence;
        double phredScaledConfidence;
        long maxPLLength;
        if (this.hasTooManyAlternativeAlleles(vc) || vc.getNSamples() == 0) {
            return null;
        }
        int defaultPloidy = ((StandardCallerArgumentCollection)this.configuration).genotypeArgs.samplePloidy;
        int maxAltAlleles = ((StandardCallerArgumentCollection)this.configuration).genotypeArgs.MAX_ALTERNATE_ALLELES;
        VariantContext reducedVC = vc;
        if (maxAltAlleles < vc.getAlternateAlleles().size()) {
            List<Allele> allelesToKeep = AlleleSubsettingUtils.calculateMostLikelyAlleles(vc, defaultPloidy, maxAltAlleles);
            GenotypesContext reducedGenotypes = allelesToKeep.size() == 1 ? GATKVariantContextUtils.subsetToRefOnly(vc, defaultPloidy) : AlleleSubsettingUtils.subsetAlleles(vc.getGenotypes(), defaultPloidy, vc.getAlleles(), allelesToKeep, gpc, GenotypeAssignmentMethod.SET_TO_NO_CALL, vc.getAttributeAsInt("DP", 0));
            reducedVC = new VariantContextBuilder(vc).alleles(allelesToKeep).genotypes(reducedGenotypes).make();
        }
        if ((maxPLLength = (long)GenotypeLikelihoods.numLikelihoods((int)reducedVC.getNAlleles(), (int)reducedVC.getMaxPloidy(defaultPloidy))) >= 100000L) {
            this.oneShotLogger.warn("Length of PL arrays for this VC(position:" + reducedVC.getStart() + ", alleles:" + reducedVC.getNAlleles() + ", ploidy:" + reducedVC.getMaxPloidy(defaultPloidy) + ") is likely to reach " + maxPLLength + ", so processing may take a long time.");
        }
        if (!this.passesEmitThreshold(phredScaledConfidence = -10.0 * (log10Confidence = !(outputAlternativeAlleles = this.calculateOutputAlleleSubset(AFresult = this.alleleFrequencyCalculator.calculate(reducedVC, defaultPloidy), vc, givenAlleles)).siteIsMonomorphic || ((StandardCallerArgumentCollection)this.configuration).annotateAllSitesWithPLs ? AFresult.log10ProbOnlyRefAlleleExists() + 0.0 : AFresult.log10ProbVariantPresent() + 0.0) + 0.0, outputAlternativeAlleles.siteIsMonomorphic) && !this.emitAllActiveSites() && GenotypingEngine.noAllelesOrFirstAlleleIsNotNonRef(outputAlternativeAlleles.alleles) && givenAlleles.isEmpty()) {
            return null;
        }
        if (!this.emitAllActiveSites() && outputAlternativeAlleles.alleles.size() == 1 && Allele.SPAN_DEL.equals(outputAlternativeAlleles.alleles.get(0))) {
            return null;
        }
        List outputAlleles = outputAlternativeAlleles.outputAlleles(vc.getReference());
        this.recordDeletions(vc, outputAlleles);
        VariantContextBuilder builder = new VariantContextBuilder(this.callSourceString(), vc.getContig(), (long)vc.getStart(), (long)vc.getEnd(), (Collection)outputAlleles);
        builder.log10PError(log10Confidence);
        if (!this.passesCallThreshold(phredScaledConfidence)) {
            builder.filter("LowQual");
        }
        GenotypesContext genotypesContext = genotypes = outputAlleles.size() == 1 ? GATKVariantContextUtils.subsetToRefOnly(vc, defaultPloidy) : AlleleSubsettingUtils.subsetAlleles(vc.getGenotypes(), defaultPloidy, vc.getAlleles(), outputAlleles, gpc, ((StandardCallerArgumentCollection)this.configuration).genotypeArgs.genotypeAssignmentMethod, vc.getAttributeAsInt("DP", 0));
        if (((StandardCallerArgumentCollection)this.configuration).genotypeArgs.usePosteriorProbabilitiesToCalculateQual && this.hasPosteriors(genotypes)) {
            double qualUpdate;
            double log10NoVariantPosterior = this.phredNoVariantPosteriorProbability(outputAlleles, genotypes) * -0.1;
            double d = qualUpdate = !outputAlternativeAlleles.siteIsMonomorphic || ((StandardCallerArgumentCollection)this.configuration).annotateAllSitesWithPLs ? log10NoVariantPosterior + 0.0 : MathUtils.log10OneMinusPow10(log10NoVariantPosterior) + 0.0;
            if (!Double.isNaN(qualUpdate)) {
                builder.log10PError(qualUpdate);
            }
        }
        Map<String, Object> attributes = this.composeCallAttributes(vc, outputAlternativeAlleles.alternativeAlleleMLECounts(), AFresult, outputAlternativeAlleles.outputAlleles(vc.getReference()), genotypes);
        return builder.genotypes(genotypes).attributes(attributes).make();
    }

    protected double phredNoVariantPosteriorProbability(List<Allele> alleles, GenotypesContext gc) {
        return gc.stream().mapToDouble(gt -> this.extractPNoAlt(alleles, (Genotype)gt)).filter(d -> !Double.isNaN(d)).reduce(Double.NaN, (a, b) -> Double.isNaN(a) ? b : (Double.isNaN(b) ? a : a + b));
    }

    private double extractPNoAlt(List<Allele> alleles, Genotype gt) {
        double[] gpArray = VariantContextGetters.getAttributeAsDoubleArray(gt, "GP", () -> new double[]{Double.NaN}, Double.NaN);
        return this.extractPNoAlt(alleles, gt, gpArray);
    }

    private double extractPNoAlt(List<Allele> alleles, Genotype gt, double[] posteriors) {
        if (!alleles.contains(Allele.SPAN_DEL)) {
            return posteriors[0] - Math.max(0.0, QualityUtils.phredSum(posteriors));
        }
        int ploidy = gt.getPloidy();
        GenotypeLikelihoodCalculator glCalc = GL_CALCS.getInstance(ploidy, alleles.size());
        int spanDelIndex = alleles.indexOf(Allele.SPAN_DEL);
        double[] nonVariantLog10Posteriors = IntStream.rangeClosed(0, ploidy).map(n -> glCalc.alleleCountsToIndex(0, ploidy - n, spanDelIndex, n)).mapToDouble(n -> posteriors[n]).toArray();
        return Math.max(0.0, QualityUtils.phredSum(nonVariantLog10Posteriors)) - Math.max(0.0, QualityUtils.phredSum(posteriors));
    }

    private boolean hasPosteriors(GenotypesContext gc) {
        return gc.stream().anyMatch(g -> g.hasExtendedAttribute("GP"));
    }

    public VariantContext calculateGenotypes(VariantContext vc) {
        return this.calculateGenotypes(vc, null, Collections.emptyList());
    }

    @VisibleForTesting
    static boolean noAllelesOrFirstAlleleIsNotNonRef(List<Allele> altAlleles) {
        Utils.nonNull(altAlleles);
        return altAlleles.isEmpty() || altAlleles.get(0) != Allele.NON_REF_ALLELE;
    }

    protected abstract String callSourceString();

    private OutputAlleleSubset calculateOutputAlleleSubset(AFCalculationResult afCalculationResult, VariantContext vc, List<VariantContext> givenAlleles) {
        ArrayList<Allele> outputAlleles = new ArrayList<Allele>();
        ArrayList<Integer> mleCounts = new ArrayList<Integer>();
        boolean siteIsMonomorphic = true;
        List<Allele> alleles = afCalculationResult.getAllelesUsedInGenotyping();
        int alternativeAlleleCount = alleles.size() - 1;
        int referenceAlleleSize = 0;
        Set<Allele> forcedAlleles = AssemblyBasedCallerUtils.getAllelesConsistentWithGivenAlleles(givenAlleles, vc);
        for (Allele allele : alleles) {
            if (allele.isReference()) {
                referenceAlleleSize = allele.length();
                continue;
            }
            boolean isNonRefWhichIsLoneAltAllele = alternativeAlleleCount == 1 && allele.equals((Object)Allele.NON_REF_ALLELE);
            boolean isPlausible = afCalculationResult.passesThreshold(allele, ((StandardCallerArgumentCollection)this.configuration).genotypeArgs.STANDARD_CONFIDENCE_FOR_CALLING);
            boolean isSpuriousSpanningDeletion = GATKVCFConstants.isSpanningDeletion(allele) && !this.isVcCoveredByDeletion(vc);
            boolean toOutput = (isPlausible || this.forceKeepAllele(allele) || isNonRefWhichIsLoneAltAllele || forcedAlleles.contains(allele)) && !isSpuriousSpanningDeletion;
            siteIsMonomorphic &= !isPlausible || isSpuriousSpanningDeletion;
            if (!toOutput) continue;
            outputAlleles.add(allele);
            mleCounts.add(afCalculationResult.getAlleleCountAtMLE(allele));
        }
        return new OutputAlleleSubset(outputAlleles, mleCounts, siteIsMonomorphic);
    }

    void clearUpstreamDeletionsLoc() {
        this.upstreamDeletionsLoc.clear();
    }

    @VisibleForTesting
    void recordDeletions(VariantContext vc, Collection<Allele> emittedAlleles) {
        while (!(this.upstreamDeletionsLoc.isEmpty() || this.upstreamDeletionsLoc.peek().contigsMatch((Locatable)vc) && this.upstreamDeletionsLoc.peek().getEnd() >= vc.getStart())) {
            this.upstreamDeletionsLoc.poll();
        }
        for (Allele allele : emittedAlleles) {
            int deletionSize = vc.getReference().length() - allele.length();
            if (deletionSize <= 0) continue;
            SimpleInterval genomeLoc = new SimpleInterval(vc.getContig(), vc.getStart(), vc.getStart() + deletionSize);
            this.upstreamDeletionsLoc.add(genomeLoc);
        }
    }

    boolean isVcCoveredByDeletion(VariantContext vc) {
        return !this.upstreamDeletionsLoc.isEmpty() && this.upstreamDeletionsLoc.stream().anyMatch(loc -> loc.getContig().equals(vc.getContig()) && loc.getStart() < vc.getStart() && vc.getStart() <= loc.getEnd());
    }

    protected abstract boolean forceKeepAllele(Allele var1);

    protected final boolean hasTooManyAlternativeAlleles(VariantContext vc) {
        if (vc.getNAlleles() <= 50) {
            return false;
        }
        this.logger.warn("Attempting to genotype more than 50 alleles. Site will be skipped at location " + vc.getContig() + ":" + vc.getStart());
        return true;
    }

    protected boolean emitAllActiveSites() {
        return ((StandardCallerArgumentCollection)this.configuration).outputMode == OutputMode.EMIT_ALL_ACTIVE_SITES;
    }

    protected final boolean passesEmitThreshold(double conf, boolean bestGuessIsRef) {
        return (((StandardCallerArgumentCollection)this.configuration).outputMode == OutputMode.EMIT_ALL_CONFIDENT_SITES || !bestGuessIsRef) && this.passesCallThreshold(conf);
    }

    protected final boolean passesCallThreshold(double conf) {
        return conf >= ((StandardCallerArgumentCollection)this.configuration).genotypeArgs.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    protected Map<String, Object> composeCallAttributes(VariantContext vc, List<Integer> alleleCountsofMLE, AFCalculationResult AFresult, List<Allele> allAllelesToUse, GenotypesContext genotypes) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (!alleleCountsofMLE.isEmpty()) {
            attributes.put("MLEAC", alleleCountsofMLE);
            List<Double> MLEfrequencies = this.calculateMLEAlleleFrequencies(alleleCountsofMLE, genotypes);
            attributes.put("MLEAF", MLEfrequencies);
        }
        if (this.doAlleleSpecificCalcs) {
            ArrayList<Integer> perAlleleQuals = new ArrayList<Integer>();
            if (AFresult.getAllelesUsedInGenotyping().size() > 2) {
                for (Allele a : allAllelesToUse) {
                    if (!a.isNonReference()) continue;
                    perAlleleQuals.add((int)Math.round(AFresult.getLog10PosteriorOfAlleleAbsent(a) * -10.0));
                }
            } else {
                perAlleleQuals.add((int)Math.round(AFresult.log10ProbOnlyRefAlleleExists() * -10.0));
            }
            attributes.put("AS_QUAL", perAlleleQuals.stream().mapToInt(q -> Math.round(q.intValue())).boxed().collect(Collectors.toList()));
        }
        if (((StandardCallerArgumentCollection)this.configuration).genotypeArgs.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED) {
            attributes.put("NDA", vc.getAlternateAlleles().size());
        }
        return attributes;
    }

    private List<Double> calculateMLEAlleleFrequencies(List<Integer> alleleCountsofMLE, GenotypesContext genotypes) {
        long AN = genotypes.stream().flatMap(g -> g.getAlleles().stream()).filter(Allele::isCalled).count();
        return alleleCountsofMLE.stream().map(AC -> Math.min(1.0, (double)AC.intValue() / (double)AN)).collect(Collectors.toList());
    }

    public double calculateSingleSampleRefVsAnyActiveStateProfileValue(double[] log10GenotypeLikelihoods) {
        Utils.nonNull(log10GenotypeLikelihoods, "the input likelihoods cannot be null");
        return this.alleleFrequencyCalculator.calculateSingleSampleBiallelicNonRefPosterior(log10GenotypeLikelihoods, true);
    }

    private static class OutputAlleleSubset {
        private final List<Allele> alleles;
        private final boolean siteIsMonomorphic;
        private final List<Integer> mleCounts;

        private OutputAlleleSubset(List<Allele> alleles, List<Integer> mleCounts, boolean siteIsMonomorphic) {
            Utils.nonNull(alleles, "alleles");
            Utils.nonNull(mleCounts, "mleCounts");
            this.siteIsMonomorphic = siteIsMonomorphic;
            this.alleles = alleles;
            this.mleCounts = mleCounts;
        }

        private List<Allele> outputAlleles(Allele referenceAllele) {
            return Stream.concat(Stream.of(referenceAllele), this.alleles.stream()).collect(Collectors.toList());
        }

        public List<Integer> alternativeAlleleMLECounts() {
            return this.mleCounts;
        }
    }
}

