/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;

public final class GenotypingLikelihoods<A extends Allele>
implements SampleList,
AlleleList<A> {
    private final GenotypeLikelihoods[] likelihoods;
    private final PloidyModel ploidyModel;
    private final AlleleList<A> alleles;

    GenotypingLikelihoods(AlleleList<A> alleles, PloidyModel ploidyModel, List<GenotypeLikelihoods> likelihoods) {
        Utils.validateArg(ploidyModel.numberOfSamples() == likelihoods.size(), "there must be exactly one likelihood set for each sample");
        this.likelihoods = Utils.nonNull(likelihoods, "the likelihood collection cannot be null").toArray(new GenotypeLikelihoods[likelihoods.size()]);
        Utils.containsNoNull(likelihoods, "no genotype likelihood is allowed to be null");
        this.alleles = Utils.nonNull(alleles, "allele list cannot be null");
        this.ploidyModel = Utils.nonNull(ploidyModel, "the ploidy model cannot be null");
    }

    @Override
    public int numberOfSamples() {
        return this.ploidyModel.numberOfSamples();
    }

    @Override
    public int indexOfSample(String sample) {
        return this.ploidyModel.indexOfSample(sample);
    }

    @Override
    public String getSample(int sampleIndex) {
        return this.ploidyModel.getSample(sampleIndex);
    }

    public int samplePloidy(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.numberOfSamples());
        return this.ploidyModel.samplePloidy(sampleIndex);
    }

    public GenotypeLikelihoods sampleLikelihoods(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.numberOfSamples());
        return this.likelihoods[sampleIndex];
    }

    @Override
    public int numberOfAlleles() {
        return this.alleles.numberOfAlleles();
    }

    @Override
    public int indexOfAllele(A allele) {
        Utils.nonNull(allele);
        return this.alleles.indexOfAllele(allele);
    }

    @Override
    public A getAllele(int index) {
        Utils.validIndex(index, this.numberOfAlleles());
        return this.alleles.getAllele(index);
    }
}

