/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import java.util.Arrays;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;

public final class HeterogeneousPloidyModel
implements PloidyModel {
    private final SampleList sampleList;
    private final int[] ploidies;
    private final int ploidySum;
    private final boolean isHomogeneous;

    public HeterogeneousPloidyModel(SampleList sampleList, int[] ploidies) {
        this.sampleList = Utils.nonNull(sampleList, "the sample list cannot be null");
        this.ploidies = (int[])Utils.nonNull(ploidies, "the ploidies cannot be null").clone();
        Utils.validateArg(sampleList.numberOfSamples() == ploidies.length, "sample-list and ploidy array length must match");
        Arrays.stream(ploidies).forEach(p -> Utils.validateArg(p >= 0, "no ploidy can be less than 0"));
        this.ploidySum = (int)MathUtils.sum(ploidies);
        this.isHomogeneous = ploidies.length == 0 || Arrays.stream(ploidies).allMatch(p -> p == ploidies[0]);
    }

    @Override
    public int samplePloidy(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.ploidies.length);
        return this.ploidies[sampleIndex];
    }

    @Override
    public boolean isHomogeneous() {
        return this.isHomogeneous;
    }

    @Override
    public int totalPloidy() {
        return this.ploidySum;
    }

    @Override
    public int numberOfSamples() {
        return this.ploidies.length;
    }

    @Override
    public int indexOfSample(String sample) {
        Utils.nonNull(sample);
        return this.sampleList.indexOfSample(sample);
    }

    @Override
    public String getSample(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.numberOfSamples());
        return this.sampleList.getSample(sampleIndex);
    }
}

