/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;

public final class HomogeneousPloidyModel
implements PloidyModel {
    private SampleList sampleList;
    private final int ploidy;

    public HomogeneousPloidyModel(SampleList sampleList, int ploidy) {
        Utils.nonNull(sampleList);
        Utils.validateArg(ploidy > 0, "does not support negative ploidy");
        this.ploidy = ploidy;
        this.sampleList = sampleList;
    }

    @Override
    public int numberOfSamples() {
        return this.sampleList.numberOfSamples();
    }

    @Override
    public String getSample(int index) {
        Utils.validIndex(index, this.numberOfSamples());
        return this.sampleList.getSample(index);
    }

    @Override
    public int indexOfSample(String sample) {
        Utils.nonNull(sample);
        return this.sampleList.indexOfSample(sample);
    }

    @Override
    public int samplePloidy(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.numberOfSamples());
        return this.ploidy;
    }

    @Override
    public boolean isHomogeneous() {
        return true;
    }

    @Override
    public int totalPloidy() {
        return this.ploidy * this.sampleList.numberOfSamples();
    }
}

