/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import java.util.ArrayList;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleLikelihoodMatrixMapper;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculator;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingData;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingLikelihoods;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrReferenceAnalyzer;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;
import org.broadinstitute.hellbender.utils.genotyper.AlleleListPermutation;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class IndependentSampleGenotypesModel
implements GenotypingModel {
    private static final int DEFAULT_CACHE_PLOIDY_CAPACITY = 10;
    private static final int DEFAULT_CACHE_ALLELE_CAPACITY = 50;
    private final int cacheAlleleCountCapacity;
    private final int cachePloidyCapacity;
    private GenotypeLikelihoodCalculator[][] likelihoodCalculators;
    private final GenotypeLikelihoodCalculators calculators;

    public IndependentSampleGenotypesModel() {
        this(10, 50);
    }

    public IndependentSampleGenotypesModel(int calculatorCachePloidyCapacity, int calculatorCacheAlleleCapacity) {
        this.cachePloidyCapacity = calculatorCachePloidyCapacity;
        this.cacheAlleleCountCapacity = calculatorCacheAlleleCapacity;
        this.likelihoodCalculators = new GenotypeLikelihoodCalculator[calculatorCachePloidyCapacity][calculatorCacheAlleleCapacity];
        this.calculators = new GenotypeLikelihoodCalculators();
    }

    @Override
    public <A extends Allele> GenotypingLikelihoods<A> calculateLikelihoods(AlleleList<A> genotypingAlleles, GenotypingData<A> data, byte[] paddedReference, int offsetForRefIntoEvent, DragstrReferenceAnalyzer dragstrs) {
        Utils.nonNull(genotypingAlleles, "the allele cannot be null");
        Utils.nonNull(data, "the genotyping data cannot be null");
        AlleleListPermutation<A> permutation = data.permutation(genotypingAlleles);
        AlleleLikelihoodMatrixMapper<A> alleleLikelihoodMatrixMapper = new AlleleLikelihoodMatrixMapper<A>(permutation);
        int sampleCount = data.numberOfSamples();
        PloidyModel ploidyModel = data.ploidyModel();
        ArrayList<GenotypeLikelihoods> genotypeLikelihoods = new ArrayList<GenotypeLikelihoods>(sampleCount);
        int alleleCount = genotypingAlleles.numberOfAlleles();
        GenotypeLikelihoodCalculator likelihoodsCalculator = sampleCount > 0 ? this.getLikelihoodsCalculator(ploidyModel.samplePloidy(0), alleleCount) : null;
        for (int i = 0; i < sampleCount; ++i) {
            int samplePloidy = ploidyModel.samplePloidy(i);
            if (samplePloidy != likelihoodsCalculator.ploidy()) {
                likelihoodsCalculator = this.getLikelihoodsCalculator(samplePloidy, alleleCount);
            }
            LikelihoodMatrix<GATKRead, A> sampleLikelihoods = alleleLikelihoodMatrixMapper.mapAlleles(data.readLikelihoods().sampleMatrix(i));
            genotypeLikelihoods.add(likelihoodsCalculator.genotypeLikelihoods(sampleLikelihoods));
        }
        return new GenotypingLikelihoods<A>(genotypingAlleles, ploidyModel, genotypeLikelihoods);
    }

    private GenotypeLikelihoodCalculator getLikelihoodsCalculator(int samplePloidy, int alleleCount) {
        GenotypeLikelihoodCalculator newOne;
        if (samplePloidy >= this.cachePloidyCapacity || alleleCount >= this.cacheAlleleCountCapacity) {
            return this.calculators.getInstance(samplePloidy, alleleCount);
        }
        GenotypeLikelihoodCalculator result = this.likelihoodCalculators[samplePloidy][alleleCount];
        if (result != null) {
            return result;
        }
        this.likelihoodCalculators[samplePloidy][alleleCount] = newOne = this.calculators.getInstance(samplePloidy, alleleCount);
        return newOne;
    }
}

