/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.StandardCallerArgumentCollection;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.dragstr.DragstrReferenceAnalyzer;
import org.broadinstitute.hellbender.utils.genotyper.GenotypePriorCalculator;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class MinimalGenotypingEngine
extends GenotypingEngine<StandardCallerArgumentCollection> {
    private final DragstrParams dragstrParams;
    private ReferenceContext referenceContext;

    public MinimalGenotypingEngine(StandardCallerArgumentCollection configuration, SampleList samples) {
        this(configuration, samples, false);
    }

    public MinimalGenotypingEngine(StandardCallerArgumentCollection configuration, SampleList samples, boolean doAlleleSpecificCalcs) {
        super(configuration, samples, doAlleleSpecificCalcs);
        this.dragstrParams = null;
    }

    public MinimalGenotypingEngine(StandardCallerArgumentCollection configuration, SampleList samples, boolean doAlleleSpecificCalcs, DragstrParams dragstrParams) {
        super(configuration, samples, doAlleleSpecificCalcs);
        this.dragstrParams = dragstrParams;
    }

    @Override
    protected boolean forceKeepAllele(Allele allele) {
        return this.configuration.annotateAllSitesWithPLs;
    }

    @Override
    protected String callSourceString() {
        return "UG_call";
    }

    @Override
    public VariantContext calculateGenotypes(VariantContext vc) {
        if (this.dragstrParams == null || ((StandardCallerArgumentCollection)this.getConfiguration()).genotypeArgs.dontUseDragstrPriors || !GATKVariantContextUtils.containsInlineIndel(vc) || this.referenceContext == null) {
            GenotypePriorCalculator gpc = GenotypePriorCalculator.assumingHW(this.configuration.genotypeArgs);
            return this.calculateGenotypes(vc, gpc, Collections.emptyList());
        }
        Object limits = this.referenceContext.hasBackingDataSource() ? this.referenceContext.getSequenceRecord() : this.referenceContext.getWindow();
        SimpleInterval interval = new SimpleInterval(vc.getContig(), Math.max(limits.getStart(), vc.getStart() - this.dragstrParams.maximumLengthInBasePairs()), Math.min(limits.getEnd(), vc.getStart() - this.dragstrParams.maximumLengthInBasePairs()));
        byte[] bases = this.referenceContext.getBases(interval);
        int startOffset = vc.getStart() - interval.getStart();
        DragstrReferenceAnalyzer analyzer = DragstrReferenceAnalyzer.of(bases, startOffset, startOffset + 1, this.dragstrParams.maximumPeriod());
        int period = analyzer.period(startOffset);
        int repeats = analyzer.repeatLength(startOffset);
        GenotypePriorCalculator gpc = GenotypePriorCalculator.givenDragstrParams(this.dragstrParams, period, repeats, Math.log10(((StandardCallerArgumentCollection)this.getConfiguration()).genotypeArgs.snpHeterozygosity), 2.0);
        return this.calculateGenotypes(vc, gpc, Collections.emptyList());
    }

    public void setReferenceContext(ReferenceContext ref) {
        this.referenceContext = ref;
    }
}

