/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.DefaultedMap;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.OutputMode;
import org.broadinstitute.hellbender.utils.Utils;

public class StandardCallerArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ArgumentCollection
    public GenotypeCalculationArgumentCollection genotypeArgs = new GenotypeCalculationArgumentCollection();
    @Argument(fullName="contamination-fraction-to-filter", shortName="contamination", doc="Fraction of contamination in sequencing data (for all samples) to aggressively remove", optional=true)
    public double CONTAMINATION_FRACTION = 0.0;
    public static final double DEFAULT_CONTAMINATION_FRACTION = 0.0;
    @Advanced
    @Argument(fullName="contamination-fraction-per-sample-file", shortName="contamination-file", doc="Tab-separated File containing fraction of contamination in sequencing data (per sample) to aggressively remove. Format should be \"<SampleID><TAB><Contamination>\" (Contamination is double) per line; No header.", optional=true)
    public File CONTAMINATION_FRACTION_FILE = null;
    private DefaultedMap<String, Double> sampleContamination;
    private boolean mapHasContaminationSet = false;
    @Argument(fullName="output-mode", doc="Specifies which type of calls we should output", optional=true)
    public OutputMode outputMode = OutputMode.EMIT_VARIANTS_ONLY;
    @Advanced
    @Argument(fullName="all-site-pls", doc="Annotate all sites with PLs", optional=true)
    public boolean annotateAllSitesWithPLs = false;

    public void copyStandardCallerArgsFrom(StandardCallerArgumentCollection other) {
        Utils.nonNull(other);
        this.genotypeArgs = other.genotypeArgs.clone();
        this.CONTAMINATION_FRACTION = other.CONTAMINATION_FRACTION;
        File file = this.CONTAMINATION_FRACTION_FILE = other.CONTAMINATION_FRACTION_FILE != null ? new File(other.CONTAMINATION_FRACTION_FILE.getAbsolutePath()) : null;
        if (other.sampleContamination != null) {
            this.setSampleContamination((Map<String, Double>)other.sampleContamination);
        }
        this.outputMode = other.outputMode;
        this.annotateAllSitesWithPLs = other.annotateAllSitesWithPLs;
    }

    public boolean isSampleContaminationPresent() {
        return this.contaminationFractionIsSet(this.CONTAMINATION_FRACTION) || this.mapHasContaminationSet;
    }

    public Map<String, Double> getSampleContamination() {
        if (this.sampleContamination == null) {
            this.setSampleContamination(Collections.emptyMap());
        }
        return Collections.unmodifiableMap(this.sampleContamination);
    }

    public void setSampleContamination(Map<String, Double> sampleContamination) {
        this.sampleContamination = new DefaultedMap((Object)this.CONTAMINATION_FRACTION);
        this.sampleContamination.putAll(sampleContamination);
        this.mapHasContaminationSet = this.contaminationIsPresentInMap((Map<String, Double>)this.sampleContamination);
    }

    private boolean contaminationFractionIsSet(double fraction) {
        return !Double.isNaN(fraction) && fraction > 0.0;
    }

    private boolean contaminationIsPresentInMap(Map<String, Double> contaminationMap) {
        if (contaminationMap == null) {
            return false;
        }
        for (Map.Entry<String, Double> mapEntry : contaminationMap.entrySet()) {
            if (!this.contaminationFractionIsSet(mapEntry.getValue())) continue;
            return true;
        }
        return false;
    }
}

