/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.genotyper.afcalc;

import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class AFCalculationResult {
    private static final double EPSILON = 1.0E-10;
    private final double log10PosteriorOfNoVariant;
    private final Map<Allele, Double> log10pRefByAllele;
    private final int[] alleleCountsOfMLE;
    private final List<Allele> allelesUsedInGenotyping;

    public AFCalculationResult(int[] alleleCountsOfMLE, List<Allele> allelesUsedInGenotyping, double log10PosteriorOfNoVariant, Map<Allele, Double> log10pRefByAllele) {
        Utils.nonNull(alleleCountsOfMLE, "alleleCountsOfMLE cannot be null");
        Utils.nonNull(log10pRefByAllele, "log10pRefByAllele cannot be null");
        Utils.nonNull(allelesUsedInGenotyping, "allelesUsedInGenotyping cannot be null");
        Utils.validateArg(MathUtils.isValidLog10Probability(log10PosteriorOfNoVariant), "log10 posterior must be a valid log probability");
        if (allelesUsedInGenotyping.isEmpty()) {
            throw new IllegalArgumentException("allelesUsedInGenotyping must be non-null list of at least 1 value " + allelesUsedInGenotyping);
        }
        if (alleleCountsOfMLE.length != allelesUsedInGenotyping.size() - 1) {
            throw new IllegalArgumentException("alleleCountsOfMLE.length " + alleleCountsOfMLE.length + " != allelesUsedInGenotyping.size() " + allelesUsedInGenotyping.size());
        }
        if (log10pRefByAllele.size() != allelesUsedInGenotyping.size() - 1) {
            throw new IllegalArgumentException("log10pRefByAllele has the wrong number of elements: log10pRefByAllele " + log10pRefByAllele + " but allelesUsedInGenotyping " + allelesUsedInGenotyping);
        }
        if (!allelesUsedInGenotyping.containsAll(log10pRefByAllele.keySet())) {
            throw new IllegalArgumentException("log10pRefByAllele doesn't contain all of the alleles used in genotyping: log10pRefByAllele " + log10pRefByAllele + " but allelesUsedInGenotyping " + allelesUsedInGenotyping);
        }
        this.alleleCountsOfMLE = (int[])alleleCountsOfMLE.clone();
        this.allelesUsedInGenotyping = Collections.unmodifiableList(new ArrayList<Allele>(allelesUsedInGenotyping));
        this.log10PosteriorOfNoVariant = log10PosteriorOfNoVariant;
        this.log10pRefByAllele = Collections.unmodifiableMap(new LinkedHashMap<Allele, Double>(log10pRefByAllele));
    }

    public int[] getAlleleCountsOfMLE() {
        return (int[])this.alleleCountsOfMLE.clone();
    }

    public int getAlleleCountAtMLE(Allele allele) {
        Utils.nonNull(allele);
        Utils.validate(allele.isNonReference(), () -> "Cannot get the alt allele index for reference allele " + allele);
        int indexInAllAllelesIncludingRef = this.allelesUsedInGenotyping.indexOf(allele);
        Utils.validateArg(indexInAllAllelesIncludingRef != -1, () -> "could not find allele " + allele + " in " + this.allelesUsedInGenotyping);
        int indexInAltAlleles = indexInAllAllelesIncludingRef - 1;
        return this.alleleCountsOfMLE[indexInAltAlleles];
    }

    public List<Allele> getAllelesUsedInGenotyping() {
        return this.allelesUsedInGenotyping;
    }

    public double log10ProbOnlyRefAlleleExists() {
        return this.log10PosteriorOfNoVariant;
    }

    public double log10ProbVariantPresent() {
        return MathUtils.log10OneMinusPow10(this.log10PosteriorOfNoVariant);
    }

    public String toString() {
        LinkedList<String> byAllele = new LinkedList<String>();
        for (Allele a : this.allelesUsedInGenotyping) {
            if (!a.isNonReference()) continue;
            byAllele.add(String.format("%s => MLE %d / posterior %.2f", a, this.getAlleleCountAtMLE(a), this.getLog10PosteriorOfAlleleAbsent(a)));
        }
        return String.format("AFCalc%n\t\tlog10PosteriorOfVariant=%.2f%n\t\t%s", this.log10ProbVariantPresent(), Utils.join("\n\t\t", byAllele));
    }

    public boolean passesThreshold(Allele allele, double phredScaleQualThreshold) {
        Utils.nonNull(allele);
        return this.getLog10PosteriorOfAlleleAbsent(allele) + 1.0E-10 < QualityUtils.qualToErrorProbLog10(phredScaleQualThreshold);
    }

    public double getLog10PosteriorOfAlleleAbsent(Allele allele) {
        Utils.nonNull(allele);
        Double log10pNonRef = this.log10pRefByAllele.get(allele);
        Utils.nonNull(log10pNonRef, "Unknown allele " + allele);
        return log10pNonRef;
    }
}

