/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.gnarlyGenotyper;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBArgumentCollection;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_QualByDepth;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.gnarlyGenotyper.GnarlyGenotyperEngine;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@CommandLineProgramProperties(summary="Perform \"quick and dirty\" joint genotyping on one or more samples pre-called with HaplotypeCaller", oneLineSummary="Perform \"quick and dirty\" joint genotyping on one or more samples pre-called with HaplotypeCaller", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
@BetaFeature
public final class GnarlyGenotyper
extends VariantWalker {
    public static final int PIPELINE_MAX_ALT_COUNT = 6;
    private static final OneShotLogger warning = new OneShotLogger(GnarlyGenotyper.class);
    private static final boolean SUMMARIZE_PLs = false;
    private static final boolean CALL_GENOTYPES = true;
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written", optional=false)
    private GATKPath outputFile;
    @Argument(fullName="output-database-name", shortName="output-db", doc="File to which the sites-only annotation database derived from these input samples should be written", optional=true)
    private GATKPath outputDbName = null;
    @ArgumentCollection
    private GenotypeCalculationArgumentCollection genotypeArgs = new GenotypeCalculationArgumentCollection();
    @Argument(fullName="keep-all-sites", doc="Retain low quality and non-variant sites, applying appropriate filters", optional=true)
    private boolean keepAllSites = false;
    @Advanced
    @Argument(fullName="only-output-calls-starting-in-intervals", doc="Restrict variant output to sites that start within provided intervals", optional=true)
    private boolean onlyOutputCallsStartingInIntervals = false;
    @Argument(fullName="merge-input-intervals", shortName="merge-input-intervals", doc="Boolean flag to read in all data in between intervals.  Improves performance reading from GenomicsDB using large lists of +intervals, as in exome sequencing, especially if GVCF data only exists for specified intervals.")
    private boolean mergeInputIntervals = false;
    @Hidden
    @Argument(fullName="strip-allele-specific-annotations", shortName="strip-as", doc="Remove raw AS values and don't calculate finalized values")
    private boolean stripASAnnotations = false;
    @ArgumentCollection
    private GenomicsDBArgumentCollection genomicsdbArgs = new GenomicsDBArgumentCollection();
    @ArgumentCollection
    private final DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    private VariantContextWriter vcfWriter;
    private VariantContextWriter annotationDatabaseWriter = null;
    private GnarlyGenotyperEngine genotyperEngine;
    private final RMSMappingQuality mqCalculator = RMSMappingQuality.getInstance();
    private final Set<Class<? extends InfoFieldAnnotation>> allAlleleSpecificAnnotations = new HashSet<Class<? extends InfoFieldAnnotation>>();
    private List<SimpleInterval> intervals;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    protected List<SimpleInterval> transformTraversalIntervals(List<SimpleInterval> getIntervals, SAMSequenceDictionary sequenceDictionary) {
        if (this.mergeInputIntervals) {
            return IntervalUtils.getSpanningIntervals(getIntervals, sequenceDictionary);
        }
        return getIntervals;
    }

    @Override
    protected GenomicsDBOptions getGenomicsDBOptions() {
        if (this.genomicsDBOptions == null) {
            this.genomicsdbArgs.callGenotypes = true;
            this.genomicsdbArgs.maxDiploidAltAllelesThatCanBeGenotyped = 6;
            this.genomicsDBOptions = new GenomicsDBOptions(this.referenceArguments.getReferencePath(), this.genomicsdbArgs, this.genotypeArgs);
        }
        return this.genomicsDBOptions;
    }

    @Override
    public void onTraversalStart() {
        VCFHeader inputVCFHeader = this.getHeaderForVariants();
        if (this.onlyOutputCallsStartingInIntervals && !this.intervalArgumentCollection.intervalsSpecified()) {
            throw new CommandLineException.MissingArgument("-L or -XL", "Intervals are required if --only-output-calls-starting-in-intervals was specified.");
        }
        this.intervals = this.intervalArgumentCollection.intervalsSpecified() ? this.intervalArgumentCollection.getIntervals(this.getBestAvailableSequenceDictionary()) : Collections.emptyList();
        IndexedSampleList samples = new IndexedSampleList(inputVCFHeader.getGenotypeSamples());
        this.setupVCFWriter(inputVCFHeader, samples);
        this.genotyperEngine = new GnarlyGenotyperEngine(this.keepAllSites, this.genotypeArgs.MAX_ALTERNATE_ALLELES, false, this.stripASAnnotations);
        Reflections reflections = new Reflections("org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific", new Scanner[0]);
        this.allAlleleSpecificAnnotations.addAll(reflections.getSubTypesOf(AS_StrandBiasTest.class));
        this.allAlleleSpecificAnnotations.addAll(reflections.getSubTypesOf(AS_RankSumTest.class));
        this.allAlleleSpecificAnnotations.add(AS_RMSMappingQuality.class);
        this.allAlleleSpecificAnnotations.add(AS_QualByDepth.class);
    }

    private void setupVCFWriter(VCFHeader inputVCFHeader, SampleList samples) {
        LinkedHashSet<Object> headerLines = new LinkedHashSet<Object>(inputVCFHeader.getMetaDataInInputOrder());
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        headerLines.removeIf(vcfHeaderLine -> vcfHeaderLine.getKey().startsWith("GVCFBlock"));
        headerLines.add(GATKVCFHeaderLines.getFilterLine("LowQual"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AC"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AF"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AN"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AN"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("AC_adj"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("FS"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("SOR"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("SB_TABLE"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("ExcessHet"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("QD"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"MQ"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"DP"));
        if (inputVCFHeader.hasInfoLine("AS_QUAL") || inputVCFHeader.hasInfoLine("AS_QUALapprox")) {
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_AltDP"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_BaseQRankSum"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_FS"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_MQ"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_MQRankSum"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_QD"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_ReadPosRankSum"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_SOR"));
        }
        if (this.dbsnp.dbsnp != null) {
            VCFStandardHeaderLines.addStandardInfoLines(headerLines, (boolean)true, (String[])new String[]{"DB"});
        }
        this.vcfWriter = this.createVCFWriter(this.outputFile);
        if (this.outputDbName != null) {
            this.annotationDatabaseWriter = this.createVCFWriter(this.outputDbName);
        }
        Set<String> sampleNameSet = samples.asSetOfSamples();
        headerLines.add(GATKVCFHeaderLines.getInfoLine("RAW_GT_COUNT"));
        VCFHeader vcfHeader = new VCFHeader(headerLines, new TreeSet<String>(sampleNameSet));
        VCFHeader dbHeader = new VCFHeader(headerLines);
        this.vcfWriter.writeHeader(vcfHeader);
        if (this.outputDbName != null) {
            this.annotationDatabaseWriter.writeHeader(dbHeader);
        }
    }

    @Override
    public void apply(VariantContext variant, ReadsContext reads, ReferenceContext ref, FeatureContext features) {
        VariantContext finalizedVC;
        SimpleInterval variantStart = new SimpleInterval(variant.getContig(), variant.getStart(), variant.getStart());
        if (!variant.isVariant() || !GATKVariantContextUtils.isProperlyPolymorphic(variant) || variant.getAttributeAsInt("DP", 0) == 0 || this.onlyOutputCallsStartingInIntervals && !this.intervals.stream().anyMatch(interval -> interval.contains(variantStart))) {
            if (this.keepAllSites) {
                VariantContextBuilder builder = new VariantContextBuilder(this.mqCalculator.finalizeRawMQ(variant));
                builder.filter("LowQual");
                builder.attribute("AC_adj", (Object)0);
                this.vcfWriter.add(builder.make());
            }
            return;
        }
        if (!variant.hasAttribute("QUALapprox")) {
            warning.warn("At least one variant cannot be genotyped because it is missing the QUALapproxkey assigned by the ReblockGVCFs tool. GnarlyGenotyper output may be empty.");
            return;
        }
        if (this.annotationDatabaseWriter != null) {
            VariantContextBuilder annotationDBBuilder = new VariantContextBuilder(variant);
            finalizedVC = this.genotyperEngine.finalizeGenotype(variant, annotationDBBuilder);
            this.annotationDatabaseWriter.add(annotationDBBuilder.make());
        } else {
            finalizedVC = this.genotyperEngine.finalizeGenotype(variant);
        }
        if (finalizedVC != null && (!this.onlyOutputCallsStartingInIntervals || this.intervals.stream().anyMatch(interval -> interval.contains(variantStart)))) {
            this.vcfWriter.add(finalizedVC);
        }
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
        if (this.annotationDatabaseWriter != null) {
            this.annotationDatabaseWriter.close();
        }
    }
}

