/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.gnarlyGenotyper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.ExcessHet;
import org.broadinstitute.hellbender.tools.walkers.annotator.FisherStrand;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandOddsRatio;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_QualByDepth;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAlleleCounts;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculator;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.utils.GenotypeCounts;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class GnarlyGenotyperEngine {
    private static final double INDEL_QUAL_THRESHOLD = 30.0 - 10.0 * Math.log10(1.25E-4);
    private static final double SNP_QUAL_THRESHOLD = 30.0 - 10.0 * Math.log10(0.001);
    private static final int ASSUMED_PLOIDY = 2;
    private static final RMSMappingQuality mqCalculator = RMSMappingQuality.getInstance();
    private int[] likelihoodSizeCache;
    private final ArrayList<GenotypeLikelihoodCalculator> glcCache = new ArrayList();
    private Set<Class<? extends InfoFieldAnnotation>> allASAnnotations;
    private final int maxAltAllelesToOutput;
    private final boolean summarizePls;
    private final boolean keepAllSites;
    private final boolean stripASAnnotations;

    public GnarlyGenotyperEngine(boolean keepAllSites, int maxAltAllelesToOutput, boolean summarizePls, boolean stripASAnnotations) {
        this.maxAltAllelesToOutput = maxAltAllelesToOutput;
        this.summarizePls = summarizePls;
        this.keepAllSites = keepAllSites;
        this.stripASAnnotations = stripASAnnotations;
        if (!summarizePls) {
            GenotypeLikelihoodCalculators GLCprovider = new GenotypeLikelihoodCalculators();
            this.likelihoodSizeCache = new int[maxAltAllelesToOutput + 1 + 1];
            this.glcCache.add(null);
            Iterator iterator = IntStream.rangeClosed(1, maxAltAllelesToOutput + 1).boxed().collect(Collectors.toList()).iterator();
            while (iterator.hasNext()) {
                int numAlleles = (Integer)iterator.next();
                this.likelihoodSizeCache[numAlleles] = GenotypeLikelihoods.numLikelihoods((int)numAlleles, (int)2);
                this.glcCache.add(numAlleles, GLCprovider.getInstance(2, numAlleles));
            }
        }
        Reflections reflections = new Reflections("org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific", new Scanner[0]);
        this.allASAnnotations = reflections.getSubTypesOf(InfoFieldAnnotation.class);
        this.allASAnnotations.addAll(reflections.getSubTypesOf(AS_StrandBiasTest.class));
        this.allASAnnotations.addAll(reflections.getSubTypesOf(AS_RankSumTest.class));
    }

    public VariantContext finalizeGenotype(VariantContext variant) {
        return this.finalizeGenotype(variant, null);
    }

    public VariantContext finalizeGenotype(VariantContext variant, VariantContextBuilder annotationDBBuilder) {
        ReducibleAnnotation ann;
        InfoFieldAnnotation annotation;
        boolean removeNonRef;
        List<Allele> targetAlleles;
        double sitePrior;
        double QUALapprox;
        if (variant.hasAttribute("QUALapprox")) {
            QUALapprox = variant.getAttributeAsInt("QUALapprox", 0);
        } else if (variant.hasAttribute("AS_QUALapprox")) {
            List<Integer> alleleSpecificQualList = AS_QualByDepth.parseQualList(variant);
            QUALapprox = alleleSpecificQualList.stream().mapToInt(Integer::intValue).sum();
        } else {
            QUALapprox = 0.0;
        }
        boolean hasSnpAllele = variant.getAlternateAlleles().stream().anyMatch(allele -> allele != Allele.SPAN_DEL && allele.length() == variant.getReference().length());
        boolean isIndel = !hasSnpAllele;
        double d = sitePrior = isIndel ? 1.25E-4 : 0.001;
        if (isIndel && QUALapprox < INDEL_QUAL_THRESHOLD || !isIndel && QUALapprox < SNP_QUAL_THRESHOLD) {
            if (this.keepAllSites) {
                VariantContextBuilder builder = new VariantContextBuilder(mqCalculator.finalizeRawMQ(variant));
                builder.filter("LowQual");
                builder.attribute("AC_adj", (Object)0);
                return builder.make();
            }
            return null;
        }
        VariantContext vcWithMQ = mqCalculator.finalizeRawMQ(variant);
        VariantContextBuilder vcfBuilder = new VariantContextBuilder(vcWithMQ);
        HashMap annotationsToBeModified = new HashMap(vcWithMQ.getAttributes());
        for (Class<? extends InfoFieldAnnotation> c : this.allASAnnotations) {
            try {
                ReducibleAnnotation ann2;
                InfoFieldAnnotation annotation2 = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(annotation2 instanceof AS_StandardAnnotation) || !(annotation2 instanceof ReducibleAnnotation) || !variant.hasAttribute((ann2 = (ReducibleAnnotation)((Object)annotation2)).getPrimaryRawKey()) || this.stripASAnnotations) continue;
                Map<String, Object> finalValue = ann2.finalizeRawData(vcfBuilder.make(), variant);
                finalValue.forEach((key, value) -> annotationsToBeModified.put(key, value));
                if (annotationDBBuilder == null) continue;
                annotationDBBuilder.attribute(ann2.getPrimaryRawKey(), variant.getAttribute(ann2.getPrimaryRawKey()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Something went wrong: ", e);
            }
        }
        vcfBuilder.attributes(annotationsToBeModified);
        if (variant.hasAttribute("VarDP")) {
            int variantDP = variant.getAttributeAsInt("VarDP", 0);
            double QD = QUALapprox / (double)variantDP;
            vcfBuilder.attribute("QD", (Object)QD).log10PError(QUALapprox / -10.0 - Math.log10(sitePrior));
        }
        if (!this.keepAllSites) {
            vcfBuilder.rmAttribute("QUALapprox");
        }
        int[] SBsum = new int[]{0, 0, 0, 0};
        if (variant.getAlleles().contains(Allele.NON_REF_ALLELE)) {
            targetAlleles = variant.getAlleles().subList(0, variant.getAlleles().size() - 1);
            removeNonRef = true;
        } else {
            targetAlleles = variant.getAlleles();
            removeNonRef = false;
        }
        HashMap<Allele, Integer> alleleCountMap = new HashMap<Allele, Integer>();
        for (Allele a : targetAlleles) {
            alleleCountMap.put(a, 0);
        }
        int[] rawGenotypeCounts = new int[3];
        GenotypesContext calledGenotypes = this.iterateOnGenotypes(variant, targetAlleles, alleleCountMap, SBsum, removeNonRef, this.summarizePls, variant.hasAttribute("RAW_GT_COUNT") ? null : rawGenotypeCounts);
        Integer numCalledAlleles = 0;
        if (variant.hasGenotypes()) {
            for (Allele allele2 : targetAlleles) {
                numCalledAlleles = numCalledAlleles + (Integer)alleleCountMap.get(allele2);
            }
            ArrayList targetAlleleCounts = new ArrayList();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (Allele a : targetAlleles) {
                if (a.isReference()) continue;
                targetAlleleCounts.add(alleleCountMap.get(a));
                arrayList.add((double)((Integer)alleleCountMap.get(a)).intValue() / (double)numCalledAlleles.intValue());
            }
            vcfBuilder.attribute("AC", targetAlleleCounts.size() == 1 ? targetAlleleCounts.get(0) : targetAlleleCounts);
            vcfBuilder.attribute("AF", arrayList.size() == 1 ? arrayList.get(0) : arrayList);
            vcfBuilder.attribute("AN", (Object)numCalledAlleles);
            if (annotationDBBuilder != null) {
                annotationDBBuilder.attribute("AC", targetAlleleCounts.size() == 1 ? targetAlleleCounts.get(0) : targetAlleleCounts);
                annotationDBBuilder.attribute("AF", arrayList.size() == 1 ? arrayList.get(0) : arrayList);
                annotationDBBuilder.attribute("AN", (Object)numCalledAlleles);
            }
        } else {
            if (variant.hasAttribute("SB_TABLE")) {
                SBsum = VariantContextGetters.getAttributeAsIntArray(variant, "SB_TABLE", () -> null, 0);
            }
            if (annotationDBBuilder != null) {
                annotationDBBuilder.attribute("AC", variant.getAttribute("AC"));
                annotationDBBuilder.attribute("AF", variant.getAttribute("AF"));
                annotationDBBuilder.attribute("AN", variant.getAttribute("AN"));
            }
        }
        if (variant.hasAttribute("RAW_GT_COUNT") || variant.hasGenotypes()) {
            List gtCounts = variant.hasAttribute("RAW_GT_COUNT") ? variant.getAttributeAsIntList("RAW_GT_COUNT", 0) : Arrays.stream(rawGenotypeCounts).boxed().collect(Collectors.toList());
            int n = Math.max(numCalledAlleles / 2 - (Integer)gtCounts.get(1) - (Integer)gtCounts.get(2), 0);
            gtCounts.set(0, n);
            Pair<Integer, Double> eh = ExcessHet.calculateEH(variant, new GenotypeCounts(((Integer)gtCounts.get(0)).intValue(), ((Integer)gtCounts.get(1)).intValue(), ((Integer)gtCounts.get(2)).intValue()), numCalledAlleles / 2);
            vcfBuilder.attribute("ExcessHet", (Object)String.format("%.4f", eh.getRight()));
            vcfBuilder.rmAttribute("RAW_GT_COUNT");
            if (annotationDBBuilder != null) {
                annotationDBBuilder.attribute("RAW_GT_COUNT", (Object)StringUtils.join(gtCounts, (String)","));
            }
        }
        vcfBuilder.attribute("FS", (Object)FisherStrand.makeValueObjectForAnnotation(FisherStrand.pValueForContingencyTable(StrandBiasTest.decodeSBBS(SBsum))));
        vcfBuilder.attribute("SOR", (Object)StrandOddsRatio.formattedValue(StrandOddsRatio.calculateSOR(StrandBiasTest.decodeSBBS(SBsum))));
        vcfBuilder.genotypes(calledGenotypes);
        if (annotationDBBuilder != null) {
            annotationDBBuilder.attribute("SB_TABLE", (Object)SBsum);
            annotationDBBuilder.noGenotypes();
        }
        for (Class clazz : this.allASAnnotations) {
            try {
                annotation = (InfoFieldAnnotation)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(annotation instanceof AS_StandardAnnotation) || !(annotation instanceof ReducibleAnnotation)) continue;
                ann = (ReducibleAnnotation)((Object)annotation);
                if (variant.hasAttribute(ann.getRawKeyNames().get(0))) {
                    vcfBuilder.attribute(annotation.getKeyNames().get(0), (Object)GnarlyGenotyperEngine.trimASAnnotation(vcfBuilder.make(), targetAlleles, annotation.getKeyNames().get(0)));
                }
                if (this.keepAllSites || !variant.hasAttribute(ann.getRawKeyNames().get(0))) continue;
                vcfBuilder.rmAttribute(ann.getRawKeyNames().get(0));
            }
            catch (Exception e) {
                throw new IllegalStateException("Something went wrong: ", e);
            }
        }
        if (!this.keepAllSites) {
            for (Class clazz : this.allASAnnotations) {
                try {
                    annotation = (InfoFieldAnnotation)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(annotation instanceof AS_StandardAnnotation) || !(annotation instanceof ReducibleAnnotation)) continue;
                    ann = (ReducibleAnnotation)((Object)annotation);
                    for (String rawKey : ann.getRawKeyNames()) {
                        if (!variant.hasAttribute(rawKey)) continue;
                        vcfBuilder.rmAttribute(rawKey);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Something went wrong: ", e);
                }
            }
        }
        if (variant.hasAttribute("AS_VarDP")) {
            vcfBuilder.attribute("AS_AltDP", (Object)AS_QualByDepth.finalizeRawGVCFVarDPValues(variant.getAttributeAsString("AS_VarDP", null), targetAlleles.size()));
            vcfBuilder.rmAttribute("AS_VarDP");
        }
        if (annotationDBBuilder != null) {
            annotationDBBuilder.alleles(targetAlleles);
        }
        vcfBuilder.alleles(targetAlleles);
        return vcfBuilder.make();
    }

    @VisibleForTesting
    protected GenotypesContext iterateOnGenotypes(VariantContext vc, List<Allele> targetAlleles, Map<Allele, Integer> targetAlleleCounts, int[] SBsum, boolean nonRefReturned, boolean summarizePLs, int[] rawGenotypeCounts) {
        int maxAllelesToOutput = this.maxAltAllelesToOutput + 1;
        List inputAllelesWithNonRef = vc.getAlleles();
        if (nonRefReturned && !((Allele)inputAllelesWithNonRef.get(inputAllelesWithNonRef.size() - 1)).equals((Object)Allele.NON_REF_ALLELE)) {
            throw new IllegalStateException("This tool assumes that the NON_REF allele is listed last, as in HaplotypeCaller GVCF output, but that was not the case at position " + vc.getContig() + ":" + vc.getStart() + ".");
        }
        GenotypesContext mergedGenotypes = GenotypesContext.create();
        int newPLsize = -1;
        if (!summarizePLs) {
            int maximumAlleleCount = inputAllelesWithNonRef.size();
            int numConcreteAlts = maximumAlleleCount - 2;
            newPLsize = maximumAlleleCount <= maxAllelesToOutput ? this.likelihoodSizeCache[numConcreteAlts + 1] : GenotypeLikelihoods.numLikelihoods((int)(numConcreteAlts + 1), (int)2);
        }
        for (Genotype g : vc.getGenotypes()) {
            int altCount;
            String name = g.getSampleName();
            if (g.getPloidy() != 2 && !GnarlyGenotyperEngine.isGDBnoCall(g)) {
                throw new UserException.BadInput("This tool assumes diploid genotypes, but sample " + name + " has ploidy " + g.getPloidy() + " at position " + vc.getContig() + ":" + vc.getStart() + ".");
            }
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(g);
            genotypeBuilder.name(name);
            if (GnarlyGenotyperEngine.isGDBnoCall(g) || g.getAllele(0).equals((Object)Allele.NON_REF_ALLELE) || g.getAllele(1).equals((Object)Allele.NON_REF_ALLELE)) {
                genotypeBuilder.alleles(GATKVariantContextUtils.noCallAlleles(2));
            } else if (nonRefReturned) {
                if (g.hasAD()) {
                    int[] AD = GnarlyGenotyperEngine.trimADs(g, targetAlleles.size());
                    genotypeBuilder.AD(AD);
                } else if (g.countAllele(Allele.NON_REF_ALLELE) > 0) {
                    genotypeBuilder.alleles(GATKVariantContextUtils.noCallAlleles(2)).noGQ();
                }
            }
            if (g.hasPL()) {
                if (summarizePLs) {
                    GnarlyGenotyperEngine.summarizePLs(genotypeBuilder, g, vc);
                } else {
                    int[] PLs = GnarlyGenotyperEngine.trimPLs(g, newPLsize);
                    genotypeBuilder.PL(PLs);
                    genotypeBuilder.GQ(MathUtils.secondSmallestMinusSmallest(PLs, 0));
                    this.makeGenotypeCall(genotypeBuilder, GenotypeLikelihoods.fromPLs((int[])PLs).getAsVector(), targetAlleles);
                }
            }
            HashMap attrs = new HashMap(g.getExtendedAttributes());
            attrs.remove("MIN_DP");
            Genotype calledGT = genotypeBuilder.attributes(attrs).make();
            mergedGenotypes.add(calledGT);
            if (g.hasAnyAttribute("SB")) {
                MathUtils.addToArrayInPlace(SBsum, GnarlyGenotyperEngine.getSBFieldAsIntArray(g));
            }
            for (int i = 0; i < 2; ++i) {
                Allele a2 = calledGT.getAllele(i);
                int count = targetAlleleCounts.getOrDefault(a2, 0);
                if (a2.equals((Object)Allele.NO_CALL)) continue;
                targetAlleleCounts.put(a2, count + 1);
            }
            if (rawGenotypeCounts == null) continue;
            int n = altCount = (int)g.getAlleles().stream().filter(a -> !a.isReference()).count();
            rawGenotypeCounts[n] = rawGenotypeCounts[n] + 1;
        }
        return mergedGenotypes;
    }

    @VisibleForTesting
    protected void makeGenotypeCall(GenotypeBuilder gb, double[] genotypeLikelihoods, List<Allele> allelesToUse) {
        int maxAllelesToOutput = this.maxAltAllelesToOutput + 1;
        if (genotypeLikelihoods == null || !GATKVariantContextUtils.isInformative(genotypeLikelihoods)) {
            gb.alleles(GATKVariantContextUtils.noCallAlleles(2)).noGQ();
        } else {
            GenotypeLikelihoodCalculator glCalc;
            int maxLikelihoodIndex = MathUtils.maxElementIndex(genotypeLikelihoods);
            if (allelesToUse.size() <= maxAllelesToOutput) {
                glCalc = this.glcCache.get(allelesToUse.size());
            } else {
                GenotypeLikelihoodCalculators GLCprovider = new GenotypeLikelihoodCalculators();
                glCalc = GLCprovider.getInstance(2, allelesToUse.size());
            }
            GenotypeAlleleCounts alleleCounts = glCalc.genotypeAlleleCountsAt(maxLikelihoodIndex);
            gb.alleles(alleleCounts.asAlleleList(allelesToUse));
            int numAltAlleles = allelesToUse.size() - 1;
            if (numAltAlleles > 0) {
                gb.log10PError(GenotypeLikelihoods.getGQLog10FromLikelihoods((int)maxLikelihoodIndex, (double[])genotypeLikelihoods));
            }
        }
    }

    static void summarizePLs(GenotypeBuilder gb, Genotype g, VariantContext vc) {
        List calledAlleles = g.getAlleles();
        List<Integer> calledAllelePLPositions = GnarlyGenotyperEngine.getPLindicesForAlleles(vc, calledAlleles);
        int[] PLs = g.getPL();
        int ABGQ = Integer.MAX_VALUE;
        int ALTGQ = Integer.MAX_VALUE;
        if (g.isHet()) {
            for (int i : calledAllelePLPositions) {
                if (PLs[i] == 0 || PLs[i] >= ABGQ) continue;
                ABGQ = PLs[i];
            }
        } else {
            for (int i = 0; i < PLs.length; ++i) {
                boolean match1 = false;
                boolean match2 = false;
                if (PLs[i] == 0) continue;
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair PLalleleAltArrayIndexes = GenotypeLikelihoods.getAllelePair((int)i);
                if (calledAllelePLPositions.contains(PLalleleAltArrayIndexes.alleleIndex1)) {
                    match1 = true;
                }
                if (calledAllelePLPositions.contains(PLalleleAltArrayIndexes.alleleIndex2)) {
                    match2 = true;
                }
                if (!match1 && !match2 || PLs[i] >= ABGQ) continue;
                ABGQ = PLs[i];
            }
            if (g.isHomRef()) {
                ALTGQ = ABGQ;
            }
        }
        if (!g.isHomRef()) {
            HashSet<Allele> comparisonAlleles = new HashSet<Allele>(vc.getAlleles());
            if (!g.getAllele(0).isReference()) {
                comparisonAlleles.remove(g.getAllele(0));
                List<Integer> comparisonAllelePLPositions = GnarlyGenotyperEngine.getPLindicesForAlleles(vc, new ArrayList<Allele>(comparisonAlleles));
                for (int i : comparisonAllelePLPositions) {
                    if (PLs[i] >= ALTGQ) continue;
                    ALTGQ = PLs[i];
                }
                comparisonAlleles.add(g.getAllele(0));
            }
            if (!g.getAllele(1).isReference()) {
                comparisonAlleles.remove(g.getAllele(1));
                List<Integer> comparisonAllelePLPositions = GnarlyGenotyperEngine.getPLindicesForAlleles(vc, new ArrayList<Allele>(comparisonAlleles));
                for (int i : comparisonAllelePLPositions) {
                    if (PLs[i] >= ALTGQ) continue;
                    ALTGQ = PLs[i];
                }
            }
        }
        gb.attribute("RGQ", (Object)PLs[0]);
        gb.attribute("ABGQ", (Object)ABGQ);
        gb.attribute("ALTGQ", (Object)ALTGQ);
        gb.noPL();
    }

    private static boolean isGDBnoCall(Genotype g) {
        return g.getPloidy() == 1 && (g.getAllele(0).isReference() || g.getAllele(0).isNoCall());
    }

    private static int[] trimPLs(Genotype g, int newPLsize) {
        int[] oldPLs = g.getPL();
        int[] newPLs = new int[newPLsize];
        System.arraycopy(oldPLs, 0, newPLs, 0, newPLsize);
        return newPLs;
    }

    private static int[] trimADs(Genotype g, int newAlleleNumber) {
        int[] oldADs = g.getAD();
        int[] newADs = new int[newAlleleNumber];
        System.arraycopy(oldADs, 0, newADs, 0, newAlleleNumber);
        return newADs;
    }

    private static String trimASAnnotation(VariantContext variant, List<Allele> targetAlleles, String key) {
        int[] relevantIndices = targetAlleles.stream().filter(a -> !a.isReference()).mapToInt(a -> variant.getAlternateAlleles().indexOf(a)).toArray();
        if (!variant.hasAttribute(key)) {
            return null;
        }
        List<String> annotationEntries = AnnotationUtils.decodeAnyASList(variant.getAttribute(key).toString());
        if (annotationEntries == null) {
            return null;
        }
        ArrayList<String> returnString = new ArrayList<String>();
        for (int i = 0; i < relevantIndices.length; ++i) {
            if (relevantIndices[i] <= annotationEntries.size() - 1) {
                returnString.add(annotationEntries.get(relevantIndices[i]));
                continue;
            }
            returnString.add(".");
        }
        return AnnotationUtils.encodeStringList(returnString);
    }

    private static List<Integer> getPLindicesForAlleles(VariantContext vc, List<Allele> calledAlleles) {
        ArrayList calledAllelePLPositions = new ArrayList();
        for (Allele a : calledAlleles) {
            int[] x = vc.getGLIndicesOfAlternateAllele(a);
            calledAllelePLPositions.addAll(Arrays.stream(x).boxed().collect(Collectors.toList()));
        }
        return calledAllelePLPositions.stream().distinct().collect(Collectors.toList());
    }

    private static int[] getSBFieldAsIntArray(Genotype g) {
        Object sbbsObj = g.getAnyAttribute("SB");
        if (sbbsObj == null) {
            return new int[0];
        }
        if (sbbsObj instanceof String) {
            String[] sbbsStr = ((String)sbbsObj).split(",");
            try {
                return Arrays.stream(sbbsStr).map(String::trim).mapToInt(Integer::parseInt).toArray();
            }
            catch (Exception ex) {
                throw new IllegalStateException("The GnarlyGenotyper tool assumes that input variants have SB FORMAT  fields as a list of integers separated by commas.", ex);
            }
        }
        try {
            ArrayList sbbsList = (ArrayList)sbbsObj;
            return Ints.toArray((Collection)sbbsList);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The GnarlyGenotyper tool assumes that input variants have SB FORMAT fields parsed into ArrayLists.");
        }
    }
}

