/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.LikelihoodEngineArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadThreadingAssemblerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;
import org.broadinstitute.hellbender.utils.haplotype.HaplotypeBAMWriter;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;

public abstract class AssemblyBasedCallerArgumentCollection {
    private static final long serialVersionUID = 1L;
    public static final String USE_FILTERED_READS_FOR_ANNOTATIONS_LONG_NAME = "use-filtered-reads-for-annotations";
    public static final String BAM_OUTPUT_LONG_NAME = "bam-output";
    public static final String BAM_OUTPUT_SHORT_NAME = "bamout";
    public static final String BAM_WRITER_TYPE_LONG_NAME = "bam-writer-type";
    public static final String DONT_USE_SOFT_CLIPPED_BASES_LONG_NAME = "dont-use-soft-clipped-bases";
    public static final String DO_NOT_RUN_PHYSICAL_PHASING_LONG_NAME = "do-not-run-physical-phasing";
    public static final String MAX_MNP_DISTANCE_LONG_NAME = "max-mnp-distance";
    public static final String MAX_MNP_DISTANCE_SHORT_NAME = "mnp-dist";
    public static final String MIN_BASE_QUALITY_SCORE_LONG_NAME = "min-base-quality-score";
    public static final String SMITH_WATERMAN_LONG_NAME = "smith-waterman";
    public static final String FORCE_CALL_ALLELES_LONG_NAME = "alleles";
    public static final String FORCE_CALL_FILTERED_ALLELES_LONG_NAME = "force-call-filtered-alleles";
    public static final String FORCE_CALL_FILTERED_ALLELES_SHORT_NAME = "genotype-filtered-alleles";
    public static final String EMIT_REF_CONFIDENCE_LONG_NAME = "emit-ref-confidence";
    public static final String EMIT_REF_CONFIDENCE_SHORT_NAME = "ERC";
    public static final String ALLELE_EXTENSION_LONG_NAME = "allele-informative-reads-overlap-margin";
    @ArgumentCollection
    public ReadThreadingAssemblerArgumentCollection assemblerArgs = this.getReadThreadingAssemblerArgumentCollection();
    @ArgumentCollection
    public LikelihoodEngineArgumentCollection likelihoodArgs = new LikelihoodEngineArgumentCollection();
    @Advanced
    @Argument(fullName="bam-output", shortName="bamout", doc="File to which assembled haplotypes should be written", optional=true)
    public String bamOutputPath = null;
    @Advanced
    @Argument(fullName="bam-writer-type", doc="Which haplotypes should be written to the BAM", optional=true)
    public HaplotypeBAMWriter.WriterType bamWriterType = HaplotypeBAMWriter.WriterType.CALLED_HAPLOTYPES;
    @Advanced
    @Argument(fullName="dont-use-soft-clipped-bases", doc="Do not analyze soft clipped bases in the reads", optional=true)
    public boolean dontUseSoftClippedBases = false;
    @Argument(fullName="min-base-quality-score", shortName="mbq", doc="Minimum base quality required to consider a base for calling", optional=true)
    public byte minBaseQualityScore = (byte)10;
    @Advanced
    @Argument(fullName="smith-waterman", doc="Which Smith-Waterman implementation to use, generally FASTEST_AVAILABLE is the right choice", optional=true)
    public SmithWatermanAligner.Implementation smithWatermanImplementation = SmithWatermanAligner.Implementation.JAVA;
    @Advanced
    @Argument(fullName="emit-ref-confidence", shortName="ERC", doc="Mode for emitting reference confidence scores (For Mutect2, this is a BETA feature)", optional=true)
    public ReferenceConfidenceMode emitReferenceConfidence = ReferenceConfidenceMode.NONE;
    @Advanced
    @Argument(fullName="max-mnp-distance", shortName="mnp-dist", doc="Two or more phased substitutions separated by this distance or less are merged into MNPs.", optional=true)
    public int maxMnpDistance = this.getDefaultMaxMnpDistance();
    @Argument(fullName="alleles", doc="The set of alleles to force-call regardless of evidence", optional=true)
    public FeatureInput<VariantContext> alleles;
    @Advanced
    @Argument(fullName="force-call-filtered-alleles", shortName="genotype-filtered-alleles", doc="Force-call filtered alleles included in the resource specified by --alleles", optional=true)
    public boolean forceCallFiltered = false;
    @Advanced
    @Argument(fullName="soft-clip-low-quality-ends", doc="If enabled will preserve low-quality read ends as softclips (used for DRAGEN-GATK BQD genotyper model)", optional=true)
    public boolean softClipLowQualityEnds = false;
    @Advanced
    @Argument(fullName="allele-informative-reads-overlap-margin", doc="Likelihood and read-based annotations will only take into consideration reads that overlap the variant or any base no further than this distance expressed in base pairs", optional=true)
    public int informativeReadOverlapMargin = 2;

    public ReadThreadingAssembler createReadThreadingAssembler() {
        ReadThreadingAssembler assemblyEngine = this.assemblerArgs.makeReadThreadingAssembler();
        assemblyEngine.setDebug(this.assemblerArgs.debugAssembly);
        assemblyEngine.setMinBaseQualityToUseInAssembly(this.minBaseQualityScore);
        return assemblyEngine;
    }

    protected abstract ReadThreadingAssemblerArgumentCollection getReadThreadingAssemblerArgumentCollection();

    protected abstract int getDefaultMaxMnpDistance();
}

