/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.tools.walkers.ReferenceConfidenceVariantContextMerger;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyResultSet;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.LikelihoodEngineArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.LocationAndAlleles;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.NearbyKmerErrorCorrector;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.PairHMMLikelihoodCalculationEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.PileupReadErrorCorrector;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadErrorCorrector;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadLikelihoodCalculationEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceModel;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParamUtils;
import org.broadinstitute.hellbender.utils.fragments.FragmentCollection;
import org.broadinstitute.hellbender.utils.fragments.FragmentUtils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.IndexedAlleleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.haplotype.HaplotypeBAMWriter;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadCoordinateComparator;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class AssemblyBasedCallerUtils {
    static final int REFERENCE_PADDING_FOR_ASSEMBLY = 500;
    public static final int NUM_HAPLOTYPES_TO_INJECT_FORCE_CALLING_ALLELES_INTO = 5;
    public static final String SUPPORTED_ALLELES_TAG = "XA";
    public static final String CALLABLE_REGION_TAG = "CR";
    public static final String ALIGNMENT_REGION_TAG = "AR";
    public static final String READ_ORIGINAL_ALIGNMENT_KEY = "originalAlignment";
    public static final Function<Haplotype, Double> HAPLOTYPE_ALIGNMENT_TIEBREAKING_PRIORITY = h -> {
        Cigar cigar = h.getCigar();
        boolean referenceTerm = h.isReference();
        int cigarTerm = cigar == null ? 0 : 1 - cigar.numCigarElements();
        return (double)referenceTerm + (double)cigarTerm;
    };
    public static final int MINIMUM_READ_LENGTH_AFTER_TRIMMING = 10;

    public static Map<GATKRead, GATKRead> realignReadsToTheirBestHaplotype(AlleleLikelihoods<GATKRead, Haplotype> originalReadLikelihoods, Haplotype refHaplotype, Locatable paddedReferenceLoc, SmithWatermanAligner aligner) {
        Collection<AlleleLikelihoods.BestAllele> bestAlleles = originalReadLikelihoods.bestAllelesBreakingTies(HAPLOTYPE_ALIGNMENT_TIEBREAKING_PRIORITY);
        HashMap<GATKRead, GATKRead> result = new HashMap<GATKRead, GATKRead>(bestAlleles.size());
        for (AlleleLikelihoods.BestAllele bestAllele : bestAlleles) {
            GATKRead originalRead = (GATKRead)bestAllele.evidence;
            Haplotype bestHaplotype = (Haplotype)((Object)bestAllele.allele);
            boolean isInformative = bestAllele.isInformative();
            GATKRead realignedRead = AlignmentUtils.createReadAlignedToRef(originalRead, bestHaplotype, refHaplotype, paddedReferenceLoc.getStart(), isInformative, aligner);
            result.put(originalRead, realignedRead);
        }
        return result;
    }

    public static void finalizeRegion(AssemblyRegion region, boolean errorCorrectReads, boolean dontUseSoftClippedBases, byte minTailQuality, SAMFileHeader readsHeader, SampleList samplesList, boolean correctOverlappingBaseQualities, boolean softClipLowQualityEnds) {
        if (region.isFinalized()) {
            return;
        }
        byte minTailQualityToUse = errorCorrectReads ? (byte)6 : (byte)minTailQuality;
        ArrayList<GATKRead> readsToUse = new ArrayList<GATKRead>();
        for (GATKRead originalRead : region.getReads()) {
            GATKRead read = dontUseSoftClippedBases || !ReadUtils.hasWellDefinedFragmentSize(originalRead) ? ReadClipper.hardClipSoftClippedBases(originalRead) : ReadClipper.revertSoftClippedBases(originalRead);
            read = softClipLowQualityEnds ? ReadClipper.softClipLowQualEnds(read, minTailQualityToUse) : ReadClipper.hardClipLowQualEnds(read, minTailQualityToUse);
            if (read.getStart() > read.getEnd() || (read = read.isUnmapped() ? read : ReadClipper.hardClipAdaptorSequence(read)).isEmpty() || read.getCigar().getReadLength() <= 0 || (read = ReadClipper.hardClipToRegion(read, region.getPaddedSpan().getStart(), region.getPaddedSpan().getEnd())).getStart() > read.getEnd() || read.getLength() <= 0 || !read.overlaps(region.getPaddedSpan())) continue;
            readsToUse.add(read == originalRead ? read.copy() : read);
        }
        readsToUse.sort(new ReadCoordinateComparator(readsHeader));
        if (correctOverlappingBaseQualities) {
            AssemblyBasedCallerUtils.cleanOverlappingReadPairs(readsToUse, samplesList, readsHeader, true, OptionalInt.empty(), OptionalInt.empty());
        }
        region.clearReads();
        region.addAll(readsToUse);
        region.setFinalized(true);
    }

    public static void cleanOverlappingReadPairs(List<GATKRead> reads, SampleList samplesList, SAMFileHeader readsHeader, boolean setConflictingToZero, OptionalInt halfOfPcrSnvQual, OptionalInt halfOfPcrIndelQual) {
        Utils.nonNull(reads);
        Utils.nonNull(samplesList);
        Utils.nonNull(halfOfPcrSnvQual);
        Utils.nonNull(halfOfPcrSnvQual);
        for (List<GATKRead> perSampleReadList : AssemblyBasedCallerUtils.splitReadsBySample(samplesList, readsHeader, reads).values()) {
            FragmentCollection<GATKRead> fragmentCollection = FragmentCollection.create(perSampleReadList);
            for (Pair<GATKRead, GATKRead> overlappingPair : fragmentCollection.getOverlappingPairs()) {
                FragmentUtils.adjustQualsOfOverlappingPairedFragments(overlappingPair, setConflictingToZero, halfOfPcrSnvQual, halfOfPcrIndelQual);
            }
        }
    }

    public static Map<String, List<GATKRead>> splitReadsBySample(SampleList samplesList, SAMFileHeader header, Collection<GATKRead> reads) {
        HashMap<String, List<GATKRead>> returnMap = new HashMap<String, List<GATKRead>>();
        for (String sample : samplesList.asListOfSamples()) {
            returnMap.put(sample, new ArrayList());
        }
        for (GATKRead read : reads) {
            ((List)returnMap.get(ReadUtils.getSampleName(read, header))).add(read);
        }
        return returnMap;
    }

    public static Haplotype createReferenceHaplotype(AssemblyRegion region, SimpleInterval paddedReferenceLoc, ReferenceSequenceFile referenceReader) {
        return ReferenceConfidenceModel.createReferenceHaplotype(region, region.getAssemblyRegionReference(referenceReader), paddedReferenceLoc);
    }

    public static SimpleInterval getPaddedReferenceLoc(AssemblyRegion region, int referencePadding, ReferenceSequenceFile referenceReader) {
        int padLeft = Math.max(region.getPaddedSpan().getStart() - referencePadding, 1);
        int padRight = Math.min(region.getPaddedSpan().getEnd() + referencePadding, referenceReader.getSequenceDictionary().getSequence(region.getPaddedSpan().getContig()).getSequenceLength());
        return new SimpleInterval(region.getPaddedSpan().getContig(), padLeft, padRight);
    }

    public static ReadLikelihoodCalculationEngine createLikelihoodCalculationEngine(LikelihoodEngineArgumentCollection likelihoodArgs, boolean handleSoftclips) {
        double log10GlobalReadMismappingRate = likelihoodArgs.phredScaledGlobalReadMismappingRate < 0 ? Double.NEGATIVE_INFINITY : QualityUtils.qualToErrorProbLog10(likelihoodArgs.phredScaledGlobalReadMismappingRate);
        return new PairHMMLikelihoodCalculationEngine((byte)likelihoodArgs.gcpHMM, likelihoodArgs.dontUseDragstrPairHMMScores ? null : DragstrParamUtils.parse(likelihoodArgs.dragstrParams), likelihoodArgs.pairHMMNativeArgs.getPairHMMArgs(), likelihoodArgs.pairHMM, log10GlobalReadMismappingRate, likelihoodArgs.pcrErrorModel, likelihoodArgs.BASE_QUALITY_SCORE_THRESHOLD, likelihoodArgs.enableDynamicReadDisqualification, likelihoodArgs.readDisqualificationThresholdConstant, likelihoodArgs.expectedErrorRatePerBase, !likelihoodArgs.disableSymmetricallyNormalizeAllelesToReference, likelihoodArgs.disableCapReadQualitiesToMapQ, handleSoftclips);
    }

    public static Optional<HaplotypeBAMWriter> createBamWriter(AssemblyBasedCallerArgumentCollection args, boolean createBamOutIndex, boolean createBamOutMD5, SAMFileHeader header) {
        return args.bamOutputPath != null ? Optional.of(new HaplotypeBAMWriter(args.bamWriterType, IOUtils.getPath(args.bamOutputPath), createBamOutIndex, createBamOutMD5, header)) : Optional.empty();
    }

    public static VariantContext makeMergedVariantContext(List<VariantContext> vcs) {
        if (vcs.isEmpty()) {
            return null;
        }
        List<String> haplotypeSources = vcs.stream().map(VariantContext::getSource).collect(Collectors.toList());
        return GATKVariantContextUtils.simpleMerge(vcs, haplotypeSources, GATKVariantContextUtils.FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED, GATKVariantContextUtils.GenotypeMergeType.PRIORITIZE, false);
    }

    public static AssemblyResultSet assembleReads(AssemblyRegion region, List<VariantContext> givenAlleles, AssemblyBasedCallerArgumentCollection argumentCollection, SAMFileHeader header, SampleList sampleList, Logger logger, ReferenceSequenceFile referenceReader, ReadThreadingAssembler assemblyEngine, SmithWatermanAligner aligner, boolean correctOverlappingBaseQualities) {
        AssemblyBasedCallerUtils.finalizeRegion(region, argumentCollection.assemblerArgs.errorCorrectReads, argumentCollection.dontUseSoftClippedBases, (byte)(argumentCollection.minBaseQualityScore - 1), header, sampleList, correctOverlappingBaseQualities, argumentCollection.softClipLowQualityEnds);
        if (argumentCollection.assemblerArgs.debugAssembly) {
            logger.info("Assembling " + region.getSpan() + " with " + region.size() + " reads:    (with overlap region = " + region.getPaddedSpan() + ")");
        }
        byte[] fullReferenceWithPadding = region.getAssemblyRegionReference(referenceReader, 500);
        SimpleInterval paddedReferenceLoc = AssemblyBasedCallerUtils.getPaddedReferenceLoc(region, 500, referenceReader);
        Haplotype refHaplotype = AssemblyBasedCallerUtils.createReferenceHaplotype(region, paddedReferenceLoc, referenceReader);
        ReadErrorCorrector readErrorCorrector = argumentCollection.assemblerArgs.pileupErrorCorrectionLogOdds == Double.NEGATIVE_INFINITY ? (argumentCollection.assemblerArgs.errorCorrectReads ? new NearbyKmerErrorCorrector(argumentCollection.assemblerArgs.kmerLengthForReadErrorCorrection, 6, argumentCollection.assemblerArgs.minObservationsForKmerToBeSolid, argumentCollection.assemblerArgs.debugAssembly, fullReferenceWithPadding) : null) : new PileupReadErrorCorrector(argumentCollection.assemblerArgs.pileupErrorCorrectionLogOdds, header);
        try {
            AssemblyResultSet assemblyResultSet = assemblyEngine.runLocalAssembly(region, refHaplotype, fullReferenceWithPadding, paddedReferenceLoc, readErrorCorrector, header, aligner);
            if (!givenAlleles.isEmpty()) {
                AssemblyBasedCallerUtils.addGivenAlleles(region.getPaddedSpan().getStart(), givenAlleles, argumentCollection.maxMnpDistance, aligner, refHaplotype, assemblyResultSet);
            }
            assemblyResultSet.setDebug(argumentCollection.assemblerArgs.debugAssembly);
            assemblyResultSet.debugDump(logger);
            return assemblyResultSet;
        }
        catch (Exception e) {
            if (argumentCollection.assemblerArgs.captureAssemblyFailureBAM) {
                try (SAMFileWriter writer = ReadUtils.createCommonSAMWriter(new File("assemblyFailure.bam"), null, header, false, false, false);){
                    for (GATKRead read : region.getReads()) {
                        writer.addAlignment(read.convertToSAMRecord(header));
                    }
                }
            }
            throw e;
        }
    }

    @VisibleForTesting
    static void addGivenAlleles(int assemblyRegionStart, List<VariantContext> givenAlleles, int maxMnpDistance, SmithWatermanAligner aligner, Haplotype refHaplotype, AssemblyResultSet assemblyResultSet) {
        int activeRegionStart = refHaplotype.getAlignmentStartHapwrtRef();
        Map<Integer, VariantContext> assembledVariants = assemblyResultSet.getVariationEvents(maxMnpDistance).stream().collect(Collectors.groupingBy(VariantContext::getStart, Collectors.collectingAndThen(Collectors.toList(), AssemblyBasedCallerUtils::makeMergedVariantContext)));
        List<Haplotype> assembledHaplotypes = assemblyResultSet.getHaplotypeList();
        for (VariantContext givenVC : givenAlleles) {
            List unassembledGivenAlleles;
            Allele longerRef;
            VariantContext assembledVC = assembledVariants.get(givenVC.getStart());
            int givenVCRefLength = givenVC.getReference().length();
            Allele allele = longerRef = assembledVC == null || givenVCRefLength > assembledVC.getReference().length() ? givenVC.getReference() : assembledVC.getReference();
            if (assembledVC == null) {
                unassembledGivenAlleles = givenVC.getAlternateAlleles();
            } else {
                HashSet<Allele> assembledAlleleSet = new HashSet<Allele>(longerRef.length() == assembledVC.getReference().length() ? assembledVC.getAlternateAlleles() : ReferenceConfidenceVariantContextMerger.remapAlleles(assembledVC, longerRef));
                HashSet<Allele> givenAlleleSet = new HashSet<Allele>(longerRef.length() == givenVCRefLength ? givenVC.getAlternateAlleles() : ReferenceConfidenceVariantContextMerger.remapAlleles(givenVC, longerRef));
                unassembledGivenAlleles = givenAlleleSet.stream().filter(a -> !assembledAlleleSet.contains(a)).collect(Collectors.toList());
            }
            List unassembledNonSymbolicAlleles = unassembledGivenAlleles.stream().filter(a -> {
                byte[] bases = a.getBases();
                return !Allele.wouldBeNoCallAllele((byte[])bases) && !Allele.wouldBeNullAllele((byte[])bases) && !Allele.wouldBeStarAllele((byte[])bases) && !Allele.wouldBeSymbolicAllele((byte[])bases);
            }).collect(Collectors.toList());
            List<Haplotype> baseHaplotypes = unassembledNonSymbolicAlleles.isEmpty() ? Collections.emptyList() : assembledHaplotypes.stream().sorted(Comparator.comparingInt(hap -> hap.isReference() ? 1 : 0).thenComparingDouble(hap -> hap.getScore()).reversed()).limit(5L).collect(Collectors.toList());
            for (Allele givenAllele : unassembledNonSymbolicAlleles) {
                for (Haplotype baseHaplotype : baseHaplotypes) {
                    Haplotype insertedHaplotype;
                    if (baseHaplotype.getEventMap() != null && baseHaplotype.getEventMap().getVariantContexts().stream().anyMatch(vc -> vc.overlaps((Locatable)givenVC)) || (insertedHaplotype = baseHaplotype.insertAllele(longerRef, givenAllele, activeRegionStart + givenVC.getStart() - assemblyRegionStart, givenVC.getStart())) == null) continue;
                    Cigar cigar = CigarUtils.calculateCigar(refHaplotype.getBases(), insertedHaplotype.getBases(), aligner, SWOverhangStrategy.INDEL);
                    insertedHaplotype.setCigar(cigar);
                    insertedHaplotype.setGenomeLocation(refHaplotype.getGenomeLocation());
                    insertedHaplotype.setAlignmentStartHapwrtRef(activeRegionStart);
                    assemblyResultSet.add(insertedHaplotype);
                }
            }
        }
        assemblyResultSet.regenerateVariationEvents(maxMnpDistance);
    }

    public static void annotateReadLikelihoodsWithRegions(AlleleLikelihoods<GATKRead, Haplotype> likelihoods, Locatable callableRegion) {
        Collection<AlleleLikelihoods.BestAllele> bestHaplotypes = likelihoods.bestAllelesBreakingTies(HAPLOTYPE_ALIGNMENT_TIEBREAKING_PRIORITY);
        bestHaplotypes.forEach(bh -> ((GATKRead)bh.evidence).setAttribute(ALIGNMENT_REGION_TAG, ((Haplotype)((Object)((Object)bh.allele))).getGenomeLocation().toString()));
        for (AlleleLikelihoods.BestAllele bestHaplotype : bestHaplotypes) {
            GATKRead read = (GATKRead)bestHaplotype.evidence;
            Haplotype haplotype = (Haplotype)((Object)bestHaplotype.allele);
            read.setAttribute(ALIGNMENT_REGION_TAG, haplotype.getGenomeLocation().toString());
        }
        int sampleCount = likelihoods.numberOfSamples();
        for (int i = 0; i < sampleCount; ++i) {
            for (GATKRead read : likelihoods.sampleEvidence(i)) {
                read.setAttribute(CALLABLE_REGION_TAG, callableRegion.toString());
            }
        }
    }

    public static void annotateReadLikelihoodsWithSupportedAlleles(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoodsAllele) {
        AssemblyBasedCallerUtils.annotateReadLikelihoodsWithSupportedAlleles(vc, likelihoodsAllele, Collections::singletonList);
    }

    public static <U extends Locatable> void annotateReadLikelihoodsWithSupportedAlleles(VariantContext vc, AlleleLikelihoods<U, Allele> likelihoodsAllele, Function<U, Collection<GATKRead>> readCollectionFunc) {
        Map<Allele, List> alleleSubset = vc.getAlleles().stream().collect(Collectors.toMap(a -> a, xva$0 -> Arrays.asList(xva$0)));
        AlleleLikelihoods<U, Allele> subsettedLikelihoods = likelihoodsAllele.marginalize(alleleSubset);
        Collection bestAlleles = subsettedLikelihoods.bestAllelesBreakingTies().stream().filter(ba -> ba.isInformative()).collect(Collectors.toList());
        for (AlleleLikelihoods.BestAllele bestAllele : bestAlleles) {
            Object allele = bestAllele.allele;
            for (GATKRead read : readCollectionFunc.apply(bestAllele.evidence)) {
                String prevAllelesString = read.hasAttribute(SUPPORTED_ALLELES_TAG) ? read.getAttributeAsString(SUPPORTED_ALLELES_TAG) + ", " : "";
                String newAllelesString = vc.getContig() + ":" + vc.getStart() + "=" + vc.getAlleleIndex(allele);
                read.setAttribute(SUPPORTED_ALLELES_TAG, prevAllelesString + newAllelesString);
            }
        }
    }

    public static AlleleLikelihoods<GATKRead, Haplotype> createDummyStratifiedReadMap(Haplotype refHaplotype, SampleList samples, SAMFileHeader readsHeader, AssemblyRegion region) {
        return new AlleleLikelihoods<GATKRead, Haplotype>(samples, new IndexedAlleleList((Allele[])new Haplotype[]{refHaplotype}), AssemblyBasedCallerUtils.splitReadsBySample(samples, readsHeader, region.getReads()));
    }

    public static List<ReadPileup> getPileupsOverReference(SAMFileHeader readsHeader, SimpleInterval activeRegionSpan, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods, SampleList samples) {
        ArrayList<GATKRead> reads = new ArrayList<GATKRead>(readLikelihoods.sampleEvidence(0));
        reads.sort(new ReadCoordinateComparator(readsHeader));
        LocusIteratorByState libs = new LocusIteratorByState(reads.iterator(), LocusIteratorByState.NO_DOWNSAMPLING, false, samples.asSetOfSamples(), readsHeader, true);
        int startPos = activeRegionSpan.getStart();
        ArrayList<ReadPileup> pileups = new ArrayList<ReadPileup>(activeRegionSpan.getEnd() - startPos);
        AlignmentContext next = libs.advanceToLocus(startPos, true);
        for (int curPos = startPos; curPos <= activeRegionSpan.getEnd(); ++curPos) {
            if (next != null && next.getLocation().getStart() == curPos) {
                pileups.add(next.getBasePileup());
                next = libs.hasNext() ? libs.next() : null;
                continue;
            }
            pileups.add(new ReadPileup(new SimpleInterval(activeRegionSpan.getContig(), curPos, curPos)));
        }
        return pileups;
    }

    public static List<VariantContext> getVariantContextsFromGivenAlleles(int loc, List<VariantContext> activeAllelesToGenotype, boolean includeSpanningEvents) {
        HashSet<LocationAndAlleles> uniqueLocationsAndAlleles = new HashSet<LocationAndAlleles>();
        ArrayList<VariantContext> results = new ArrayList<VariantContext>();
        int givenAlleleSourceCount = 0;
        for (VariantContext givenAlleleVC : activeAllelesToGenotype) {
            if (givenAlleleVC.getStart() <= loc && givenAlleleVC.getEnd() >= loc) {
                if (!includeSpanningEvents && givenAlleleVC.getStart() != loc) continue;
                int alleleCount = 0;
                for (Allele givenAltAllele : givenAlleleVC.getAlternateAlleles()) {
                    List<Allele> alleleSet = Arrays.asList(givenAlleleVC.getReference(), givenAltAllele);
                    String vcSourceName = "Comp" + givenAlleleSourceCount + "Allele" + alleleCount;
                    VariantContext candidateEventToAdd = new VariantContextBuilder(givenAlleleVC).alleles(alleleSet).genotypes(GenotypesContext.NO_GENOTYPES).source(vcSourceName).make();
                    LocationAndAlleles locationAndAlleles = new LocationAndAlleles(candidateEventToAdd.getStart(), candidateEventToAdd.getAlleles());
                    if (!uniqueLocationsAndAlleles.contains(locationAndAlleles)) {
                        uniqueLocationsAndAlleles.add(locationAndAlleles);
                        results.add(candidateEventToAdd);
                    }
                    ++alleleCount;
                }
            }
            ++givenAlleleSourceCount;
        }
        return results;
    }

    public static List<VariantContext> getVariantContextsFromActiveHaplotypes(int loc, List<Haplotype> haplotypes, boolean includeSpanningEvents) {
        ArrayList<VariantContext> results = new ArrayList<VariantContext>();
        HashSet uniqueLocationsAndAlleles = new HashSet();
        haplotypes.stream().flatMap(h -> Utils.stream(h.getEventMap().getOverlappingEvents(loc))).filter(Objects::nonNull).filter(v -> includeSpanningEvents || v.getStart() == loc).forEach(v -> {
            LocationAndAlleles locationAndAlleles = new LocationAndAlleles(v.getStart(), v.getAlleles());
            if (!uniqueLocationsAndAlleles.contains(locationAndAlleles)) {
                uniqueLocationsAndAlleles.add(locationAndAlleles);
                results.add((VariantContext)v);
            }
        });
        return results;
    }

    public static Map<Allele, List<Haplotype>> createAlleleMapper(VariantContext mergedVC, int loc, List<Haplotype> haplotypes, boolean emitSpanningDels) {
        LinkedHashMap<Allele, List<Haplotype>> result = new LinkedHashMap<Allele, List<Haplotype>>();
        Allele ref = mergedVC.getReference();
        result.put(ref, new ArrayList());
        mergedVC.getAlternateAlleles().stream().filter(a -> !a.isSymbolic()).forEach(a -> {
            List cfr_ignored_0 = result.put((Allele)a, new ArrayList());
        });
        block0: for (Haplotype h : haplotypes) {
            List<VariantContext> spanningEvents = h.getEventMap().getOverlappingEvents(loc);
            if (spanningEvents.isEmpty()) {
                ((List)result.get(ref)).add(h);
                continue;
            }
            for (VariantContext spanningEvent : spanningEvents) {
                if (spanningEvent.getStart() == loc) {
                    Map<Allele, Allele> spanningEventAlleleMappingToMergedVc;
                    Allele remappedSpanningEventAltAllele;
                    if (spanningEvent.getReference().length() == mergedVC.getReference().length()) {
                        if (!result.containsKey(spanningEvent.getAlternateAllele(0))) continue;
                        ((List)result.get(spanningEvent.getAlternateAllele(0))).add(h);
                        continue;
                    }
                    if (spanningEvent.getReference().length() >= mergedVC.getReference().length() || !result.containsKey(remappedSpanningEventAltAllele = (spanningEventAlleleMappingToMergedVc = GATKVariantContextUtils.createAlleleMapping(mergedVC.getReference(), spanningEvent)).get(spanningEvent.getAlternateAllele(0)))) continue;
                    ((List)result.get(remappedSpanningEventAltAllele)).add(h);
                    continue;
                }
                if (emitSpanningDels) {
                    if (!result.containsKey(Allele.SPAN_DEL)) {
                        result.put(Allele.SPAN_DEL, new ArrayList());
                    }
                    ((List)result.get(Allele.SPAN_DEL)).add(h);
                    continue block0;
                }
                ((List)result.get(ref)).add(h);
                continue block0;
            }
        }
        return result;
    }

    public static List<VariantContext> phaseCalls(List<VariantContext> calls, Set<Haplotype> calledHaplotypes) {
        Map<VariantContext, Set<Haplotype>> haplotypeMap = AssemblyBasedCallerUtils.constructHaplotypeMapping(calls, calledHaplotypes);
        Map<VariantContext, Pair<Integer, PhaseGroup>> phaseSetMapping = AssemblyBasedCallerUtils.constructPhaseSetMapping(calls, haplotypeMap);
        int uniqueCounterEndValue = Math.toIntExact(phaseSetMapping.values().stream().map(Pair::getLeft).distinct().count());
        return AssemblyBasedCallerUtils.constructPhaseGroups(calls, phaseSetMapping, uniqueCounterEndValue);
    }

    @VisibleForTesting
    static Map<VariantContext, Set<Haplotype>> constructHaplotypeMapping(List<VariantContext> originalCalls, Set<Haplotype> calledHaplotypes) {
        HashMap<VariantContext, Set<Haplotype>> haplotypeMap = new HashMap<VariantContext, Set<Haplotype>>(originalCalls.size());
        for (VariantContext call : originalCalls) {
            if (!AssemblyBasedCallerUtils.isBiallelicWithOneSiteSpecificAlternateAllele(call)) {
                haplotypeMap.put(call, Collections.emptySet());
                continue;
            }
            Allele alt = AssemblyBasedCallerUtils.getSiteSpecificAlternateAllele(call);
            Predicate<VariantContext> hasThisAlt = vc -> vc.getStart() == call.getStart() && vc.getAlternateAlleles().contains(alt);
            Set hapsWithAllele = calledHaplotypes.stream().filter(h -> h.getEventMap().getVariantContexts().stream().anyMatch(hasThisAlt)).collect(Collectors.toCollection(HashSet::new));
            haplotypeMap.put(call, hapsWithAllele);
        }
        return haplotypeMap;
    }

    private static Allele getSiteSpecificAlternateAllele(VariantContext call) {
        Allele allele = call.getAlternateAlleles().stream().filter(a -> AssemblyBasedCallerUtils.isSiteSpecificAltAllele(a)).findFirst().orElse(null);
        return allele;
    }

    @VisibleForTesting
    static Map<VariantContext, Pair<Integer, PhaseGroup>> constructPhaseSetMapping(List<VariantContext> originalCalls, Map<VariantContext, Set<Haplotype>> haplotypeMap) {
        HashSet haplotypesWithCalledVariants = new HashSet();
        haplotypeMap.values().forEach(haplotypesWithCalledVariants::addAll);
        int totalAvailableHaplotypes = haplotypesWithCalledVariants.size();
        HashMap<VariantContext, Pair<Integer, PhaseGroup>> phaseSetMapping = new HashMap<VariantContext, Pair<Integer, PhaseGroup>>(haplotypeMap.size());
        int numCalls = originalCalls.size();
        int uniqueCounter = 0;
        for (int i = 0; i < numCalls - 1; ++i) {
            VariantContext call = originalCalls.get(i);
            Set<Haplotype> haplotypesWithCall = haplotypeMap.get(call);
            if (haplotypesWithCall.isEmpty()) continue;
            boolean callIsOnAllAltHaps = haplotypesWithCall.size() == totalAvailableHaplotypes;
            HashSet<Haplotype> callHaplotypesAvailableForPhasing = new HashSet<Haplotype>(haplotypesWithCall);
            for (int j = i + 1; j < numCalls; ++j) {
                boolean compIsOnAllAltHaps;
                VariantContext comp = originalCalls.get(j);
                Set<Haplotype> haplotypesWithComp = haplotypeMap.get(comp);
                if (haplotypesWithComp.isEmpty()) continue;
                boolean bl = compIsOnAllAltHaps = haplotypesWithComp.size() == totalAvailableHaplotypes;
                if (haplotypesWithCall.size() == haplotypesWithComp.size() && haplotypesWithCall.containsAll(haplotypesWithComp) || callIsOnAllAltHaps && callHaplotypesAvailableForPhasing.containsAll(haplotypesWithComp) || compIsOnAllAltHaps) {
                    if (!phaseSetMapping.containsKey(call)) {
                        if (phaseSetMapping.containsKey(comp)) {
                            phaseSetMapping.clear();
                            return phaseSetMapping;
                        }
                        phaseSetMapping.put(call, (Pair<Integer, PhaseGroup>)Pair.of((Object)uniqueCounter, (Object)((Object)PhaseGroup.PHASE_01)));
                        phaseSetMapping.put(comp, (Pair<Integer, PhaseGroup>)Pair.of((Object)uniqueCounter, (Object)((Object)PhaseGroup.PHASE_01)));
                        callHaplotypesAvailableForPhasing.retainAll(haplotypesWithComp);
                        ++uniqueCounter;
                        continue;
                    }
                    if (phaseSetMapping.containsKey(comp)) continue;
                    Pair callPhase = (Pair)phaseSetMapping.get(call);
                    phaseSetMapping.put(comp, (Pair<Integer, PhaseGroup>)Pair.of((Object)callPhase.getLeft(), (Object)callPhase.getRight()));
                    continue;
                }
                if (haplotypesWithCall.size() + haplotypesWithComp.size() != totalAvailableHaplotypes) continue;
                HashSet<Haplotype> intersection = new HashSet<Haplotype>();
                intersection.addAll(haplotypesWithCall);
                intersection.retainAll(haplotypesWithComp);
                if (!intersection.isEmpty()) continue;
                if (!phaseSetMapping.containsKey(call)) {
                    if (phaseSetMapping.containsKey(comp)) {
                        phaseSetMapping.clear();
                        return phaseSetMapping;
                    }
                    phaseSetMapping.put(call, (Pair<Integer, PhaseGroup>)Pair.of((Object)uniqueCounter, (Object)((Object)PhaseGroup.PHASE_01)));
                    phaseSetMapping.put(comp, (Pair<Integer, PhaseGroup>)Pair.of((Object)uniqueCounter, (Object)((Object)PhaseGroup.PHASE_10)));
                    ++uniqueCounter;
                    continue;
                }
                if (phaseSetMapping.containsKey(comp)) continue;
                Pair callPhase = (Pair)phaseSetMapping.get(call);
                phaseSetMapping.put(comp, (Pair<Integer, PhaseGroup>)Pair.of((Object)callPhase.getLeft(), (Object)((Object)(((PhaseGroup)((Object)callPhase.getRight())).equals((Object)PhaseGroup.PHASE_01) ? PhaseGroup.PHASE_10 : PhaseGroup.PHASE_01))));
            }
        }
        return phaseSetMapping;
    }

    @VisibleForTesting
    static List<VariantContext> constructPhaseGroups(List<VariantContext> originalCalls, Map<VariantContext, Pair<Integer, PhaseGroup>> phaseSetMapping, int indexTo) {
        ArrayList<VariantContext> phasedCalls = new ArrayList<VariantContext>(originalCalls);
        for (int count = 0; count < indexTo; ++count) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int index = 0; index < originalCalls.size(); ++index) {
                VariantContext call = originalCalls.get(index);
                if (!phaseSetMapping.containsKey(call) || (Integer)phaseSetMapping.get(call).getLeft() != count) continue;
                indexes.add(index);
            }
            if (indexes.size() < 2) {
                throw new IllegalStateException("Somehow we have a group of phased variants that has fewer than 2 members");
            }
            String uniqueID = AssemblyBasedCallerUtils.createUniqueID(originalCalls.get((Integer)indexes.get(0)));
            int phaseSetID = originalCalls.get((Integer)indexes.get(0)).getStart();
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                VariantContext originalCall = originalCalls.get(index);
                VariantContext phasedCall = AssemblyBasedCallerUtils.phaseVC(originalCall, uniqueID, (PhaseGroup)((Object)phaseSetMapping.get(originalCall).getRight()), phaseSetID);
                phasedCalls.set(index, phasedCall);
            }
        }
        return phasedCalls;
    }

    private static boolean isBiallelicWithOneSiteSpecificAlternateAllele(VariantContext vc) {
        return vc.getAlternateAlleles().stream().filter(AssemblyBasedCallerUtils::isSiteSpecificAltAllele).count() == 1L;
    }

    private static boolean isSiteSpecificAltAllele(Allele a) {
        return !a.isReference() && !a.isNonRefAllele() && !Allele.SPAN_DEL.equals((Object)a);
    }

    private static String createUniqueID(VariantContext vc) {
        return String.format("%d_%s_%s", vc.getStart(), vc.getReference().getDisplayString(), vc.getAlternateAllele(0).getDisplayString());
    }

    private static VariantContext phaseVC(VariantContext vc, String ID, PhaseGroup phaseGT, int phaseSetID) {
        ArrayList<Genotype> phasedGenotypes = new ArrayList<Genotype>();
        for (Genotype g : vc.getGenotypes()) {
            List alleles = g.getAlleles();
            ArrayList newAlleles = new ArrayList(alleles);
            int phasedAltAlleleIndex = phaseGT.getAltAlleleIndex();
            if (g.isHet() && !AssemblyBasedCallerUtils.isSiteSpecificAltAllele((Allele)newAlleles.get(phasedAltAlleleIndex))) {
                Collections.reverse(newAlleles);
            }
            Genotype genotype = new GenotypeBuilder(g).alleles(newAlleles).phased(true).attribute("PID", (Object)ID).attribute("PGT", (Object)phaseGT.getDescription()).attribute("PS", (Object)phaseSetID).make();
            phasedGenotypes.add(genotype);
        }
        return new VariantContextBuilder(vc).genotypes(phasedGenotypes).make();
    }

    public static Set<Allele> getAllelesConsistentWithGivenAlleles(List<VariantContext> givenAlleles, VariantContext mergedVC) {
        if (givenAlleles.isEmpty()) {
            return Collections.emptySet();
        }
        List givenAltAndRefAllelesInOriginalContext = AssemblyBasedCallerUtils.getVariantContextsFromGivenAlleles(mergedVC.getStart(), givenAlleles, false).stream().flatMap(vc -> vc.getAlternateAlleles().stream().map(allele -> ImmutablePair.of((Object)allele, (Object)vc.getReference()))).collect(Collectors.toList());
        return mergedVC.getAlternateAlleles().stream().map(allele -> ImmutablePair.of((Object)allele, (Object)mergedVC.getReference())).filter(altAndRef -> givenAltAndRefAllelesInOriginalContext.stream().anyMatch(givenAltAndRef -> AssemblyBasedCallerUtils.allelesAreConsistent((Pair<Allele, Allele>)givenAltAndRef, (Pair<Allele, Allele>)altAndRef))).map(altAndRefPair -> (Allele)altAndRefPair.getLeft()).collect(Collectors.toSet());
    }

    private static boolean allelesAreConsistent(Pair<Allele, Allele> altAndRef1, Pair<Allele, Allele> altAndRef2) {
        int sizeDiff2;
        Allele alt1 = (Allele)altAndRef1.getLeft();
        Allele alt2 = (Allele)altAndRef2.getLeft();
        if (alt1.isSymbolic() || alt2.isSymbolic()) {
            return false;
        }
        int sizeDiff1 = alt1.length() - ((Allele)altAndRef1.getRight()).length();
        return sizeDiff1 == (sizeDiff2 = alt2.length() - ((Allele)altAndRef2.getRight()).length()) && (alt1.length() < alt2.length() ? alt1.basesMatch(Arrays.copyOf(alt2.getBases(), alt1.length())) : alt2.basesMatch(Arrays.copyOf(alt1.getBases(), alt2.length())));
    }

    static enum PhaseGroup {
        PHASE_01("0|1", 1),
        PHASE_10("1|0", 0);

        private final String description;
        private final int altAlleleIndex;

        private PhaseGroup(String description, int altAlleleIndex) {
            this.description = description;
            this.altAlleleIndex = altAlleleIndex;
        }

        public String getDescription() {
            return this.description;
        }

        public int getAltAlleleIndex() {
            return this.altAlleleIndex;
        }
    }
}

