/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.annotator.TandemRepeat;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingDebugger;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class AssemblyRegionTrimmer {
    private AssemblyRegionArgumentCollection assemblyRegionArgs;
    private SAMSequenceDictionary sequenceDictionary;
    private static final Logger logger = LogManager.getLogger(AssemblyRegionTrimmer.class);

    public AssemblyRegionTrimmer(AssemblyRegionArgumentCollection assemblyRegionArgs, SAMSequenceDictionary sequenceDictionary) {
        this.assemblyRegionArgs = Utils.nonNull(assemblyRegionArgs);
        this.sequenceDictionary = sequenceDictionary;
        assemblyRegionArgs.validate();
    }

    protected Result noVariation(AssemblyRegion targetRegion) {
        return new Result(targetRegion, null, null);
    }

    public Result trim(AssemblyRegion region, SortedSet<VariantContext> variants, ReferenceContext referenceContext) {
        if (this.assemblyRegionArgs.enableLegacyAssemblyRegionTrimming) {
            return this.trimLegacy(region, variants);
        }
        List variantsInRegion = variants.stream().filter(arg_0 -> ((AssemblyRegion)region).overlaps(arg_0)).collect(Collectors.toList());
        if (variantsInRegion.isEmpty()) {
            return this.noVariation(region);
        }
        int minStart = variantsInRegion.stream().mapToInt(VariantContext::getStart).min().getAsInt();
        int maxEnd = variantsInRegion.stream().mapToInt(VariantContext::getEnd).max().getAsInt();
        SimpleInterval variantSpan = new SimpleInterval(region.getContig(), minStart, maxEnd).intersect(region);
        for (VariantContext vc : variantsInRegion) {
            int padding = this.assemblyRegionArgs.snpPaddingForGenotyping;
            if (vc.isIndel()) {
                padding = this.assemblyRegionArgs.indelPaddingForGenotyping;
                Pair<List<Integer>, byte[]> numRepeatsAndUnit = TandemRepeat.getNumTandemRepeatUnits(referenceContext, vc);
                if (numRepeatsAndUnit != null && numRepeatsAndUnit.getRight() != null) {
                    int repeatLength = numRepeatsAndUnit.getRight() == null ? 0 : ((byte[])numRepeatsAndUnit.getRight()).length;
                    int mostRepeats = ((List)numRepeatsAndUnit.getLeft()).stream().max(Integer::compareTo).orElse(0);
                    int longestSTR = mostRepeats * repeatLength;
                    padding = this.assemblyRegionArgs.strPaddingForGenotyping + longestSTR;
                }
            }
            minStart = Math.min(minStart, Math.max(vc.getStart() - padding, 1));
            maxEnd = Math.max(maxEnd, vc.getEnd() + padding);
        }
        SimpleInterval paddedVariantSpan = new SimpleInterval(region.getContig(), minStart, maxEnd).intersect(region.getPaddedSpan());
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            HaplotypeCallerGenotypingDebugger.println("Padded and trimmed the region to this span: " + paddedVariantSpan);
        }
        return new Result(region, variantSpan, paddedVariantSpan);
    }

    public Result trimLegacy(AssemblyRegion originalRegion, SortedSet<VariantContext> allVariantsWithinExtendedRegion) {
        int padding;
        if (allVariantsWithinExtendedRegion.isEmpty()) {
            return this.noVariation(originalRegion);
        }
        LinkedList<VariantContext> withinActiveRegion = new LinkedList<VariantContext>();
        SimpleInterval originalRegionRange = originalRegion.getSpan();
        boolean foundNonSnp = false;
        SimpleInterval variantSpan = null;
        for (VariantContext vc : allVariantsWithinExtendedRegion) {
            SimpleInterval vcLoc = new SimpleInterval((Locatable)vc);
            if (!originalRegionRange.overlaps(vcLoc)) continue;
            foundNonSnp = foundNonSnp || !vc.isSNP();
            variantSpan = variantSpan == null ? vcLoc : variantSpan.spanWith(vcLoc);
            withinActiveRegion.add(vc);
        }
        int n = padding = foundNonSnp ? this.assemblyRegionArgs.indelPaddingForGenotyping : this.assemblyRegionArgs.snpPaddingForGenotyping;
        if (variantSpan == null) {
            return this.noVariation(originalRegion);
        }
        SimpleInterval maximumSpan = originalRegionRange.expandWithinContig(this.assemblyRegionArgs.maxExtensionIntoRegionPadding, this.sequenceDictionary);
        SimpleInterval idealSpan = variantSpan.expandWithinContig(padding, this.sequenceDictionary);
        SimpleInterval finalSpan = maximumSpan.intersect(idealSpan).mergeWithContiguous(variantSpan);
        SimpleInterval callableSpan = variantSpan;
        Pair<SimpleInterval, SimpleInterval> nonVariantRegions = this.nonVariantTargetRegions(originalRegion, callableSpan);
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            HaplotypeCallerGenotypingDebugger.println("events       : " + withinActiveRegion);
            HaplotypeCallerGenotypingDebugger.println("region       : " + originalRegion);
            HaplotypeCallerGenotypingDebugger.println("callableSpan : " + callableSpan);
            HaplotypeCallerGenotypingDebugger.println("padding      : " + padding);
            HaplotypeCallerGenotypingDebugger.println("idealSpan    : " + idealSpan);
            HaplotypeCallerGenotypingDebugger.println("maximumSpan  : " + maximumSpan);
            HaplotypeCallerGenotypingDebugger.println("finalSpan    : " + finalSpan);
        }
        return new Result(originalRegion, variantSpan, finalSpan);
    }

    private Pair<SimpleInterval, SimpleInterval> nonVariantTargetRegions(AssemblyRegion targetRegion, SimpleInterval variantSpan) {
        boolean postTrimmingRequired;
        SimpleInterval targetRegionRange = targetRegion.getSpan();
        int finalStart = variantSpan.getStart();
        int finalStop = variantSpan.getEnd();
        int targetStart = targetRegionRange.getStart();
        int targetStop = targetRegionRange.getEnd();
        boolean preTrimmingRequired = targetStart < finalStart;
        boolean bl = postTrimmingRequired = targetStop > finalStop;
        if (preTrimmingRequired) {
            String contig = targetRegionRange.getContig();
            return postTrimmingRequired ? Pair.of((Object)new SimpleInterval(contig, targetStart, finalStart - 1), (Object)new SimpleInterval(contig, finalStop + 1, targetStop)) : Pair.of((Object)new SimpleInterval(contig, targetStart, finalStart - 1), null);
        }
        if (postTrimmingRequired) {
            return Pair.of(null, (Object)new SimpleInterval(targetRegionRange.getContig(), finalStop + 1, targetStop));
        }
        return Pair.of(null, null);
    }

    public final class Result {
        protected final AssemblyRegion originalRegion;
        protected final SimpleInterval variantSpan;
        protected final SimpleInterval paddedSpan;

        protected Result(AssemblyRegion originalRegion, SimpleInterval variantSpan, SimpleInterval paddedSpan) {
            this.originalRegion = originalRegion;
            this.variantSpan = variantSpan;
            this.paddedSpan = paddedSpan;
            Utils.validateArg(paddedSpan == null || variantSpan == null || paddedSpan.contains(variantSpan), "the padded span must include the variant span");
        }

        public boolean isVariationPresent() {
            return this.variantSpan != null;
        }

        public AssemblyRegion getVariantRegion() {
            Utils.validate(this.isVariationPresent(), "There is no variation present.");
            return this.originalRegion.trim(this.variantSpan, this.paddedSpan);
        }

        public Optional<AssemblyRegion> nonVariantLeftFlankRegion() {
            if (!this.isVariationPresent()) {
                return Optional.of(this.originalRegion);
            }
            if (this.originalRegion.getStart() < this.variantSpan.getStart()) {
                SimpleInterval leftFlank = new SimpleInterval(this.originalRegion.getContig(), this.originalRegion.getStart(), this.variantSpan.getStart() - 1);
                return Optional.of(this.originalRegion.trim(leftFlank, ((AssemblyRegionTrimmer)AssemblyRegionTrimmer.this).assemblyRegionArgs.assemblyRegionPadding));
            }
            return Optional.empty();
        }

        public Optional<AssemblyRegion> nonVariantRightFlankRegion() {
            if (this.variantSpan.getEnd() < this.originalRegion.getEnd()) {
                SimpleInterval rightFlank = new SimpleInterval(this.originalRegion.getContig(), this.variantSpan.getEnd() + 1, this.originalRegion.getEnd());
                return Optional.of(this.originalRegion.trim(rightFlank, ((AssemblyRegionTrimmer)AssemblyRegionTrimmer.this).assemblyRegionArgs.assemblyRegionPadding));
            }
            return Optional.empty();
        }
    }
}

