/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.AbstractReadThreadingGraph;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;

public final class AssemblyResult {
    private final Status status;
    private final AbstractReadThreadingGraph threadingGraph;
    private final SeqGraph graph;
    private Set<Haplotype> discoveredHaplotypes;
    private boolean containsSuspectHaplotypes;

    public AssemblyResult(Status status, SeqGraph graph, AbstractReadThreadingGraph threadingGraph) {
        Utils.nonNull(status, "status cannot be null");
        Utils.validateArg(status == Status.FAILED || graph != null || threadingGraph != null, "graph is null but status is " + (Object)((Object)status));
        this.status = status;
        this.graph = graph;
        this.threadingGraph = threadingGraph;
    }

    public AbstractReadThreadingGraph getThreadingGraph() {
        return this.threadingGraph;
    }

    public Status getStatus() {
        return this.status;
    }

    public SeqGraph getSeqGraph() {
        return this.graph;
    }

    public int getKmerSize() {
        return this.graph == null ? this.threadingGraph.getKmerSize() : this.graph.getKmerSize();
    }

    public Set<Haplotype> getDiscoveredHaplotypes() {
        return this.discoveredHaplotypes;
    }

    public void setDiscoveredHaplotypes(Set<Haplotype> discoveredHaplotypes) {
        this.discoveredHaplotypes = discoveredHaplotypes;
    }

    public boolean containsSuspectHaplotypes() {
        return this.containsSuspectHaplotypes;
    }

    public void setContainsSuspectHaplotypes(boolean containsSuspectHaplotypes) {
        this.containsSuspectHaplotypes = containsSuspectHaplotypes;
    }

    public static enum Status {
        FAILED,
        JUST_ASSEMBLED_REFERENCE,
        ASSEMBLED_SOME_VARIATION;

    }
}

