/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyResult;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.AbstractReadThreadingGraph;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.EventMap;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class AssemblyResultSet {
    private final Map<Integer, AssemblyResult> assemblyResultByKmerSize;
    private final Set<Haplotype> haplotypes;
    private final Map<Haplotype, AssemblyResult> assemblyResultByHaplotype;
    private AssemblyRegion regionForGenotyping;
    private byte[] fullReferenceWithPadding;
    private SimpleInterval paddedReferenceLoc;
    private boolean variationPresent;
    private Haplotype refHaplotype;
    private final SortedSet<Integer> kmerSizes;
    private SortedSet<VariantContext> variationEvents;
    private OptionalInt lastMaxMnpDistanceUsed = OptionalInt.empty();
    private boolean debug;
    private static final Logger logger = LogManager.getLogger(AssemblyResultSet.class);

    public AssemblyResultSet() {
        this.assemblyResultByKmerSize = new LinkedHashMap<Integer, AssemblyResult>(4);
        this.haplotypes = new LinkedHashSet<Haplotype>(10);
        this.assemblyResultByHaplotype = new LinkedHashMap<Haplotype, AssemblyResult>(10);
        this.kmerSizes = new TreeSet<Integer>();
    }

    public AssemblyResultSet trimTo(AssemblyRegion trimmedAssemblyRegion) {
        Map<Haplotype, Haplotype> originalByTrimmedHaplotypes = this.calculateOriginalByTrimmedHaplotypes(trimmedAssemblyRegion.getPaddedSpan());
        if (this.refHaplotype == null) {
            throw new IllegalStateException("refHaplotype is null");
        }
        Utils.nonNull(trimmedAssemblyRegion);
        AssemblyResultSet result = new AssemblyResultSet();
        for (Haplotype trimmed : originalByTrimmedHaplotypes.keySet()) {
            Haplotype original = originalByTrimmedHaplotypes.get((Object)trimmed);
            if (original == null) {
                throw new IllegalStateException("all trimmed haplotypes must have an original one");
            }
            AssemblyResult as = this.assemblyResultByHaplotype.get((Object)original);
            if (as == null) {
                result.add(trimmed);
                continue;
            }
            result.add(trimmed, as);
        }
        result.setRegionForGenotyping(trimmedAssemblyRegion);
        result.setFullReferenceWithPadding(this.fullReferenceWithPadding);
        result.setPaddedReferenceLoc(this.paddedReferenceLoc);
        result.variationPresent = this.haplotypes.stream().anyMatch(Allele::isNonReference);
        if (result.refHaplotype == null) {
            throw new IllegalStateException("missing reference haplotype in the trimmed set");
        }
        return result;
    }

    private Map<Haplotype, Haplotype> calculateOriginalByTrimmedHaplotypes(Locatable span) {
        if (this.debug) {
            logger.info("Trimming active region " + this.getRegionForGenotyping() + " with " + this.getHaplotypeCount() + " haplotypes");
        }
        List<Haplotype> haplotypeList = this.getHaplotypeList();
        Map<Haplotype, Haplotype> originalByTrimmedHaplotypes = this.trimDownHaplotypes(span, haplotypeList);
        ArrayList<Haplotype> trimmedHaplotypes = new ArrayList<Haplotype>(originalByTrimmedHaplotypes.keySet());
        Collections.sort(trimmedHaplotypes, Haplotype.SIZE_AND_BASE_ORDER);
        Map<Haplotype, Haplotype> sortedOriginalByTrimmedHaplotypes = AssemblyResultSet.mapOriginalToTrimmed(originalByTrimmedHaplotypes, trimmedHaplotypes);
        if (this.debug) {
            logger.info("Trimmed region to " + span + " and reduced number of haplotypes from " + haplotypeList.size() + " to only " + trimmedHaplotypes.size());
            for (Haplotype remaining : trimmedHaplotypes) {
                logger.info("Remains: " + (Object)((Object)remaining) + " cigar " + remaining.getCigar());
            }
        }
        return sortedOriginalByTrimmedHaplotypes;
    }

    private Map<Haplotype, Haplotype> trimDownHaplotypes(Locatable span, List<Haplotype> haplotypeList) {
        HashMap<Haplotype, Haplotype> originalByTrimmedHaplotypes = new HashMap<Haplotype, Haplotype>();
        for (Haplotype h : haplotypeList) {
            Haplotype trimmed = h.trim(span);
            if (trimmed != null) {
                if (originalByTrimmedHaplotypes.containsKey((Object)trimmed)) {
                    if (!trimmed.isReference()) continue;
                    originalByTrimmedHaplotypes.remove((Object)trimmed);
                    originalByTrimmedHaplotypes.put(trimmed, h);
                    continue;
                }
                originalByTrimmedHaplotypes.put(trimmed, h);
                continue;
            }
            if (h.isReference()) {
                throw new IllegalStateException("trimming eliminates the reference haplotype");
            }
            if (!this.debug) continue;
            logger.info("Throwing out haplotype " + (Object)((Object)h) + " with cigar " + h.getCigar() + " because it starts with or ends with an insertion or deletion when trimmed to " + span);
        }
        return originalByTrimmedHaplotypes;
    }

    private static Map<Haplotype, Haplotype> mapOriginalToTrimmed(Map<Haplotype, Haplotype> originalByTrimmedHaplotypes, List<Haplotype> trimmedHaplotypes) {
        LinkedHashMap<Haplotype, Haplotype> sortedOriginalByTrimmedHaplotypes = new LinkedHashMap<Haplotype, Haplotype>(trimmedHaplotypes.size());
        for (Haplotype trimmed : trimmedHaplotypes) {
            sortedOriginalByTrimmedHaplotypes.put(trimmed, originalByTrimmedHaplotypes.get((Object)trimmed));
        }
        return sortedOriginalByTrimmedHaplotypes;
    }

    public Haplotype getReferenceHaplotype() {
        return this.refHaplotype;
    }

    public boolean isVariationPresent() {
        return this.variationPresent && this.haplotypes.size() > 1;
    }

    private void debugDump(PrintWriter pw) {
        if (this.getHaplotypeList().isEmpty()) {
            return;
        }
        pw.println("Active Region " + this.regionForGenotyping.getSpan());
        pw.println("Extended Act Region " + this.getRegionForGenotyping().getPaddedSpan());
        pw.println("Ref haplotype coords " + this.getHaplotypeList().get(0).getGenomeLocation());
        pw.println("Haplotype count " + this.haplotypes.size());
        HashMap<Integer, Integer> kmerSizeToCount = new HashMap<Integer, Integer>();
        for (Map.Entry<Haplotype, AssemblyResult> e : this.assemblyResultByHaplotype.entrySet()) {
            AssemblyResult as = e.getValue();
            int kmerSize = as.getKmerSize();
            if (kmerSizeToCount.containsKey(kmerSize)) {
                kmerSizeToCount.put(kmerSize, (Integer)kmerSizeToCount.get(kmerSize) + 1);
                continue;
            }
            kmerSizeToCount.put(kmerSize, 1);
        }
        pw.println("Kmer sizes count " + kmerSizeToCount.entrySet().size());
        Object[] kmerSizes = kmerSizeToCount.keySet().toArray(new Integer[kmerSizeToCount.size()]);
        Arrays.sort(kmerSizes);
        pw.println("Kmer sizes values " + Arrays.toString(kmerSizes));
        Object[] objectArray = kmerSizes;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int size = (Integer)objectArray[i];
            pw.println("Kmer size " + size + " count " + kmerSizeToCount.get(size));
        }
    }

    public boolean add(Haplotype h) {
        Utils.nonNull(h, "input haplotype cannot be null");
        Utils.nonNull(h.getGenomeLocation(), "haplotype genomeLocation cannot be null");
        if (this.haplotypes.contains((Object)h)) {
            return false;
        }
        this.haplotypes.add(h);
        this.updateReferenceHaplotype(h);
        return true;
    }

    public boolean add(Haplotype h, AssemblyResult ar) {
        Utils.nonNull(h, "input haplotype cannot be null");
        Utils.nonNull(ar, "input assembly-result cannot be null");
        Utils.nonNull(h.getGenomeLocation(), "the haplotype provided must have a genomic location");
        boolean assemblyResultAdditionReturn = this.add(ar);
        if (this.haplotypes.contains((Object)h)) {
            AssemblyResult previousAr = this.assemblyResultByHaplotype.get((Object)h);
            if (previousAr == null) {
                this.assemblyResultByHaplotype.put(h, ar);
                return true;
            }
            if (!previousAr.equals(ar)) {
                throw new IllegalStateException("there is already a different assembly result for the input haplotype");
            }
            return assemblyResultAdditionReturn;
        }
        this.haplotypes.add(h);
        this.assemblyResultByHaplotype.put(h, ar);
        this.updateReferenceHaplotype(h);
        if (h.isNonReference()) {
            this.variationPresent = true;
        }
        return true;
    }

    private boolean add(AssemblyResult ar) {
        Utils.nonNull(ar);
        int kmerSize = ar.getKmerSize();
        if (this.assemblyResultByKmerSize.containsKey(kmerSize)) {
            if (!this.assemblyResultByKmerSize.get(kmerSize).equals(ar)) {
                throw new IllegalStateException("a different assembly result with the same kmerSize was already added");
            }
            return false;
        }
        this.assemblyResultByKmerSize.put(kmerSize, ar);
        this.kmerSizes.add(kmerSize);
        return true;
    }

    public AssemblyRegion getRegionForGenotyping() {
        return this.regionForGenotyping;
    }

    public void setRegionForGenotyping(AssemblyRegion regionForGenotyping) {
        this.regionForGenotyping = regionForGenotyping;
    }

    public byte[] getFullReferenceWithPadding() {
        return this.fullReferenceWithPadding;
    }

    public void setFullReferenceWithPadding(byte[] fullReferenceWithPadding) {
        this.fullReferenceWithPadding = fullReferenceWithPadding;
    }

    public SimpleInterval getPaddedReferenceLoc() {
        return this.paddedReferenceLoc;
    }

    public void setPaddedReferenceLoc(SimpleInterval paddedReferenceLoc) {
        this.paddedReferenceLoc = paddedReferenceLoc;
    }

    public int getHaplotypeCount() {
        return this.haplotypes.size();
    }

    public List<Haplotype> getHaplotypeList() {
        return Arrays.asList(this.haplotypes.toArray(new Haplotype[this.haplotypes.size()]));
    }

    public int getMaximumKmerSize() {
        if (this.kmerSizes.isEmpty()) {
            throw new IllegalStateException("there is yet no kmerSize in this assembly result set");
        }
        return this.kmerSizes.last();
    }

    public boolean hasMultipleKmerSizes() {
        return this.kmerSizes.size() > 1;
    }

    public int getMinimumKmerSize() {
        if (this.kmerSizes.isEmpty()) {
            throw new IllegalStateException("there is yet no kmerSize in this assembly result set");
        }
        return this.kmerSizes.first();
    }

    public AbstractReadThreadingGraph getUniqueReadThreadingGraph(int kmerSize) {
        AssemblyResult assemblyResult = this.assemblyResultByKmerSize.get(kmerSize);
        if (assemblyResult == null) {
            return null;
        }
        return assemblyResult.getThreadingGraph();
    }

    public void debugDump(Logger logger) {
        String[] lines;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.debugDump(pw);
        String str = sw.toString();
        for (String line : lines = str.split("\n")) {
            if (line.isEmpty()) continue;
            logger.debug(line);
        }
    }

    private void updateReferenceHaplotype(Haplotype newHaplotype) {
        if (!newHaplotype.isReference()) {
            return;
        }
        if (this.refHaplotype != null) {
            throw new IllegalStateException("the assembly-result-set already have a reference haplotype that is different");
        }
        this.refHaplotype = newHaplotype;
    }

    public SortedSet<VariantContext> getVariationEvents(int maxMnpDistance) {
        ParamUtils.isPositiveOrZero(maxMnpDistance, "maxMnpDistance may not be negative.");
        boolean sameMnpDistance = this.lastMaxMnpDistanceUsed.isPresent() && maxMnpDistance == this.lastMaxMnpDistanceUsed.getAsInt();
        this.lastMaxMnpDistanceUsed = OptionalInt.of(maxMnpDistance);
        if (this.variationEvents == null || !sameMnpDistance || this.haplotypes.stream().anyMatch(hap -> hap.isNonReference() && hap.getEventMap() == null)) {
            this.regenerateVariationEvents(maxMnpDistance);
        }
        return this.variationEvents;
    }

    public void regenerateVariationEvents(int maxMnpDistance) {
        List<Haplotype> haplotypeList = this.getHaplotypeList();
        EventMap.buildEventMapsForHaplotypes(haplotypeList, this.fullReferenceWithPadding, this.paddedReferenceLoc, this.debug, maxMnpDistance);
        this.variationEvents = AssemblyResultSet.getAllVariantContexts(haplotypeList);
        this.lastMaxMnpDistanceUsed = OptionalInt.of(maxMnpDistance);
        this.variationPresent = haplotypeList.stream().anyMatch(Allele::isNonReference);
    }

    private static SortedSet<VariantContext> getAllVariantContexts(List<Haplotype> haplotypes) {
        TreeSet<VariantContext> vcs = new TreeSet<VariantContext>(Comparator.comparingInt(VariantContext::getStart).thenComparingInt(vc -> vc.getReference().length()).thenComparing(vc -> vc.getAlternateAllele(0)));
        for (Haplotype h : haplotypes) {
            vcs.addAll(h.getEventMap().getVariantContexts());
        }
        return vcs;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

